/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.events.EventStats;
import org.eclipse.core.internal.resources.SaveManager;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class DelayedSnapshotJob
extends Job {
    private static final String MSG_SNAPSHOT = Policy.bind("resources.snapshot");
    private SaveManager saveManager;

    public DelayedSnapshotJob(SaveManager manager) {
        super(MSG_SNAPSHOT);
        this.saveManager = manager;
        this.setRule(ResourcesPlugin.getWorkspace().getRoot());
        this.setSystem(true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus run(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (ResourcesPlugin.getWorkspace() == null) {
            return Status.OK_STATUS;
        }
        IStatus result = Status.OK_STATUS;
        try {
            try {
                EventStats.startSnapshot();
                result = this.saveManager.save(2, null, Policy.monitorFor(null));
            }
            catch (CoreException e) {
                result = e.getStatus();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.saveManager.operationCount = 0;
            this.saveManager.snapshotRequested = false;
            EventStats.endSnapshot();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.saveManager.operationCount = 0;
            this.saveManager.snapshotRequested = false;
        }
        EventStats.endSnapshot();
        return result;
    }
}

