/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchPage;

public class OpenedPerspectivesMenu
extends ContributionItem {
    private IWorkbenchWindow window;
    private boolean showSeparator;
    private static final int MAX_TEXT_LENGTH = 40;

    public OpenedPerspectivesMenu(IWorkbenchWindow window, String id, boolean showSeparator) {
        super(id);
        this.window = window;
        this.showSeparator = showSeparator;
    }

    private String calcText(int number, IPerspectiveDescriptor persp) {
        StringBuffer sb = new StringBuffer();
        if (number < 10) {
            sb.append('&');
        }
        sb.append(number);
        sb.append(' ');
        String suffix = persp.getLabel();
        if (suffix.length() <= 40) {
            sb.append(suffix);
        } else {
            sb.append(suffix.substring(0, 20));
            sb.append("...");
            sb.append(suffix.substring(suffix.length() - 20));
        }
        return sb.toString();
    }

    public void fill(Menu menu, int index) {
        IWorkbenchPage page = this.window.getActivePage();
        if (page == null) {
            return;
        }
        if (this.showSeparator) {
            new MenuItem(menu, 2, index);
            ++index;
        }
        IPerspectiveDescriptor activePersp = page.getPerspective();
        IPerspectiveDescriptor[] descriptors = ((WorkbenchPage)page).getOpenedPerspectives();
        int count = 1;
        int i = 0;
        while (i < descriptors.length) {
            final IPerspectiveDescriptor desc = descriptors[i];
            MenuItem mi = new MenuItem(menu, 16, index);
            mi.setSelection(desc == activePersp);
            mi.setText(this.calcText(count, desc));
            mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IWorkbenchPage page = OpenedPerspectivesMenu.this.window.getActivePage();
                    if (page != null) {
                        page.setPerspective(desc);
                    }
                }
            });
            ++index;
            ++count;
            ++i;
        }
    }

    public boolean isDynamic() {
        return true;
    }
}

