/* DecoderContext.h */
/* 2008/11/05       */

#pragma once

#ifndef DECLSPEC_NAKED
#define DECLSPEC_NAKED __declspec(naked)
#endif

#include "MemoryPool.h"

/* */

struct Error;

typedef struct Error Error_t;

/* Error */
struct Error {

	const char* Type;
	const char* Message;

	UINT32 Code;

	VOID* EIP;

	Error_t* Next;

}; /* Error */

Error_t* Error_Create(
	MemoryPool_t* pool,
	const char*   type,
	const char*   message,
	UINT32        code,
	VOID*         eip,
	Error_t*      next);

VOID* Error_GetEIP();

#define THROW(v,t,m,c) \
v->Error = Error_Create(v->Pool,(t),(m),(c),Error_GetEIP(),v->Error); goto ErrorEnd;

#define THROW0(v,t,m) THROW(v,t,m,0)

/* DecoderContext */
struct DecoderContext {

	MemoryPool_t* Pool;

	Error_t* Error;

}; /* DecoderContext */

typedef struct DecoderContext DecoderContext_t;

/* */

INT32 ilog(UINT32 n);

/* */

