// QAXFileSpec.h
// 2008/11/27

#pragma once

namespace QAX {

#pragma pack(push, 4)

// FileHeader
struct FileHeader {

	BYTE Signature[4];

	UINT32 Sig1;
	UINT32 Sig2;
	UINT32 Sig3;

	UINT64 ContentPos;
	UINT64 ContentSize;

	UINT64 ItemsPos;
	UINT32 ItemsSize;
	UINT32 ItemsIndex;

	UINT64 StringsPos;
	UINT32 StringsSize;
	UINT32 StringsIndex;

	UINT64 SetupsPos;
	UINT32 SetupsSize;
	UINT32 SetupsIndex;

	UINT64 IndexsPos;
	UINT32 IndexsSize;
	UINT32 IndexsIndex;

}; // FileHeader

// QASHeader
struct QASHeader {

	BYTE Signature[4];

	BYTE Format[12];

	UINT64 Samples;
	UINT64 Reserved;

	UINT64 ContentPos;
	UINT64 ContentSize;

	UINT64 MetaDataPos;
	UINT32 MetaDataSize;
	UINT32 MetaDataIndex;

}; // QASHeader

#pragma pack(pop)

} // namespace QAX

