/* VorbisDecoder.h */
/* 2008/11/06      */

#pragma once

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

/* */

BOOL QV_Initialize(void);

BOOL QV_SetEnableSSE2(BOOL b);

/* */

struct QVorbisDecoderSetup;

typedef struct QVorbisDecoderSetup QVorbisDecoderSetup_t;

QVorbisDecoderSetup_t* QV_CreateDecoderSetup(void);

void QV_ReleaseDecoderSetup(QVorbisDecoderSetup_t* setup);

BOOL QV_SetupDecoderSetup(
	QVorbisDecoderSetup_t* setup,
	const VOID*            id_packet,
	SIZE_T                 id_size,
	const VOID*            setup_packet,
	SIZE_T                 setup_size);

INT32 QV_GetDecoderSetupChannels(
	QVorbisDecoderSetup_t* setup);

INT32 QV_GetDecoderSetupSamplingRate(
	QVorbisDecoderSetup_t* setup);

/* */

struct QVorbisDecoder;

typedef struct QVorbisDecoder QVorbisDecoder_t;

QVorbisDecoder_t* QV_CreateDecoder(void);

void QV_ReleaseDecoder(QVorbisDecoder_t* d);

BOOL QV_SetupDecoder(
	QVorbisDecoder_t*      d,
	QVorbisDecoderSetup_t* setup,
	SIZE_T                 size);

struct QV_Output {

	INT32 Channels;
	INT32 Length;

	const FLOAT* Output[2];

};

typedef struct QV_Output QV_Output_t;

BOOL QV_DecodeFrame(
	QVorbisDecoder_t* d,
	const VOID*       packet,
	SIZE_T            size,
	QV_Output_t*      output);

void QV_ResetDecoder(
	QVorbisDecoder_t* d);

/* */

struct QV_Convert {

	const INT16* Sample;

	INT32 Samples;

};

typedef struct QV_Convert QV_Convert_t;

BOOL QV_ConvertFrame(
	QVorbisDecoder_t*  d,
	const QV_Output_t* output,
	QV_Convert_t*      convert);

/* */

void QV_ResetDecoderChecker(
	QVorbisDecoder_t* d);

BOOL QV_CheckDecoderChecker(
	QVorbisDecoder_t* d,
	const VOID*       packet,
	SIZE_T            size,
	INT32*            samples);

/* */

#define QVH_RES   0
#define QVH_CC    1
#define QVH_SE    2
#define QVH_IMDCT 3
#define QVH_PCM   4

void QV_SetDecoderTestType(
	QVorbisDecoder_t* d,
	INT32             type);

void QV_TestDecoder(
	QVorbisDecoder_t* d,
	QV_Output_t*      output);

/* */

struct QVorbisSamplesChecker;

typedef struct QVorbisSamplesChecker QVorbisSamplesChecker_t;

QVorbisSamplesChecker_t* QV_CreateSamplesChecker(void);

void QV_ReleaseSamplesChecker(QVorbisSamplesChecker_t* t);

BOOL QV_SetupSamplesChecker(
	QVorbisSamplesChecker_t* t,
	QVorbisDecoderSetup_t*   setup);

void QV_ResetSamplesChecker(QVorbisSamplesChecker_t* t);

BOOL QV_CheckSamplesChecker(
	QVorbisSamplesChecker_t* t,
	const VOID*              packet,
	SIZE_T                   size,
	INT32*                   samples);

/* */

#ifdef __cplusplus_cli

/* for .NET Interop Dummy */

struct QVorbisDecoderSetup   { };
struct QVorbisDecoder        { };
struct QVorbisSamplesChecker { };

#endif /* __cplusplus_cli */

/* */

#ifdef __cplusplus
}
#endif /* __cplusplus */

