/* DecoderSetup.h */
/* 2008/11/06     */

#pragma once

#include "HuffmanDecoder.h"
#include "Floor1Decoder.h"
#include "ResidueDecoder.h"
#include "TransformDecoder.h"

/* */

enum {
	V_PACKET_ID      = 1,
	V_PACKET_COMMENT = 3,
	V_PACKET_SETUP   = 5
};

/* */

/* MappingSetup */
struct MappingSetup {

	INT32 CouplingSteps;

	UINT8 Magnitude;
	UINT8 Angle;

	UINT8 Floor;
	UINT8 Residue;

}; /* MappingSetup */

typedef struct MappingSetup MappingSetup_t;

/* ModeSetup */
struct ModeSetup {

	UINT8 BlockFlag;
	UINT8 Mapping;

}; /* ModeSetup */

typedef struct ModeSetup ModeSetup_t;

/* DecoderSetup */
struct DecoderSetup {

	/* ID */

	INT32 Channels;
	INT32 SampleRate;

	INT32 BlockSize0;
	INT32 BlockSize1;

	/* Setup */

	INT32             HuffmanCount;
	HuffmanDecoder_t* HuffmanDecoder;

	INT32          Floor1Count;
	Floor1Setup_t* Floor1Setup;

	INT32           ResidueCount;
	ResidueSetup_t* ResidueSetup;

	INT32           MappingCount;
	MappingSetup_t* MappingSetup;

	INT32        ModeCount;
	ModeSetup_t* ModeSetup;

	INT32 ModeBits;

	/* Transform */

	WindowingDecoder_t* Windowing0;
	WindowingDecoder_t* Windowing1;

}; /* DecoderSetup */

typedef struct DecoderSetup DecoderSetup_t;

/* */

BOOL DecoderSetup_Id(
	DecoderContext_t* ctx,
	BitDecoder_t*     d,
	DecoderSetup_t*   setup);

BOOL DecoderSetup_Setup(
	DecoderContext_t* ctx,
	BitDecoder_t*     d,
	DecoderSetup_t*   setup);

/* */

