<?php
class index extends myQuicty {

// utilitiy method

function assign_item_view($limit, $order='desc') {
	if(file_exists($this->home_dir.'/lib/Pages/item.class.php')) {
		require_once 'item.class.php';
		$this->item_obj = new item($this->home_dir);
		$this->item_obj->set_sort_option('item.id', $order);
		$list_table = $this->item_obj->list_records('', $limit);
		$this->assign('table_view',$this->item_obj->list->display_table_value($list_table));
		$this->assign('item_subject',$this->W['item']);	
	}
}

// dispatch actions

// prepare dispatch action
function pre_dispatch_index() {
	parent::pre_dispatch_index();
	$this->caching = 0;  // caching page flag: 0 = none; 1 = simple; 2 = each query
	$this->cache_id = get_uri_id();
	return true;
}

// top page
function dispatch_index() {
	if($this->C['TOP_CONTENTS']=='interactive') {
		$this->assign_item_view(10);
	}
	$this->assign_page_and_pathlist($this->W['site_name']);
	return $this->display($this->current_template);
}

// atom.xml for RSS
function dispatch_atom() {
	$this->caching = 2; // caching page flag: 0 = none; 1 = simple; 2 = each query
	$this->cache_lifetime = 3600; // cache life time by seconds
	if(!$this->is_cached($this->current_template,$this->cache_id)) {
		$this->assign_item_view(10);
	}
	return $this->display_xml($this->current_template, $this->cache_id);
}

// sitemap.xml for Google web master tools
function dispatch_sitemap() {
	$this->caching = 2; // caching page flag: 0 = none; 1 = simple; 2 = each query
	$this->cache_lifetime = 3600; // cache life time by seconds
	if(!$this->is_cached($this->current_template,$this->cache_id)) {
		$this->assign_item_view(10, 'asc');
	}
	return $this->display_xml($this->current_template, $this->cache_id);
}

// Set page parts
function assign_page_and_pathlist($page_name) {
	$this->set_pathlist('/',$this->W['top']);
	if($this->Quicty['action']!='index') {
		$this->add_pathlist('/',$page_name);
	}
	$this->page['name'] = $page_name;
	$this->assign('page',$this->page);
	
	$this->meta['description'] = $this->CE('');
	$this->meta['keywords'] = $this->CE('');
	$this->assign('meta',$this->meta);
}

} // end of index class
?>