<?php
class add_page_base extends myQuicty {

function __construct($options) {
	parent::__construct();
	$this->init_field_define();
	$this->template_dir ='';
	$this->left_delimiter = '<!--{';
	$this->right_delimiter = '}-->';

	$this->Quicty_modules = $options['Quicty_modules'];
	$this->application_id = $options['application_id'];
	$this->application_path = $options['application_path'];
	$this->db_name = $options['db_name'];
	$this->page_name = $options['page_name'];
	$this->page_title = $options['page_title'];
	$this->data_name = $options['data_name'];
	$this->page_type = $options['page_type'];
	//
	$this->options = $options;

	switch($options['folder_id']) {
		case '-1' : // top page
			$this->level = 'single';
			break;
		case 0 : // root level
			$this->level = 'dual';
			break;
		default:
			$this->level = 'triple';
			$this->folder_name = $options['folder_name'];
			break;
	}

	$this->page_type_map = array(
				'single'=>array('single'=>1,'multi'=>2,'upload'=>7,'amazonsearch'=>10,'googlemaps'=>13,'blank'=>16),
				'dual'=>array('single'=>3,'multi'=>4,'upload'=>8,'amazonsearch'=>11,'googlemaps'=>14,'blank'=>17),
				'triple'=>array('single'=>5,'multi'=>6,'upload'=>9,'amazonsearch'=>12,'googlemaps'=>15,'blank'=>18)
				);
	$this->type_no = $this->page_type_map[$this->level][$this->page_type];
	
	$this->init_values();

}

function init_values() {
	$this->use_template = array(
				1=>array('source'=>array(1=>'view/single/index.html'),
						'target'=>array(1=>'view/index.html')),
				2=>array('source'=>array(1=>'view/multi/index.html','view/multi/info.html','view/multi/batch_update.html'),
						'target'=>array(1=>'view/index.html','view/info.html','view/batch_update.html')),
				3=>array('source'=>array(1=>'view/multi_single/index.html'),
						'target'=>array(1=>'view/%page%/index.html')),
				4=>array('source'=>array(1=>'view/multi/index.html','view/multi/info.html','view/multi/batch_update.html'),
						'target'=>array(1=>'view/%page%/index.html','view/%page%/info.html','view/%page%/batch_update.html')),
				5=>array('source'=>array(1=>'view/multi_single/index.html'),
						'target'=>array(1=>'view/%subdir%/%page%/index.html')),
				6=>array('source'=>array(1=>'view/multi/index.html','view/multi/info.html','view/multi/batch_update.html'),
						'target'=>array(1=>'view/%subdir%/%page%/index.html','view/%subdir%/%page%/info.html','view/%subdir%/%page%/batch_update.html')),
				7=>array('source'=>array(1=>'view/single/upload.html'),
						'target'=>array(1=>'view/index.html')),
				8=>array('source'=>array(1=>'view/single/upload.html'),
						'target'=>array(1=>'view/%page%/upload.html')),
				9=>array('source'=>array(1=>'view/single/upload.html'),
						'target'=>array(1=>'view/%subdir%/%page%/upload.html')),
				10=>array('source'=>array(1=>'view/single/amazon_search.html'),
						'target'=>array(1=>'view/index.html')),
				11=>array('source'=>array(1=>'view/single/amazon_search.html'),
						'target'=>array(1=>'view/%page%/index.html')),
				12=>array('source'=>array(1=>'view/single/amazon_search.html'),
						'target'=>array(1=>'view/%subdir%/%page%/index.html')),
				13=>array('source'=>array(1=>'view/single/google_maps.html','view/multi/info.html'),
						'target'=>array(1=>'view/index.html','view/info.html')),
				14=>array('source'=>array(1=>'view/single/google_maps.html','view/multi/info.html'),
						'target'=>array(1=>'view/%page%/index.html','view/%page%/info.html')),
				15=>array('source'=>array(1=>'view/single/google_maps.html','view/multi/info.html'),
						'target'=>array(1=>'view/%subdir%/%page%/index.html','view/%subdir%/%page%/info.html')),
				16=>array('source'=>array(1=>'view/single/blank.html'),
						'target'=>array(1=>'view/index.html')),
				17=>array('source'=>array(1=>'view/single/blank.html'),
						'target'=>array(1=>'view/%page%/index.html')),
				18=>array('source'=>array(1=>'view/single/blank.html'),
						'target'=>array(1=>'view/%subdir%/%page%/index.html')),
				);
	$this->use_class = array(
				1=>array('source'=>array(
							1=>'lib/Pages/index.class.tpl',
							2=>'lib/Pages/classes/_base.class.tpl',
							3=>'lib/Pages/classes/form_options.class.tpl',
							4=>'lib/Pages/classes/list_options.class.tpl',
							),
						'target'=>array(
							1=>'lib/Pages/index.class.php',
							2=>'lib/Pages/index_classes/_base.class.php',
							3=>'lib/Pages/index_classes/form_options.class.php',
							4=>'lib/Pages/index_classes/list_options.class.php',
							)
						),
				2=>array('source'=>array(
							1=>'lib/Pages/page.class.tpl',
							2=>'lib/Pages/classes/_base.class.tpl',
							3=>'lib/Pages/classes/form_options.class.tpl',
							4=>'lib/Pages/classes/list_options.class.tpl',
							),
						'target'=>array(
							1=>'lib/Pages/index.class.php',
							2=>'lib/Pages/index_classes/_base.class.php',
							3=>'lib/Pages/index_classes/form_options.class.php',
							4=>'lib/Pages/index_classes/list_options.class.php',
							)
						),
				3=>array('source'=>array(
							1=>'lib/Pages/index.class.tpl',
							2=>'lib/Pages/classes/_base.class.tpl',
							3=>'lib/Pages/classes/form_options.class.tpl',
							4=>'lib/Pages/classes/list_options.class.tpl',
							),
						'target'=>array(
							1=>'lib/Pages/%page%.class.php',
							2=>'lib/Pages/%page%_classes/_base.class.php',
							3=>'lib/Pages/%page%_classes/form_options.class.php',
							4=>'lib/Pages/%page%_classes/list_options.class.php',
							)
						),
				4=>array('source'=>array(
							1=>'lib/Pages/page.class.tpl',
							2=>'lib/Pages/classes/_base.class.tpl',
							3=>'lib/Pages/classes/form_options.class.tpl',
							4=>'lib/Pages/classes/list_options.class.tpl',
							),
						'target'=>array(
							1=>'lib/Pages/%page%.class.php',
							2=>'lib/Pages/%page%_classes/_base.class.php',
							3=>'lib/Pages/%page%_classes/form_options.class.php',
							4=>'lib/Pages/%page%_classes/list_options.class.php',
							)
						),
				5=>array('source'=>array(
							1=>'lib/Pages/index.class.tpl',
							2=>'lib/Pages/classes/_base.class.tpl',
							3=>'lib/Pages/classes/form_options.class.tpl',
							4=>'lib/Pages/classes/list_options.class.tpl',
							),
						'target'=>array(
							1=>'lib/Pages/%subdir%/%page%.class.php',
							2=>'lib/Pages/%subdir%/%page%_classes/_base.class.php',
							3=>'lib/Pages/%subdir%/%page%_classes/form_options.class.php',
							4=>'lib/Pages/%subdir%/%page%_classes/list_options.class.php',
							)
						),
				6=>array('source'=>array(
							1=>'lib/Pages/page.class.tpl',
							2=>'lib/Pages/classes/_base.class.tpl',
							3=>'lib/Pages/classes/form_options.class.tpl',
							4=>'lib/Pages/classes/list_options.class.tpl',
							),
						'target'=>array(
							1=>'lib/Pages/%subdir%/%page%.class.php',
							2=>'lib/Pages/%subdir%/%page%_classes/_base.class.php',
							3=>'lib/Pages/%subdir%/%page%_classes/form_options.class.php',
							4=>'lib/Pages/%subdir%/%page%_classes/list_options.class.php',
							)
						),
				7=>array('source'=>array(
							1=>'lib/Pages/upload.class.tpl'
							),
						'target'=>array(
							1=>'lib/Pages/index.class.php'
							)
						),
				8=>array('source'=>array(
							1=>'lib/Pages/upload.class.tpl'
							),
						'target'=>array(
							1=>'lib/Pages/%page%.class.php'
							)
						),
				9=>array('source'=>array(
							1=>'lib/Pages/upload.class.tpl'
							),
						'target'=>array(
							1=>'lib/Pages/%subdir%/%page%.class.php'
							)
						),
				10=>array('source'=>array(
							1=>'lib/Pages/amazon_search.class.tpl'
							),
						'target'=>array(
							1=>'lib/Pages/index.class.php'
							)
						),
				11=>array('source'=>array(
							1=>'lib/Pages/amazon_search.class.tpl'
							),
						'target'=>array(
							1=>'lib/Pages/%page%.class.php'
							)
						),
				12=>array('source'=>array(
							1=>'lib/Pages/amazon_search.class.tpl'
							),
						'target'=>array(
							1=>'lib/Pages/%subdir%/%page%.class.php'
							)
						),
				13=>array('source'=>array(
							1=>'lib/Pages/google_maps.class.tpl',
							2=>'lib/Pages/classes/_base.class.tpl',
							3=>'lib/Pages/classes/form_options.class.tpl',
							4=>'lib/Pages/classes/list_options.class.tpl',
							),
						'target'=>array(
							1=>'lib/Pages/index.class.php',
							2=>'lib/Pages/index_classes/_base.class.php',
							3=>'lib/Pages/index_classes/form_options.class.php',
							4=>'lib/Pages/index_classes/list_options.class.php',
							)
						),
				14=>array('source'=>array(
							1=>'lib/Pages/google_maps.class.tpl',
							2=>'lib/Pages/classes/_base.class.tpl',
							3=>'lib/Pages/classes/form_options.class.tpl',
							4=>'lib/Pages/classes/list_options.class.tpl',
							),
						'target'=>array(
							1=>'lib/Pages/%page%.class.php',
							2=>'lib/Pages/%page%_classes/_base.class.php',
							3=>'lib/Pages/%page%_classes/form_options.class.php',
							4=>'lib/Pages/%page%_classes/list_options.class.php',
							)
						),
				15=>array('source'=>array(
							1=>'lib/Pages/google_maps.class.tpl',
							2=>'lib/Pages/classes/_base.class.tpl',
							3=>'lib/Pages/classes/form_options.class.tpl',
							4=>'lib/Pages/classes/list_options.class.tpl',
							),
						'target'=>array(
							1=>'lib/Pages/%subdir%/%page%.class.php',
							2=>'lib/Pages/%subdir%/%page%_classes/_base.class.php',
							3=>'lib/Pages/%subdir%/%page%_classes/form_options.class.php',
							4=>'lib/Pages/%subdir%/%page%_classes/list_options.class.php',
							)
						),
				16=>array('source'=>array(
							1=>'lib/Pages/blank.class.tpl'
							),
						'target'=>array(
							1=>'lib/Pages/index.class.php'
							)
						),
				17=>array('source'=>array(
							1=>'lib/Pages/blank.class.tpl'
							),
						'target'=>array(
							1=>'lib/Pages/%page%.class.php'
							)
						),
				18=>array('source'=>array(
							1=>'lib/Pages/blank.class.tpl'
							),
						'target'=>array(
							1=>'lib/Pages/%subdir%/%page%.class.php'
							)
						),
				);

	$this->use_value = array(
				1=>array('class'=>'index','dir'=>'','page'=>$this->page_name,'title'=>$this->page_title,'data'=>$this->data_name),
				2=>array('class'=>'index','dir'=>'','page'=>$this->page_name,'title'=>$this->page_title,'data'=>$this->data_name),
				3=>array('class'=>$this->page_name,'dir'=>"/$this->page_name",'page'=>$this->page_name,'title'=>$this->page_title,'data'=>$this->data_name),
				4=>array('class'=>$this->page_name,'dir'=>"/$this->page_name",'page'=>$this->page_name,'title'=>$this->page_title,'data'=>$this->data_name),
				5=>array('class'=>$this->page_name,'dir'=>"/$this->folder_name/$this->page_name",'page'=>$this->page_name,'title'=>$this->page_title,'data'=>$this->data_name),
				6=>array('class'=>$this->page_name,'dir'=>"/$this->folder_name/$this->page_name",'page'=>$this->page_name,'title'=>$this->page_title,'data'=>$this->data_name),
				7=>array('class'=>'index','dir'=>'','page'=>$this->page_name,'title'=>$this->page_title,'data'=>$this->data_name),
				8=>array('class'=>$this->page_name,'dir'=>"/$this->page_name",'page'=>$this->page_name,'title'=>$this->page_title,'data'=>$this->data_name),
				9=>array('class'=>$this->page_name,'dir'=>"/$this->folder_name/$this->page_name",'page'=>$this->page_name,'title'=>$this->page_title,'data'=>$this->data_name),
				10=>array('class'=>'index','dir'=>'','page'=>$this->page_name,'title'=>$this->page_title,'data'=>$this->data_name),
				11=>array('class'=>$this->page_name,'dir'=>"/$this->page_name",'page'=>$this->page_name,'title'=>$this->page_title,'data'=>$this->data_name),
				12=>array('class'=>$this->page_name,'dir'=>"/$this->folder_name/$this->page_name",'page'=>$this->page_name,'title'=>$this->page_title,'data'=>$this->data_name),
				13=>array('class'=>'index','dir'=>'','page'=>$this->page_name,'title'=>$this->page_title,'data'=>$this->data_name),
				14=>array('class'=>$this->page_name,'dir'=>"/$this->page_name",'page'=>$this->page_name,'title'=>$this->page_title,'data'=>$this->data_name),
				15=>array('class'=>$this->page_name,'dir'=>"/$this->folder_name/$this->page_name",'page'=>$this->page_name,'title'=>$this->page_title,'data'=>$this->data_name),
				16=>array('class'=>'index','dir'=>'','page'=>$this->page_name,'title'=>$this->page_title,'data'=>$this->data_name),
				17=>array('class'=>$this->page_name,'dir'=>"/$this->page_name",'page'=>$this->page_name,'title'=>$this->page_title,'data'=>$this->data_name),
				18=>array('class'=>$this->page_name,'dir'=>"/$this->folder_name/$this->page_name",'page'=>$this->page_name,'title'=>$this->page_title,'data'=>$this->data_name),
				);

	$this->datasets_value = array(
				'single'=>array(
						array('name'=>'id','type'=>'id'),
						//array('name'=>'name','type'=>'text','label'=>'̾','attr'=>array('size'=>'50','maxlength'=>'50')),
						//array('name'=>'url','type'=>'url','label'=>'URL','attr'=>array('size'=>'50','maxlength'=>'128')),
						),
				'multi'=>array(
						array('name'=>'id','type'=>'id'),
						//array('name'=>'name','type'=>'text','label'=>'̾','attr'=>array('size'=>'50','maxlength'=>'50')),
						//array('name'=>'url','type'=>'url','label'=>'URL','attr'=>array('size'=>'50','maxlength'=>'128')),
						),
				'upload'=>array(
						//array('name'=>'id','type'=>'id',virtual=>'yes'),
						array('name'=>'file','type'=>'file','label'=>'ե','attr'=>array('size'=>'50'),virtual=>'yes'),
						),
				'amazonsearch'=>array(
						array('name'=>'id','type'=>'id',virtual=>'yes'),
						array('name'=>'keywords','type'=>'text','label'=>'','attr'=>array('size'=>'50','maxlength'=>'50'),virtual=>'yes'),
						array('name'=>'asin','type'=>'text','label'=>'ASIN/ISBN','attr'=>array('size'=>'50','maxlength'=>'128'),'rule'=>array('alphanumsymbol'=>'yes'),virtual=>'yes'),
						array('name'=>'search_option','type'=>'select_text','label'=>'',virtual=>'yes'),
						array('name'=>'sort_option','type'=>'select_text','label'=>'¤ӽ',virtual=>'yes'),
						array('name'=>'itempage','type'=>'hidden_int','label'=>'ItemPage','value'=>1,'default'=>1,virtual=>'yes'),
						),
				'googlemaps'=>array(
						array('name'=>'id','type'=>'id'),
						array('name'=>'name','type'=>'text','label'=>'̾','attr'=>array('size'=>'50','maxlength'=>'50')),
						array('name'=>'address','type'=>'text','label'=>'','attr'=>array('size'=>'50','maxlength'=>'128')),
						),
				'geocodes'=>array(
						array('name'=>'address','type'=>'text','label'=>'','attr'=>array('size'=>'50','maxlength'=>'128')),
						array('name'=>'lon','type'=>'float','label'=>'','attr'=>array('size'=>'50','maxlength'=>'50'),'rule'=>array('numeric'=>'yes')),
						array('name'=>'lat','type'=>'float','label'=>'','attr'=>array('size'=>'50','maxlength'=>'50'),'rule'=>array('numeric'=>'yes')),
						),
				'blank'=>array(),
				);

} // end of init_values

}
?>