<?php
class page_base extends myQuicty {


public function pre_dispatch_index() {
	parent::pre_dispatch_index();
	$this->caching = 0; // caching page flag: 0 = none; 1 = simple; 2 = each query
	$this->cache_lifetime = 1800; // cache life time by seconds
	$this->cache_id = get_query_id();
	$this->page['base_url'] = quicty_base_url();

	$this->application['id'] = $_REQUEST['application_id'] ? $_REQUEST['application_id'] : NULL;
	if(!in_array($this->dispatch_action,array('info','edit','delete')) and !$this->application['id'])
		redirect('/');
	if(!in_array($this->dispatch_action,array('info','edit')))
		$this->folder['id'] = $_REQUEST['folder_id'] ? $_REQUEST['folder_id'] : 0;

	return true;
}

function assign_search_form() {
	$search_form = $this->new_search_obj('page_search',array('action'=>$this->page['base_url'].'/page/','method'=>'get'));
	$this->assign_form('search_form',$search_form);
}

function list_records() {
	require_once 'list_options.class.php';
	$this->list = $this->new_data_set('page');
	$options = new page_list_options($this);
	$pager_option = $options->get_pager_option();
	$this->list->bind_pager($pager_option);
	
	$fields = $options->make_select_fields();
	$sort_condition = $options->make_sort_condition();
	$table = $this->list->select_table_with_pager($sort_condition,$fields);
	
	$this->assign('table_view',$this->list->display_table_value($table));
	$this->assign('display_cmd','info');
	$this->page['pager'] = $this->list->get_pager_links();
}


function display_record($condition='') {
	require_once 'form_options.class.php';
	$this->form = $this->new_data_set('page');
	$options = new page_form_options($this);
	$options->set_form_options();
	$options->set_form_filters();
	$this->form->validate_and_freeze();
	$this->form->bind_button_control();
	
	$result = $this->form->automatic_form_handler($condition);
	$this->page_value = $result['page'] ? $result['page'] : $result['values'];
	$application_id = $this->page_value['application_id']
		? $this->page_value['application_id']
		: $this->application['id'];
	$this->application = $this->select_row('application','where id='.$application_id);
	$this->assign('application',$this->application);

	$folder_id = $this->page_value['folder_id']
		? $this->page_value['folder_id']
		: $this->folder['id'];
	if($folder_id>0) {
		$this->folder = $this->select_row('folder','where id='.$folder_id);
		$this->assign('folder',$this->folder);
	}

	$this->assign_form('input_form',$this->form);
}




} // end of page_base class
?>