<?php
class index_options extends myQuicty {

//-----------------------------------------------------------------
// pre dispatch options

public function pre_dispatch_index() {
	parent::pre_dispatch_index();
	$this->caching = 0; // caching page flag: 0 = none; 1 = simple; 2 = each query
	$this->cache_lifetime = 1800; // cache life time by seconds
	$this->cache_id = get_query_id();
	$this->page['base_url'] = quicty_base_url();
	return true;
}


//-----------------------------------------------------------------
// list options

function assign_search_form() {
	$search_form = $this->new_search_obj('application_search',array('action'=>$this->page['base_url'].'/','method'=>'get'));
	$this->assign_form('search_form',$search_form);
}

function make_where_condition() {
	$search_system = array(
		'keyword'=>array('title'=>'application.name','url'=>'application.url'), // keyword search target column
		'condition'=>array('id'=>'application.id') // id search target column
		);
	return $this->list->make_condition($search_system);
}

function make_select_fields() {
	$select_system = array(
		'application'=>'*', // specify all column
		//'application'=>array('id','name','url'), // specify each column
		//'application'=>array('id'=>'application_id'), //specify another column name
		);
	return $this->list->make_select_fields($select_system);
}


function make_sort_condition() {
	$sort_system = array(
		'default'=>' order by name',
		'colums'=>array('id','name','url') // sort keys
		);
	return $this->list->make_order($sort_system);
}

function make_join_condition() {
	//$this->list->real_count = true; // set this flag if join other table
	//$join_condition = "left join {table_name} on application.id={table_name}.application_id";
	return $join_condition;
}

//-----------------------------------------------------------------
// display options

function set_form_options() {
	$this->form->set_base_link_addr(quicty_base_url().'/');
	$this->form->set_restart_link_addr(quicty_base_url().'/');
	$this->form->set_button_status('use_confirm',false);
}

// filters

function default_db_name($value) {
	if(!$value) $value = $this->form->getElementValue('name');
	return $value;
}

function default_db_path($value) {
	if(!$value) {
		$system_field = $this->form->getElementValue('system');
		$system = $system_field[0];
		if($system=='sqlite') {
			$value = 'var/sqlite';
		}
	}
	return $value;
}

function default_db_host($value) {
	if(!$value) {
		$system_field = $this->form->getElementValue('system');
		$system = $system_field[0];
		switch($system) {
			case 'sqlite':
				$value = '';
				break;
			case 'pgsql':
				if($this->configure['pgsql_host']) {
					$value = $this->configure['pgsql_host'];
				} else {
					$value = 'localhost';
				}
				break;
			case 'mysql':
				if($this->configure['mysql_host']) {
					$value = $this->configure['mysql_host'];
				} else {
					$value = 'localhost';
				}
				break;
		}
	}
	return $value;
}

function default_db_port($value) {
	if(!$value) {
		$system_field = $this->form->getElementValue('system');
		$system = $system_field[0];
		switch($system) {
			case 'sqlite':
				$value = '';
				break;
			case 'pgsql':
				if($this->configure['pgsql_port']) {
					$value = $this->configure['pgsql_port'];
				} else {
					$value = '5432';
				}
				break;
			case 'mysql':
				if($this->configure['mysql_port']) {
					$value = $this->configure['mysql_port'];
				} else {
					$value = '3306';
				}
				break;
		}
	}
	return $value;
}

function default_db_user($value) {
	if(!$value) {
		$system_field = $this->form->getElementValue('system');
		$system = $system_field[0];
		switch($system) {
			case 'sqlite':
				$value = '';
				break;
			case 'pgsql':
				if($this->configure['pgsql_user']) {
					$value = $this->configure['pgsql_user'];
				} else {
					$value = $this->form->getElementValue('name');
				}
				break;
			case 'mysql':
				if($this->configure['mysql_user']) {
					$value = $this->configure['mysql_user'];
				} else {
					$value = $this->form->getElementValue('name');
				}
				break;
		}
	}
	return $value;
}

function default_db_password($value) {
	if(!$value) {
		$system_field = $this->form->getElementValue('system');
		$system = $system_field[0];
		switch($system) {
			case 'sqlite':
				$value = '';
				break;
			case 'pgsql':
				if($this->configure['pgsql_password']) {
					$value = $this->configure['pgsql_password'];
				} else {
					$value = '';
				}
				break;
			case 'mysql':
				if($this->configure['mysql_password']) {
					$value = $this->configure['mysql_password'];
				} else {
					$value = '';
				}
				break;
		}
	}
	return $value;
}

function default_server_name($value) {
	if(!$value) $value = 'www.'.$this->form->getElementValue('name').'.com';
	return $value;
}

function default_application_root($value) {
	if(!$value) $value = $this->qt_application_root.'/'.$this->form->getElementValue('name');
	return $value;
}

function set_form_filters() {
	//var_check($this->configure);
	$this->form->applyFilter('_ALL_','trim');
	$this->form->applyFilter('db_name',array($this,'default_db_name'));
	$this->form->applyFilter('path',array($this,'default_db_path'));
	$this->form->applyFilter('host',array($this,'default_db_host'));
	$this->form->applyFilter('port',array($this,'default_db_port'));
	$this->form->applyFilter('user',array($this,'default_db_user'));
	$this->form->applyFilter('password',array($this,'default_db_password'));
	$this->form->applyFilter('server_name',array($this,'default_server_name'));
	$this->form->applyFilter('application_root',array($this,'default_application_root'));
}

// make dir and copy modules

function is_quicty_dir($server_root) {
	if(
		file_exists("$server_root/lib/myQuicty.php") and 
		file_exists("$server_root/view/index.html")) {
		return true;
	} else {
		return false;
	}
}

function make_sub_dir($server_root) {
		umask(0);
		mkdir("$server_root/bin",0777);
		mkdir("$server_root/etc",0777);
		mkdir("$server_root/etc/conf",0777);
		mkdir("$server_root/etc/data_def",0777);
		mkdir("$server_root/etc/data_set",0777);
		mkdir("$server_root/etc/data_view",0777);
		mkdir("$server_root/etc/search_view",0777);
		mkdir("$server_root/etc/sql",0777);
		mkdir("$server_root/htdocs",0777);
		mkdir("$server_root/htdocs/css",0777);
		mkdir("$server_root/htdocs/img",0777);
		mkdir("$server_root/htdocs/js",0777);
		mkdir("$server_root/lib",0777);
		mkdir("$server_root/lib/Pages",0777);
		mkdir("$server_root/lib/includes",0777);
		mkdir("$server_root/lib/Components",0777);
		mkdir("$server_root/lib/Plugin",0777);
		mkdir("$server_root/lib/smarty_plugins",0777);
		mkdir("$server_root/misc",0777);
		mkdir("$server_root/misc/doc",0777);
		mkdir("$server_root/var",0777);
		mkdir("$server_root/var/compiled_view",0755);
		mkdir("$server_root/var/rss_cache",0755);
		mkdir("$server_root/var/smarty_cache",0755);
		mkdir("$server_root/var/log",0777);
		mkdir("$server_root/view",0777);
		mkdir("$server_root/view/includes",0777);
}

function copy_modules($server_root) {
		copy_files($this->Quicty_modules.'/bin',$server_root.'/bin',false,0666);
		copy_files($this->Quicty_modules.'/etc/conf',$server_root.'/etc/conf',false,0666);
		copy_files($this->Quicty_modules.'/etc/data_def',$server_root.'/etc/data_def',false,0666);
		copy_files($this->Quicty_modules.'/etc/data_set',$server_root.'/etc/data_set',false,0666);
		copy_files($this->Quicty_modules.'/etc/data_view',$server_root.'/etc/data_view',false,0666);
		copy_files($this->Quicty_modules.'/etc/sql',$server_root.'/etc/sql',true,0666);
		copy_files($this->Quicty_modules.'/htdocs',$server_root.'/htdocs',false,0666);
		copy_files($this->Quicty_modules.'/htdocs/css',$server_root.'/htdocs/css',false,0666);
		copy_files($this->Quicty_modules.'/htdocs/img',$server_root.'/htdocs/img',true,0666);
		copy_files($this->Quicty_modules.'/htdocs/js',$server_root.'/htdocs/js',true,0666);
		copy_files($this->Quicty_modules.'/lib',$server_root.'/lib',false,0666);
		copy_files($this->Quicty_modules.'/lib/Pages/index.class.php',$server_root.'/lib/Pages',false,0666);
		copy_files($this->Quicty_modules.'/lib/includes',$server_root.'/lib/Plugin',false,0666);
		copy_files($this->Quicty_modules.'/lib/Plugin',$server_root.'/lib/Plugin',false,0666);
		copy_files($this->Quicty_modules.'/lib/smarty_plugins',$server_root.'/lib/smarty_plugins',false,0666);
		copy_files($this->Quicty_modules.'/misc/doc',$server_root.'/misc/doc',false,0666);
		copy_files($this->Quicty_modules.'/view',$server_root.'/view',false,0666);
		copy_files($this->Quicty_modules.'/view/includes',$server_root.'/view/includes',true,0666);
}

function set_site_name($server_root,$site_name) {
	$org_template_dir = $this->template_dir;
	$org_left_delimiter = $this->left_delimiter;
	$org_right_delimiter = $this->right_delimiter;
	
	$this->template_dir ='';
	$this->left_delimiter = '<!--{';
	$this->right_delimiter = '}-->';
	
	$this->assign('site_name',$site_name);
	$target_file = $server_root.'/lib/myQuicty.php';
	$contents = $this->fetch($target_file);
	file_write_contents($target_file,$contents);
	chmod($target_file,0666);

	$this->template_dir = $org_template_dir;
	$this->left_delimiter = $org_left_delimiter;
	$this->right_delimiter = $org_right_delimiter;
	
	$word_values_file = $server_root.'/etc/conf/word_values_addition.conf';
	$word_values = '$'."this->W['site_name'] = '$site_name';\n";
	file_write_contents($word_values_file,mb_convert_encoding($word_values,'UTF-8'),"a");
	@chmod($word_values_file,0666);
	
}	

function make_quicty_dir() {
	$site_name = $_POST['site_name'];
	$name = $_POST['name'];
	$server_root = $_POST['server_root']
		? $_POST['server_root']
		: $this->qt_application_root."/$name";
	if(!file_exists($server_root)) @mkdir($server_root,0777);
	if(!$this->is_quicty_dir($server_root)) {
		$this->make_sub_dir($server_root);
		$this->copy_modules($server_root);
		$this->set_site_name($server_root,$site_name);
	} else {
		require_once 'includes/import_app.class.php';
		$importer = new import_app;
		$class_files = glob("$server_root/lib/Pages/*.class.php");
		if(count($class_files)>0) {
			$importer->import_pages($server_root,'',$this->application['id'],0);
		}
		$folder_table = $this->new_data_set('folder');
		$folders = glob("$server_root/view/*",GLOB_ONLYDIR);
		foreach($folders as $folder) {
			$folder_name = array_pop(explode('/',$folder));
			if($folder_name=='CVS' or $folder_name=='includes') continue;
			if(!is_dir("$server_root/lib/Pages/$folder_name")) continue;
			$class_files = glob("$server_root/lib/Pages/$folder_name/*.class.php");
			if(count($class_files)==0) continue;
			$insert_set = array('application_id'=>$this->application['id'],'name'=>$folder_name);
			$result = $folder_table->insert_table($insert_set);
			$importer->import_pages($server_root,$folder_name,$this->application['id'],$result['folder']['id']);
		}
		
		$datasets_ids = $importer->import_datasets($server_root,$this->application['id']);
	}
}

// write virtualhost config

function write_vhost() {
	$data = $this->form->select_table('order by id');
	foreach($data as $app) {
		$name = $app['name'];
		$sever_name = $app['server_name'];
		$application_root = $app['application_root']
			? $app['application_root']
			: $this->qt_application_root."/$name";
		$virtualhost .= 
			"<VirtualHost *:80>\n".
			"    DocumentRoot $application_root/htdocs\n".
			"    ServerName $sever_name\n".
			"    Options FollowSymLinks\n".
			"    include $application_root/etc/conf/rewrite.conf\n".
			"</VirtualHost>\n\n";
	}
	file_write_contents('../etc/conf/vhost.conf',$virtualhost);
}

// post process

function post_form_process() {
	switch($this->QuictyStatus) {
		case 'INSERT':
			$this->make_quicty_dir();
		case 'UPDATE':
			$this->write_vhost();
			redirect('/');
			break;
		case 'DELETE':
			$this->write_vhost();
			$page = $this->new_data_set('page');
			$page->delete('where application_id='.$_POST['id']);
			$folder = $this->new_data_set('folder');
			$folder->delete('where application_id='.$_POST['id']);
			$datasets = $this->new_data_set('datasets');
			$fields = $this->new_data_set('fields');
			$my_datasets = $datasets->select_table('where application_id='.$_POST['id']);
			foreach($my_datasets as $dataset) {
				$fields->delete('where datasets_id='.$dataset['id']);
			}
			$datasets->delete('where application_id='.$_POST['id']);
			redirect('/');
			break;
		case 'BROWSE':
			break;
		default:
	}
}



} // end of index_options class
?>