<?php
/**
 *	Project:	Quicty: Quick application build environment depends on PEAR and Smarty
 *	File:		Quicty/modules/template/userauth/lib/Pages/index.class.php
 *
 *	@copyright	Tomoyuki Negishi and ZubaPitaTech, Inc.
 *	@author		Tomoyuki Negishi <tomoyu-n@zubapita.jp>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Quicty
 *	@version	$Id:$
 */
require_once 'user_classes/_base.class.php';
class user extends user_base {

function dispatch_index() {
	if($this->user['level'] < admin_user) {
		redirect('top');
	}
	if(!$this->is_cached($this->current_template,$this->cache_id)) {
		$this->assign_search_form();
		$list_table = $this->list_records('');
			
		$this->assign('table_view',$this->list->display_table_value($list_table));
		$this->assign('display_cmd','info');
		$this->page['pager'] = $this->set_pager();
		$this->assign_page_and_pathlist($this->W['_userauth_registerd_list']);
	}
	return $this->display($this->current_template,$this->cache_id);
}

function dispatch_add() {
	if($_REQUEST['next']) {
		$this->assign('next',$_REQUEST['next']);
	}
	if($this->user['level'] >= registerd_user 
		AND $this->user['level'] < admin_user) {
			redirect('<!--{$folder_name}-->/user/info');
	}

	$this->assign_search_form();
	$result = $this->display_record();
	if($this->QuictyStatus=='INSERT') {
		$_SESSION['next'] = NULL;
		if(!$this->user['level']) {
			$_SESSION['regiserd_massege'] = $this->W['_userauth_success_regist'];
			if($_REQUEST['next']) {
				redirect('<!--{$folder_name}-->/user/login?next='.$_REQUEST['next']);
			} else {
				redirect('<!--{$folder_name}-->/user/login');
			}
		}
	}
	
	$this->assign_form('input_form',$this->form);
	$this->assign_page_and_pathlist($this->W['_userauth_add']);
	return $this->display($this->current_template);
}

function dispatch_info() {
	if($this->user['level'] < registerd_user) {
		redirect('top');
	}
	if(isset($_REQUEST['id'])
		AND $_REQUEST['id']!=$this->user['id']
		AND $this->user['level'] < admin_user) {
			redirect('top');
	}
	$this->assign_search_form();
	if(!$_REQUEST['id']) {
		$result = $this->display_record('where id='.$this->user['id']);
	} else {
		$result = $this->display_record();
	}
	$this->assign_form('input_form',$this->form);
	$this->assign_page_and_pathlist($this->W['_userauth_display']);
	return $this->display($this->current_template);
}

function dispatch_edit() {
	if($this->user['level'] < registerd_user) {
		redirect('top');
	}
	if(isset($_REQUEST['id'])
		AND $_REQUEST['id']!=$this->user['id']
		AND $this->user['level'] < admin_user) {
			redirect('top');
	}
	
	$this->assign_search_form();
	if(!$_REQUEST['id']) {
		$result = $this->display_record('where id='.$this->user['id']);
	} else {
		$result = $this->display_record();
	}
	$this->assign_form('input_form',$this->form);
	$this->assign_page_and_pathlist($this->W['_userauth_edit']);
	return $this->display($this->current_template);
}

function dispatch_delete() {
	if($this->user['level'] < registerd_user) {
		redirect('top');
	}
	if(isset($_REQUEST['id'])
		AND $_REQUEST['id']!=$this->user['id']
		AND $this->user['level'] < admin_user) {
			redirect('top');
	}

	$form = $this->new_data_set('userauth');
	$user_id = $form->esfd($_REQUEST['id']);
	if($this->QuictyStatus=='DELETE' AND $_REQUEST['id'] AND 
		($_REQUEST['id']==$this->user['id'] OR $this->user['level'] >= admin_user) ) {
		$condition = 'where id='.$user_id;
		$form->delete($condition);
		if($user_id==$this->user['id']) {
			redirect('<!--{$folder_name}-->/user/quit_member.html');
		}
	}

	$this->assign_search_form();
	if(!$_REQUEST['id']) {
		$result = $this->display_record('where id='.$this->user['id']);
	} else {
		$result = $this->display_record();
	}
	$this->assign_form('input_form',$this->form);
	$this->assign_page_and_pathlist($this->W['_userauth_delete']);
	return $this->display($this->current_template);
}

//------------------------------------------------------------------

function dispatch_login() {
	if($_REQUEST['next']) {
		$this->assign('next',$_REQUEST['next']);
	}
	if($_SESSION['regiserd_massege']) {
		$this->assign('login_message',$_SESSION['regiserd_massege']);
		$_SESSION['regiserd_massege'] = '';
	}
	$auth = $this->get_auth_obj();
	if($auth->getAuth()) {
		$_SESSION['next'] = NULL;
		if($_POST['next']) {
			redirect('http://'.$_POST['next']);
		} else {
			redirect('top');
		}
	} else {
		$form = $this->new_form_obj('login');
		$form->bind_data_view('login.view.conf');
		$this->set_qs_status('SEND');
		$form->bind_button_control();
		$auth_status = $auth->getStatus();
		if($auth_status==AUTH_WRONG_LOGIN) {
			$this->set_form_error($this->W['_userauth_login_error']);
		}
		$this->assign_form('form',$form);
		$this->assign_page_and_pathlist($this->W['_userauth_login']);
		$this->display($this->current_template);
	}
}

function dispatch_logout() {
	$auth = $this->get_auth_obj();
	$auth->logout();
	$user['authorized'] = false;
	$user['handle'] = $this->W['_userauth_guest'];
	$this->assign('user',$user);
	$this->assign_page_and_pathlist($this->W['_userauth_logout']);
	$this->display($this->current_template);
}

function dispatch_quit_member() {
	$auth = $this->get_auth_obj();
	$auth->logout();
	$user['authorized'] = false;
	$user['handle'] = $this->W['_userauth_guest'];
	$this->assign('user',$user);
	$this->assign_page_and_pathlist($this->W['_userauth_quit']);
	$this->display($this->current_template);
}

function dispatch_error() {
	$this->page['message'] = $this->W['_userauth_no_login_error'];
	$this->assign_page_and_pathlist($this->W['_userauth_please_login']);
	return $this->display($this->current_template);
}

} // end of user class
?>