<?php
class items_list_options extends myQuicty {

function __construct($page) {
	parent::__construct();
	$this->page = $page;
	$this->list = $this->page->list;
}

var $perPage = 20;

function get_pager_option($add_condition='') {
	$where_condition = $this->make_where_condition($add_condition);
	$join_condition = $this->make_join_condition();
	$select_condition = $join_condition.' '.$where_condition;
	$pager_option = $this->set_pager_option($this->perPage,$select_condition);
	return $pager_option;
}

function make_where_condition($add_condition='') {
	$search_system_file = $this->page->home_dir.'/etc/search_view/items.sys';
	if(file_exists($search_system_file)) {
		$search_system = read_data_array($search_system_file);
	} else {
		$search_system = array(
			'keyword'=>array('title'=>'items.name','url'=>'items.url'), // keyword search target column
			'condition'=>array('id'=>'items.id','application_id'=>'items.application_id'), // id search target column
			//'period'=>array('start_date'=>array('column'=>'date','end'=>'end_date'))
			);
	}
	return $this->list->make_condition($search_system,$add_condition);
}

function make_join_condition() {
	//$this->list->real_count = true; // set this flag if join other table
	//$join_condition = "left join {table_name} on items.id={table_name}.items_id";
	return $join_condition;
}

function make_select_fields() {
	$select_system = array(
		'items'=>'*', // specify all column
		//'items'=>array('id','name','url'), // specify each column
		//'items'=>array('id'=>'items_id'), //specify another column name
		);
	return $this->list->make_select_fields($select_system);
}

function make_sort_condition() {
	$sort_system = array(
		'default'=>' order by id',
		// sort keys
		'columns'=>'*', // specify all column
		//'columns'=>array('id','name','url'), // specify each column
		);
	return $this->list->make_order($sort_system);
}

} // end of class items_list_options
?>