<?php
/**
 * Smarty mb_truncate modifier plugin
 *
 * Type:     modifier<br>
 * Name:     mb_truncate<br>
 * Purpose:  Truncate a string to a certain length if necessary,
 *           optionally splitting in the middle of a word, and
 *           appending the $etc string or inserting $etc into the middle.
 * @link http://quicty.zubapita.jp/
 *          mb_truncate (Quicty online manual)
 * @author   Tomoyuki Negishi <tomoyu-n at zubapita dot jp>
 * @param string
 * @param integer
 * @param string
 * @param boolean
 * @param boolean
 * @return string
 */
function smarty_modifier_mb_truncate($string, $length = 80, $etc = '') {
	if($length == 0) return '';

	if(mb_strlen($string) > $length) {
		$length -= mb_strlen($etc);
		//$string = preg_replace('/\s+?(\S+)?$/', '', substr($string, 0, $length+1));
		return mb_substr($string, 0, $length).$etc;
	} else {
		return $string;
	}
}

/* vim: set expandtab: */

?>
