<?php
class field_properties extends myQuicty {

function __construct($page) {
	parent::__construct();
	$this->page = $page;
	$this->form = $this->page->form;
	$this->init_field_define();
}

function get_property_template($type_name) {
	$result = array();
	foreach($this->field_kind as $field_properties) {
		if($field_properties['name']==$type_name) {
			$result = $field_properties;
			if(!is_array($result['rule']) 
				and ($this->page->QuictyStatus=='EDIT' or $this->page->QuictyStatus=='UPDATE'))
				$result['rule'] = array();
			break;
		}
	}
	return $result;
}

function get_posted_properties($type) {
	$property_template = $this->get_property_template($type);
	foreach($property_template as $key=>$value) {
		if(in_array($key,array('kind'))) continue;
		if(is_array($_POST[$key])) {
			foreach($_POST[$key] as $ckey=>$cval) {
				list($i,$key_kind,$post_key) = explode('_',$ckey);
				if($key_kind=='key') $tmp_key = $cval;
				if($key_kind=='val' and $tmp_key!=='' and $cval!=='') {
					$result[$key][$tmp_key] = $cval;
					unset($tmp_key);
				}
			}
		} else {
			$result[$key] = $_POST[$key];
		}
	}
	return $result;
}

function get_new_key_and_value_fields($key,$i,$ckey,$cval) {
	$key_name = $i.'_key_'.$this->post_key;
	$element[$key_name] = $this->form->createElement('text',$key_name,NULL,array('size'=>8));
	$element[$key_name]->setValue($ckey);
	$this->prop_values[$key][$key_name] = $ckey;
	$val_name = $i.'_val_'.$this->post_key;
	$element[$val_name] = $this->form->createElement('text',$val_name,NULL,array('size'=>32));
	$element[$val_name]->setValue($cval);
	$this->prop_values[$key][$key_name] = $cval;
	if($this->page->QuictyStatus!='BROWSE') {
		$button_name = $i.'_del';
		$max = $this->form->getElementValue("max_row_$key") -1;
		$set_delrow_js = "javascript:document.fields.command.value='del_".$key."_$i';document.fields.max_row_$key.value='$max';";
		$set_delrow_js .= "submit();";
		$element[$button_name] = $this->form->createElement('button',$button_name,'del',array('onclick'=>$set_delrow_js));
	}
	return $element;
}


function set() {
	if($_GET['id']) {
		$my = $this->form->select_table('where id='.$_GET['id']);
		$type = $my[0]['type'];
		$my_properties = unserialize($my[0]['properties']);
		//if($_GET['mode']=='add_rule') {
		//	$rule_no = $_GET['rule'];
		if($rule_no = $_GET['rule']) {
			$name = $this->rule_kind[$rule_no]['name'];
			$param = $this->rule_kind[$rule_no]['param'];
			$my_properties['rule'][$name] = $param;
		}
	} elseif($_POST['mode']=='add') {
		$name = $type =$_POST['type'];
		$hqf_type = $this->fields_reverse_map[$_POST['type']]['type'];
		$label = $this->fields_reverse_map[$_POST['type']]['label'];
		//$this->form->setDefaults(array('name'=>$name.$seq,'label'=>$label.$seq));
		//$this->form->setConstants(array('type'=>$type,'hqf_type'=>$hqf_type));
	} elseif($_POST['type']) {
		$type = $_POST['type'];
		$hqf_type = $_POST['hqf_type'];
		$name = $_POST['name'];
		$this->page->posted_properties = $my_properties = $this->get_posted_properties($type);
	}
	$property_template = $this->get_property_template($type);
	if(!$my_properties) $my_properties = $property_template;
	$this->form->addElement('hidden','command');
	$this->post_key = md5(time());
	$this->form->addElement('hidden','post_key',$this->post_key);
	foreach($property_template as $key=>$value) {
		if(in_array($key,array('name','type','kind','label'))) continue;
		if(is_array($value)) {
			if($key=='default') {
				$attr_label = "default=>(Name=>key)";
			} else {
				$attr_label = "$key=>(key=>value)";
			}
			$attr_element[$key] = array();
			$max_row = $_POST["max_row_$key"] ? $_POST["max_row_$key"] : count($my_properties[$key]);
			$attr_element["max_row_$key"] = $this->form->addElement('hidden',"max_row_$key",$max_row);
			$tmp_max_row = $max_row;
			for($i=1;$i<=$tmp_max_row;$i++) {
				list($ckey,$cval) = each($my_properties[$key]);
				if($_POST['command']!="del_".$key."_$i") {
					if($key=='default' AND $ckey=='name') {
						$ckey = $property_template['name'];
					}
					$attr_element[$key] += $this->get_new_key_and_value_fields($key,$i,$ckey,$cval);
					//if($key=='default') {
					//	if(array_key_exists('name',$value))
					//		$ckey = $this->form->getElementValue('name');
					//		if(!$ckey) $ckey = $name;
					//}
				} else {
					$tmp_max_row++;
				}
			}
			if($key!='default') {
				if($key=='rule') {
					$base_url = quicty_base_url();
					$fields_id = $_REQUEST['id'];
					//$set_addrule_js = "javascript:location.href='$base_url/fields/add_rule?id=$fields_id';";
					$set_addrule_js = "javascript:document.fields.command.value='add_rule';submit();";
					$attr_element[$key]['button'] = $this->form->createElement('button','button','add rule',array('onclick'=>$set_addrule_js));
				} else {
					$new_max_row = $max_row + 1;
					$set_addrow_js = "javascript:document.fields.max_row_$key.value='$new_max_row';submit();";
					$attr_element[$key]['button'] = $this->form->createElement('button','button','add row',array('onclick'=>$set_addrow_js));
				}
			}
			$this->form->addGroup($attr_element[$key],$key,$attr_label);
		} else {
			$attr_element[$key] = $this->form->addElement('text',$key,$key,array('size'=>50));
			if(isset($my_properties[$key]) and method_exists($attr_element[$key],'setValue')) {
				$attr_element[$key]->setValue($my_properties[$key]);
			}
		}
	}
}






} // end of field_properties class
?>