<?php
require_once 'includes/datasets_conf/_base.class.php';
class datasets_form extends datasets_conf {

function make_sample($datasets_id) {
	if(!$this->datasets_id) $this->init($datasets_id);
	
	$base_url = quicty_base_url();
	if(is_array($this->fieldset) and count($this->fieldset)>0)
	  foreach($this->fieldset as $each_field) {
		$id = $each_field['id'];
		$field_name = $each_field['name'];
		$columns[$field_name]['type'] = $each_field['hqf_type'];
		$columns[$field_name]['label'] = "<a href=\"$base_url/fields/edit?id=$id\">".$each_field['label']."</a>";
		$properties = unserialize($each_field['properties']);
		if(is_array($properties) and count($properties)>0)
		  foreach($properties as $key=>$value) {
			if(in_array($key,array('type','name','label'))) {
				continue;
			} elseif(is_array($value)) {
				if($key=='default' or $key=='force_value') {
					$list_name = $key.'_list';
				} else {
					$list_name = $key;
				}
				$columns[$field_name][$list_name] = 'start';
				foreach($value as $ckey=>$cval){
					$columns[$field_name][$ckey] = $cval;
				}
				$columns[$field_name]['end_'.$list_name] = '1';
			} else {
				$columns[$field_name][$key] = $value;
			}
		}
	}
	$form = $this->new_form_obj('myform');
	$this->home_dir = $this->application_path;
	$form->bind_data_view($columns);
	return $form;
}

function make_write_conf($datasets_id) {
	if(!$this->datasets_id) $this->init($datasets_id);

	$base_url = quicty_base_url();
	$form = new HTML_QuickForm('rules','POST',$base_url.'/datasets/write_conf');
	$form->addElement('advcheckbox','data_def','.def','¸ʥǡåȤ',NULL,array('no','yes'));
	$form->addElement('advcheckbox','data_view','data_view.conf','¸ʥեɽ',NULL,array('no','yes'));
	$form->addElement('advcheckbox','search_view','search_view.conf','¸ʸեɽ',NULL,array('no','yes'));
	$form->addElement('advcheckbox','search_form','search_form.inc','¸ʸեࡦƥץ졼ȡ',NULL,array('no','yes'));
	$form->addElement('advcheckbox','search_sys','search.sys','¸ʸ',NULL,array('no','yes'));
	$form->addElement('advcheckbox','sort_tab','sort_tab.inc','¸¤ؤ֡ƥץ졼ȡ',NULL,array('no','yes'));
	$form->addElement('advcheckbox','data_set','data_set.conf','¸ʥǡ١񤭹',NULL,array('no','yes'));
	$form->addElement('advcheckbox','sql','sql','¸SQLե',NULL,array('no','yes'));
	$form->addElement('advcheckbox','init','init_db.sh','¸SQL¹ѥ륹ץȡ',NULL,array('no','yes'));
	$form->setDefaults(array('data_def'=>'yes','data_view'=>'yes','search_view'=>'yes','search_form'=>'yes','search_sys'=>'yes','sort_tab'=>'yes','data_set'=>'yes','sql'=>'yes','init'=>'yes'));
	$form->addElement('hidden','id',$datasets_id);
	$form->addElement('hidden','mode','write_conf');
	$form->addElement('submit','submit','¸');

	$renderer = new HTML_QuickForm_Renderer_ArraySmarty($form);
	$form->accept($renderer);
	$write_conf_form = $renderer->toArray();
	return $write_conf_form;
}

function make_create_table($datasets_id) {
	if(!$this->datasets_id) $this->init($datasets_id);

	$base_url = quicty_base_url();
	$form = new HTML_QuickForm('create','POST',$base_url.'/datasets/create_table');
	//$form->addElement('advcheckbox','create','ơ֥κ','¸ǥơ֥롣<br />ʴ¸Υơ֥˴ޤ<br />å򤷤ʤǼ¹ԤȡSQLγǧɽΤ߹Ԥޤ',NULL,array('no','yes'));
	//$form->setDefaults(array('create'=>'no'));
	$form->addElement('radio','create','ʺơ˺','¸ǥơ֥롣<br /><span style="color:#f00;">ʴ¸Υơ֥˴ޤ</span>','create_table');
	$form->addElement('radio','create','ɲ','¸Υơ֥˥ɲá<br />SQLiteǤѤǤޤ','add_column');
	$form->addElement('radio','create','SQLγǧ','SQL¹ԤˡɽΤ߹Ԥޤ','no_exec');
	$form->setDefaults(array('create'=>'no_exec'));
	$form->addElement('hidden','id',$datasets_id);
	$form->addElement('hidden','mode','create_table');
	$form->addElement('submit','submit','¸');

	$renderer = new HTML_QuickForm_Renderer_ArraySmarty($form);
	$form->accept($renderer);
	$create_form = $renderer->toArray();
	foreach($create_form['create'] as $key=>$attributes) {
		$create_form[' '.$key] = $attributes;
	}
	unset($create_form['create']);
	return $create_form;
}

function make_create_template($datasets_id) {
	if(!$this->datasets_id) $this->init($datasets_id);

	$base_url = quicty_base_url();
	$form = new HTML_QuickForm('template','POST',$base_url.'/datasets/create_template');
	$form->addElement('advcheckbox','input_form','input_form.inc','¸ϥե',NULL,array('no','yes'));
	$form->addElement('advcheckbox','table_view','table_view.inc','¸ɽɽ',NULL,array('no','yes'));
	$form->addElement('advcheckbox','list_view','list_view.inc','¸ʽĥꥹȷɽ',NULL,array('no','yes'));
	$form->setDefaults(array('input_form'=>'yes','table_view'=>'yes','list_view'=>'yes'));
	$form->addElement('hidden','id',$datasets_id);
	$form->addElement('hidden','mode','create_template');
	$form->addElement('submit','submit','¸');

	$renderer = new HTML_QuickForm_Renderer_ArraySmarty($form);
	$form->accept($renderer);
	$create_template = $renderer->toArray();
	return $create_template;
}

} // end of class datasets_form
?>
