<?php
require_once '_base.class.php';
class add_page_write extends add_page_base {

function write() {
	$this->set_sub_dir();
	$this->set_templates();
	$this->set_class_module();
	$this->save_action_list();
	$this->save_word_values();
	$datasets = $this->new_data_set('datasets');
	if(count($this->datasets_value[$this->page_type])>0) {
		$result = $datasets->select_table("where name='$this->page_name' and application_id=".$this->application_id);
		if(count($result)==0) {
			$this->set_data_def($this->options);
			$datasets_id = $this->save_datasets_to_db();
			$write_result = $this->write_conf($datasets_id);
			$create_result = $this->create_table($datasets_id);
		}
	}
	if($this->page_type=='googlemaps') { // Google Maps needs GEOCODES Chache table
		$result = $datasets->select_table("where name='geocodes' and application_id=".$this->application_id);
		if(count($result)==0) {
			$this->set_data_def('geocodes','GEOCODES','geocodes');
			$datasets_id = $this->save_datasets_to_db();
			$write_result = $this->write_conf($datasets_id);
			$create_result = $this->create_table($datasets_id);
		}
	}
	$result['message'] = nl2br($write_result['message'] .$create_result['message']);

	return $result;
}

function set_data_def($options) {
	//$this->dsn = array('system'=>'sqlite','dbname'=>$this->db_name,'dataname'=>$page_name,'title'=>$page_title,'path'=>'var/sqlite','init_when_build'=>1);
	$this->dsn['system'] = $options['system'];
	$this->dsn['dbname'] = $this->db_name;
	$this->dsn['dataname'] = $options['page_name'];
	$this->dsn['title'] = $options['page_title'];
	if($this->dsn['system']=='sqlite') {
		if($options['path']) {
			$this->dsn['path'] = $options['path'];
		} else {
			$this->dsn['path'] = 'var/sqlite';
		}
	} else {
		if($options['host']) {
			$this->dsn['host'] = $options['host'];
		} else {
			$this->dsn['host'] = 'localhost';
		}
		if($options['port']) {
			$this->dsn['port'] = $options['port'];
		} elseif($options['system']=='pgsql') {
			$this->dsn['port'] = '5432';
		} elseif($options['system']=='mysql') {
			$this->dsn['port'] = '3306';
		}
		$this->dsn['user'] = $options['user'];
		if($options['password']) {
			$this->dsn['password'] = $options['password'];
		}
	}
	$this->dsn['persistent'] = $options['persistent'];
	$this->dsn['init_when_build'] = 1;
	
	$this->data_set = $this->datasets_value[$this->page_type];
}


function write_conf($datasets_id) {
			require_once 'includes/datasets_conf/write.class.php';
			$write_conf = new datasets_conf_write();
			return $write_conf->write_conf($datasets_id,$all=true);
}

function create_table($datasets_id) {
			require_once 'includes/datasets_conf/create_table.class.php';
			$create_table = new datasets_conf_create_table();
			return $create_table->create_table($datasets_id,$command='create_table');
}


function set_sub_dir() {
	umask(0);
	switch($this->level) {
		case 'single':
			$this->view_dir = $this->application_path.'/view';
			$this->lib_dir = $this->application_path.'/lib/Pages';
			if(in_array($this->page_type,array('single','multi','googlemaps'))) {
				$this->classes_dir = $this->lib_dir.'/index_classes';
				make_dir($this->classes_dir,0777);
			}
			break;
		case 'dual':
			$this->view_dir = $this->application_path.'/view/'.$this->page_name;
			make_dir($this->view_dir,0777);
			$this->lib_dir = $this->application_path.'/lib/Pages';
			if(in_array($this->page_type,array('single','multi','googlemaps'))) {
				$this->classes_dir = $this->lib_dir.'/'.$this->page_name.'_classes';
				make_dir($this->classes_dir,0777);
			}
			break;
		case 'triple':
			$this->view_dir = $this->application_path.'/view/'.$this->folder_name.'/'.$this->page_name;
			make_dir($this->view_dir,0777);
			$this->lib_dir = $this->application_path.'/lib/Pages/'.$this->folder_name;
			if(in_array($this->page_type,array('single','multi','googlemaps'))) {
				$this->classes_dir = $this->lib_dir.'/'.$this->page_name.'_classes';
				make_dir($this->classes_dir,0777);
			}
			break;
	}
	
	switch($this->page_type) {
		case 'single':
		case 'multi':
			$this->include_parts_dir = $this->application_path.'/view/includes/'.$this->page_name;
			if(!file_exists($this->include_parts_dir))
				make_dir($this->include_parts_dir,0777);
			break;
		case 'upload':
			if(!is_dir($this->application_path.'/var/upload'))
				make_dir($this->application_path.'/var/upload',0777);
			break;
	}
}

function set_templates() {
	umask(0);
	$this->assign('class_name',$this->use_value[$this->type_no]['class']);
	$this->assign('dir_name',$this->use_value[$this->type_no]['dir']);
	$this->assign('page_name',$this->use_value[$this->type_no]['page']);
	$this->assign('page_title',$this->use_value[$this->type_no]['title']);
	$this->assign('data_name',$this->use_value[$this->type_no]['data']);
	$this->assign('db_name',$this->db_name);
	foreach($this->use_template[$this->type_no]['source'] as $key=>$source_file) {
		$target_file = $this->application_path.'/'.$this->use_template[$this->type_no]['target'][$key];
		$target_file = str_replace ('%page%',$this->page_name,$target_file);
		if($this->folder_name) $target_file = str_replace ('%subdir%',$this->folder_name,$target_file);
		$this->message .=  "template: ".$this->Quicty_modules."/$source_file -> $target_file\n";
		if(file_exists($target_file)) {
			make_dir($this->view_dir.'/old',0777);
			copy_files($target_file,$this->view_dir.'/old',0777);
			$this->message .=  "save old file '$target_file' to '$this->view_dir/old/'.\n";
		}
		$template_source_dir = file_exists($this->application_path.'/etc/modules/'.$source_file) ? $this->application_path.'/etc/modules' : $this->Quicty_modules;
		if(file_exists($template_source_dir.'/'.$source_file)) {
			$contents = file_get_contents($template_source_dir.'/'.$source_file,1);
			file_write_contents($target_file,$contents);
			$contents = $this->fetch($target_file);
			file_write_contents($target_file,$contents);
			chmod($target_file,0666);
		}
	}
	if(!in_array($this->page_type,array(1=>'upload','amazonsearch','googlemaps','blank')) ) {
		if(!file_exists($this->include_parts_dir.'/search_form.inc')) {
			$template_source_file = $this->Quicty_modules.'/view/parts/search_form.inc';
			$contents = file_get_contents($template_source_file,1);
			file_write_contents($this->include_parts_dir.'/search_form.inc',$contents);
			chmod($this->include_parts_dir.'/search_form.inc',0666);
		}
		if(!file_exists($this->include_parts_dir.'/sort_tab.inc')) {
			$template_source_file = $this->Quicty_modules.'/view/parts/sort_tab.inc';
			$contents = file_get_contents($template_source_file,1);
			file_write_contents($this->include_parts_dir.'/sort_tab.inc',$contents);
			chmod($this->include_parts_dir.'/sort_tab.inc',0666);
		}
	}
}

function set_class_module() {
	umask(0);
	$this->assign('class_name',$this->use_value[$this->type_no]['class']);
	$this->assign('dir_name',$this->use_value[$this->type_no]['dir']);
	$this->assign('page_name',$this->use_value[$this->type_no]['page']);
	$this->assign('page_title',$this->use_value[$this->type_no]['title']);
	$this->assign('data_name',$this->use_value[$this->type_no]['data']);
	$this->assign('db_name',$this->db_name);
	foreach($this->use_class[$this->type_no]['source'] as $key=>$source_file) {
		$target_file = $this->application_path.'/'.$this->use_class[$this->type_no]['target'][$key];
		$target_file = str_replace ('%page%',$this->page_name,$target_file);
		if($this->folder_name) $target_file = str_replace ('%subdir%',$this->folder_name,$target_file);
		$this->message .=  "class module: ".$this->Quicty_modules."/$source_file -> $target_file\n";
		if(file_exists($target_file)) {
			make_dir($this->lib_dir.'/old',0777);
			copy_files($target_file,$this->lib_dir.'/old',0666);
			$this->message .=  "save old file '$target_file' to '$this->lib_dir/old/'.\n";
		}
		$template_source_dir = file_exists($this->application_path.'/etc/modules/lib') ? $this->application_path.'/etc/modules' : $this->Quicty_modules;
		$contents = file_get_contents($template_source_dir.'/'.$source_file,1);
		//$contents = file_get_contents($this->Quicty_modules.'/'.$source_file,1);
		file_write_contents($target_file,$contents);
		$contents = $this->fetch($target_file);
		file_write_contents($target_file,$contents);
		chmod($target_file,0666);
	}
}

function save_action_list() {
	umask(0);
	$base_url = '{$b}';
	$page_title = '{$W.'.$this->page_name.'}';
	$W_add = '{$W.add}';
	$W_list = '{$W.list}';
	$W_batch_update = '{$W.batch_update}';
	$W_upload = '{$W.upload}';
	$W_search = '{$W.search}';
	$W_map_display = '{$W.map_display}';
	
	switch($this->level) {
		case 'single':
			if($this->page_type=='multi') {
				$action_list = "\n".<<<EOS
<li><a href="$base_url/add.html">$page_title $W_add</a></li>
<li><a href="$base_url/batch_update.html">$page_title $W_batch_update</a></li>
EOS;
			}
			break;

		case 'dual':
			if($this->page_type=='single') {
				$action_list = "\n".<<<EOS
<li><a href="$base_url/$this->page_name/">$page_title</a></li>
EOS;
			} elseif($this->page_type=='multi') {
				$action_list = "\n".<<<EOS
<li><a href="$base_url/$this->page_name/">$page_title $W_list</a></li>
<li><a href="$base_url/$this->page_name/add.html">$page_title $W_add</a></li>
<li><a href="$base_url/$this->page_name/batch_update.html">$page_title $W_batch_update</a></li>
EOS;
			} elseif($this->page_type=='upload') {
				$action_list = "\n".<<<EOS
<li><a href="$base_url/$this->page_name/upload.html">$page_title $W_upload</a></li>
EOS;
			} elseif($this->page_type=='amazonsearch') {
				$action_list = "\n".<<<EOS
<li><a href="$base_url/$this->page_name/index.html">$page_title Amazon$W_search</a></li>
EOS;
			} elseif($this->page_type=='googlemaps') {
				$action_list = "\n".<<<EOS
<li><a href="$base_url/$this->page_name/index.html">$page_title $W_map_display</a></li>
<li><a href="$base_url/$this->page_name/add.html">$page_title $W_add</a></li>
EOS;
			} elseif($this->page_type=='blank') {
				$action_list = "\n".<<<EOS
<li><a href="$base_url/$this->page_name/index.html">$page_title</a></li>
EOS;
			}
			break;

		case 'triple':
			if($this->page_type=='single') {
				$action_list = "\n".<<<EOS
<li><a href="$base_url/$this->folder_name/$this->page_name/">$page_title</a></li>
EOS;
			} elseif($this->page_type=='multi') {
				$action_list = "\n".<<<EOS
<li><a href="$base_url/$this->folder_name/$this->page_name/">$page_title $W_list</a></li>
<li><a href="$base_url/$this->folder_name/$this->page_name/add.html">$page_title $W_add</a></li>
<li><a href="$base_url/$this->folder_name/$this->page_name/batch_update.html">$page_title $W_batch_update</a></li>
EOS;
			} elseif($this->page_type=='upload') {
				$action_list = "\n".<<<EOS
<li><a href="$base_url/$this->folder_name/$this->page_name/upload.html">$page_title $W_upload</a></li>
EOS;
			} elseif($this->page_type=='amazonsearch') {
				$action_list = "\n".<<<EOS
<li><a href="$base_url/$this->folder_name/$this->page_name/index.html">$page_title Amazon$W_search</a></li>
EOS;
			} elseif($this->page_type=='googlemaps') {
				$action_list = "\n".<<<EOS
<li><a href="$base_url/$this->folder_name/$this->page_name/index.html">$page_title $W_map_display</a></li>
<li><a href="$base_url/$this->folder_name/$this->page_name/add.html">$page_title $W_add</a></li>
EOS;
			} elseif($this->page_type=='blank') {
				$action_list = "\n".<<<EOS
<li><a href="$base_url/$this->folder_name/$this->page_name/index.html">$page_title</a></li>
EOS;
			}
			break;
	}
	
	if(file_exists($this->application_path.'/view/includes/nav/action_list.inc')) {
		$action_list_file = $this->application_path.'/view/includes/nav/action_list.inc';
	} else {
		$action_list_file = $this->application_path.'/view/includes/action_list.inc';
	}
	
	if($action_list) {
		file_write_contents($action_list_file,$action_list,"a");
		@chmod($action_list_file,0666);
	}
}

function save_word_values() {
	umask(0);
	$word_values_file = $this->application_path.'/etc/conf/word_values_addition.conf';
	$word_values = '$'."this->W['".$this->page_name."'] = '".$this->page_title."';\n";

	file_write_contents($word_values_file,mb_convert_encoding($word_values,'UTF-8'),"a");
	@chmod($word_values_file,0666);

}

function save_datasets_to_db() {
	$insert_set['title'] = $this->dsn['title'];
	$insert_set['name'] = $this->dsn['dataname'];
	$insert_set['system'] = $this->dsn['system'];
	$insert_set['dbname'] = $this->dsn['dbname'];
	if($this->dsn['path']) $insert_set['path'] = $this->dsn['path'];
	if($this->dsn['host']) $insert_set['host'] = $this->dsn['host'];
	if($this->dsn['port']) $insert_set['port'] = $this->dsn['port'];
	if($this->dsn['user']) $insert_set['user'] = $this->dsn['user'];
	if($this->dsn['password']) $insert_set['password'] = $this->dsn['password'];
	$insert_set['application_id'] = $this->application_id;
	$insert_set['init_when_build'] = $this->dsn['init_when_build'];
	$datasets = $this->new_data_set('datasets');
	$result = $datasets->insert_table($insert_set);
	$datasets_id = $result['datasets']['id'];

	$fields = $this->new_data_set('fields');
	$seq = 1;
	foreach($this->data_set as $field) {
		$insert_set['datasets_id'] = $datasets_id;
		$insert_set['type'] = $field['type'];
		$hqf_type = $this->fields_reverse_map[$field['type']]['type'];
		$insert_set['hqf_type'] = $hqf_type;
		$insert_set['name'] = $field['name'];
		$insert_set['label'] = $field['label'];
		$insert_set['properties'] = serialize($field);
		$insert_set['search_flag'] = 1;
		$insert_set['sort_flag'] = 1;
		$insert_set['seq'] = $seq;
		$result = $fields->insert_table($insert_set);
		$seq++;
	}
	return $datasets_id;
}


} // end of class add_page
?>