<?php
require_once 'item_search_classes/_base.class.php';
class item_search extends item_search_base {

function dispatch_index() {
	$result = $this->display_record('');
	if($result['error']) {
		$table = array();
	} elseif($result) {
		$table = $this->make_table($result);
	}

	$this->assign_form('input_form',$this->form);
	$this->assign('table_view',$table['Items']);
	$this->assign('num',$table['num']);

	$this->page['name'] = 'ʸ';
	$this->assign('page',$this->page);
	return $this->display($this->current_template);
}

function make_table($result) {	
	$table['num']['TotalResults'] = $result['TotalResults'];
	$table['num']['TotalPages'] = $result['TotalPages'];
	$i = 0;
	foreach($result['Item'] as $item) {
		$asin = $item[ASIN];
		if($item['ItemAttributes']['EAN']) {
			$isbn = $item['ItemAttributes']['EAN'];
		} elseif($item['ItemAttributes']['ISBN']) {
			$isbn = $item['ItemAttributes']['ISBN'];
		} else {
			$isbn = $item['ASIN'];
		}
		$detail_url = $item['DetailPageURL'];
		$manufacture = $item['ItemAttributes']['Manufacturer'];
		$list_price = $item['ItemAttributes']['ListPrice']['Amount'];
		$title = $item['ItemAttributes']['Title'];
		if(isset($item['ItemAttributes']['Creator']['_content'])) {
			$creater = $item['ItemAttributes']['Creator']['_content'];
		} elseif(is_array($item['ItemAttributes']['Creator'])) {
			foreach($item['ItemAttributes']['Creator'] as $creater_set) {
				$creaters[] = $creater_set['_content'];
			}
			$creater = implode('',$creaters);
		}
		$small_image_url = $item['SmallImage']['URL'];
		$small_image_height_unit = $item['SmallImage']['Height']['Units'];
		$small_image_height = $item['SmallImage']['Height']['_content'];
		$small_image_width_unit = $item['SmallImage']['Width']['Units'];
		$small_image_width = $item['SmallImage']['Width']['_content'];
		if($small_image_url) {
			$small_image = "<img src=\"$small_image_url\" width=\"$small_image_width\" height=\"$small_image_height\" border=\"0\" />";
			$small_image_tag = htmlentities($small_image);
		}

		$medium_image_url = $item['MediumImage']['URL'];
		$medium_image_height_unit = $item['MediumImage']['Height']['Units'];
		$medium_image_height = $item['MediumImage']['Height']['_content'];
		$medium_image_width_unit = $item['MediumImage']['Width']['Units'];
		$medium_image_width = $item['MediumImage']['Width']['_content'];
		if($medium_image_url) {
			$medium_image = "<img src=\"$medium_image_url\" width=\"$medium_image_width\" height=\"$medium_image_height\" border=\"0\" />";
			$medium_image_tag = htmlentities($medium_image);
		}

		$table['Items'][$i]['asin'] = array('label'=>'ASIN','value'=>$asin,'body'=>$asin);
		$table['Items'][$i]['isbn'] = array('label'=>'ISBN','value'=>$isbn,'body'=>$isbn);
		$table['Items'][$i]['title'] = array('label'=>'ȥ','value'=>$title,'body'=>$title);
		$table['Items'][$i]['creater'] = array('label'=>'','value'=>$creater,'body'=>$creater);
		$table['Items'][$i]['manufacture'] = array('label'=>'ȯ丵','value'=>$manufacture,'body'=>$manufacture);
		$table['Items'][$i]['list_price'] = array('label'=>'','value'=>$list_price,'body'=>$list_price);
		$table['Items'][$i]['detail_url'] = array('label'=>'URL','value'=>$detail_url,'body'=>$detail_url);
		$table['Items'][$i]['small_image'] = array('label'=>'','value'=>$small_image,'body'=>$small_image_tag);
		$table['Items'][$i]['medium_image'] = array('label'=>'','value'=>$medium_image,'body'=>$medium_image_tag);
		$table['Items'][$i]['properties'] = serialize($item);
		$i++;
	}
	return $table;
}

} // end of item_search class
?>