<?php
require_once 'Services/AmazonECS4.php';
class amazon_search {

var $access_key='';
var $associate_id='';
var $amazon; // instance of amazon
var $search_kind_array=array();
var $sort_option_array=array();
var $response_options = array('Sort'=>'salesrank',
						'ResponseGroup' =>'Small,Images,ItemAttributes');
var $search_kind = 'Books';

function amazon_search($access_key,$associate_id,$cache_dir = '/tmp') {
	$this->access_key = $access_key;
	$this->associate_id = $associate_id;
	$this->init_options();
	$this->amazon = new Services_AmazonECS4($this->access_key,$this->associate_id);
	$this->amazon->setLocale('JP');
	$this->amazon->setVersion('2007-01-17');
	$dir_path = explode('/',dirname(__FILE__));
	$dummy = array_pop($dir_path);
	$home_dir = implode('/',$dir_path);
	
	$result = $this->amazon->setCache('file',array('cache_dir' => $cache_dir));
	if (PEAR::isError($result)) {
		echo htmlspecialchars($result->message, ENT_QUOTES);
		echo "Quicty error : Amazon.class.php : å˼Ԥޤ";
		exit();
	}
	$this->amazon->setCacheExpire(24*60*60);
}

function keyword_search($keywords) {
	$code = mb_internal_encoding();
	$myKeywords = $keywords;
	mb_convert_variables('UTF-8',$code,$myKeywords);
	$this->response_options['Keywords'] = $myKeywords;
	$result = $this->amazon->ItemSearch($this->search_kind,$this->response_options);
	if (PEAR::isError($result)) {
		$tmp['error'] = true;
		$error_message = mb_convert_encoding($result->message,$code,'UTF-8');
		$tmp['message'] = htmlspecialchars($error_message, ENT_QUOTES);
		$result = $tmp;
	} else {
		mb_convert_variables($code,'UTF-8',$result);
	}
	return $result;
}

function asin_search($asin) {
	$code = mb_internal_encoding();
	$pattern = array('ISBN','isbn','Isbn','ASIN','asin','Asin','-');
	$myAsin = str_replace($pattern,'',$asin);
	if(strlen($myAsin)==13) {
		$this->response_options['IdType'] = 'ISBN';
		$this->response_options['SearchIndex'] = 'Books';
	}
	$result = $this->amazon->ItemLookup($myAsin,$this->response_options);
	if (PEAR::isError($result)) {
		$tmp['error'] = true;
		$error_message = mb_convert_encoding($result->message,$code,'UTF-8');
		$tmp['message'] = htmlspecialchars($error_message, ENT_QUOTES);
		$result = $tmp;
	} else {
		mb_convert_variables($code,'UTF-8',$result);
	}
	return $result;
}


//-------------------------------------------------------------

function set_response_option($response_group='',$sort_option='') {
	if($response_group) {
		$myResponse_group = $response_group;
	} else {
		$myResponse_group = 'Small,Images,ItemAttributes,SalseRank';
	}
	if($sort_option and array_key_exists($sort_option,$this->sort_option_array)) {
		$mySort_option = $sort_option;
	} else {
		$mySort_option = 'salesrank';
	}
	$this->response_options = array(
		'Sort' => $mySort_option,
		'ResponseGroup' => $myResponse_group,
	);
	return $this->response_options;
}


function set_search_kind($search_kind) {
	if($search_kind and 
		array_key_exists($search_kind,$this->search_kind_array)) {
		$this->search_kind = $search_kind;
	} else {
		$this->search_kind = 'Books';
	}
	return $this->search_kind;
}


function init_options() {
	$this->search_kind_array = array(
		'Books'=>'ҡ½',
		'Classical'=>'饷å',
		'DVD'=>'DVD',
		'Electronics'=>'Ų',
		'ForeignBooks'=>'ҡν',
		'Hobbies'=>'ۥӡ',
		'Kitchen'=>'ۡå',
		'Music'=>'',
		'MusicTracks'=>'ڡʶ̾',
		'Software'=>'եȥ',
		'SportingGoods'=>'ݡ',
		'Toys'=>'ۥӡ',
		'VHS'=>'ӥǥ',
		'Video'=>'DVDӥǥ',
		'VideoGames'=>'',
		'Blended'=>'٤'
	);
	$this->sort_option_array = array(
		'salserank'=>'夲',
		'pricerank'=>'ʽʰ¤',
		'-pricerank'=>'ʽʹ⤤',
		'titlerank'=>'̾',
		'-titlerank'=>'̾ս',
		'orig-rel-date'=>'ꥸʥȯʸŤ',
		'-orig-rel-date'=>'ꥸʥȯʿ',
		'release-date'=>'ȯʸŤ',
		'-release-date'=>'ȯʿ'
	);
}


} // end of class amazon_search

?>