<?php
/**
 *	Project:	Quicty: Quick application build environment depends on PEAR and Smarty
 *	File:		DataSet.class.php
 *
 *	@copyright	Tomoyuki Negishi and ZubaPitaTech, Inc.
 *	@author		Tomoyuki Negishi <tomoyu-n@zubapita.jp>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Quicty
 *	@version	$Id:$
 */

// {{{ DataSet
/**
 *	DataSet Create, validate and process HTML forms with easy settings and O/R mapping class.
 *
 *	@author		Tomoyuki Negishi <tomoyu-n@zubapita.jp>
 *	@access		public
 *	@package	Quicty
 */
class DataSet extends DataView{
protected $pdo;
protected $use_pdo = true;
protected $__db_system_type;
protected $__transaction_mode;
protected $__dsn;
public $tables;
public $bind_form2column;
public $bind_column2form;

function DataSet($formName='', $method='post', $action='', $target='', $attributes=null, $trackSubmit=false) {
	DataView::DataView($formName, $method, $action, $target, $attributes, $trackSubmit);
	$this->data_set_config_dir = '/etc/data_set';
}

function bind_data_set($data_set_file) {
	if(function_exists(apc_fetch)) {
		$data_set = unserialize(apc_fetch('CONFIG_SET_'.$data_set_file));
	}
	if(!$data_set) {
		$config_dir = $this->__page_obj->home_dir.$this->data_set_config_dir;
		$data_set_array = $this->read_conf_to_array($config_dir,$data_set_file);
		$data_set = $data_set_array['root'];
		if(function_exists(apc_store)) {
			$result = apc_store('CONFIG_SET_'.$data_set_file,serialize($data_set));
		}
	}
	foreach($data_set as $data_set_name=>$attributes) {
		if($data_set_name=='dsn') {
			$this->__dsn = $attributes;
			switch($this->__dsn['system']) {
				case 'pgsql':
					$this->escape_string_func = 'pg_escape_string';
					break;
				case 'mysql':
					$this->escape_string_func = 'mysql_real_escape_string';
					break;
				case 'sqlite':
					$this->escape_string_func = 'sqlite_escape_string';
					break;
			}
		} elseif($data_set_name=='bind') {
			$this->bind_table($attributes);
		} else {
			$this->tables[$data_set_name] = $attributes;
		}
	}
}



function bind_auth_set($data_set_file) {
	$data_set_array = $this->read_conf_to_array($this->data_set_config_dir,$data_set_file);
	foreach($data_set_array['root'] as $data_set_name=>$attributes) {
		if($data_set_name=='dsn') {
			$system = $attributes['system'];
			$dbname = $attributes['dbname'];
			$host = $attributes['host'];
			$port = $attributes['port'];
			$user = $attributes['user'];
			$password = $attributes['password'];
			if(!$system) {
				die('dsn: no system type! e.g.:pgsql');
			} else {
				$dsn = $system.'://';
				if($user) {
					$dsn .= $user;
					if($password) $dsn .= ':'.$password;
					$dsn .= '@';
				}
				if($host) {
					$dsn .= $host;
					if($port) $dsn .= ':'.$port;
				}
				if($dbname) $dsn .= '/'.$dbname;
			}
			$auth_params['dsn'] = $dsn;
		} elseif($data_set_name=='bind') {
			foreach($attributes as $auth_field=>$t_column) {
				list($table,$column) = explode('.' , $t_column);
				$auth_params['table'] = $table;
				$auth_params[$auth_field] = $column;
			}
		}
	}
	return $auth_params;
}


function new_auth_object($data_set_file,$strage_driver='DB') {
	$auth_params = $_FORM->bind_auth_set($data_set_file);
	$auth_obj = new Auth($strage_driver,$auth_params,NULL,false);
	return $auth_obj;
}


function bind_table($bind_array) {
	global $quicksmart_datatype;
	//echo "$bind_array=";print_r($bind_array);echo "<br>";
	foreach($bind_array as $form_property=>$column_property) {
		list($form,$qs_type) = explode(':', $form_property);
		$qs_type = $quicksmart_datatype[$qs_type]['hqf_type'];
		list($table,$column_and_type) = explode('.', $column_property);
		list($column,$column_type) = explode(':', $column_and_type);
		$this->bind_form2column[$form] = array(
			'qs_type'=>$qs_type,'table'=>$table,'column'=>$column,'column_type'=>$column_type);
		$this->bind_column2form[$table][$column] = array(
			'form'=>$form,'qs_type'=>$qs_type,'column_type'=>$column_type);
	}
}


//--------------------------------------------------------
//  Handling DataView status
//--------------------------------------------------------

function automatic_form_handler($condition='') {
	switch($this->__page_obj->QuictyStatus) {
		case 'EDIT':
		case 'BROWSE':
		case 'DELETE_CONFIRM':
			if($condition) {
				$row = $this->select_table($condition);
			} elseif($_GET[$this->id_column]) {
				$row = $this->select_table('where '.$this->id_column.'='.$_GET[$this->id_column]);
			} else{
				$result['error'] = $status.''.$this->id_column.'ꤵƤޤ';
				$row = array();
			}
			$record = $this->form_table_value($row);
			$set_values = $record[0];
			if($this->__page_obj->QuictyStatus=='EDIT' and count($this->__force_values)) {
				foreach($this->__force_values as $column=>$force_values) {
					if($force_values['auto_only_1st']!='yes') {
						if($force_values['call_function']=='yes') {
							$set_values[$column] = eval($force_values[$column]);
						} else {
							$set_values[$column] = $force_values[$column];
						}
					}
				}
			}
			$this->setDefaults($set_values);
			$result['values'] = $set_values;
			$result['count'] = count($row);
			break;
		case 'INSERT':
			$result = $this->save();
			break;
		case 'UPDATE':
			if($condition) {
				$result = $this->save($condition);
			} elseif($_POST[$this->id_column]) {
				$result = $this->save('where '.$this->id_column.'='.$_POST[$this->id_column]);
			} else {
				$result['error'] = $status.''.$this->id_column.'ꤵƤޤ';
			}
			break;
		case 'DELETE':
			if($condition) {
				$result = $this->delete($condition);
			} elseif($_POST[$this->id_column]) {
				$result = $this->delete('where '.$this->id_column.'='.$_POST[$this->id_column]);
			} else {
				$result['error'] = $status.''.$this->id_column.'ꤵƤޤ';
			}
			break;
	}
	return $result;
}

//--------------------------------------------------------
//  db Basic
//--------------------------------------------------------


function connect_pdo($dsn_array) {
	$system = $dsn_array['system'];
	$dbname = $dsn_array['dbname'];
	$host = $dsn_array['host'];
	$port = $dsn_array['port'];
	$user = $dsn_array['user'];
	$password = $dsn_array['password'];
	$persistent = (bool) $dsn_array['persistent'];
	$path = $dsn_array['path'];
	if(substr($path,0,1)!='/') $path = $this->__page_obj->home_dir.'/'.$path;
	try {
		if($system=='pgsql') {
			if(!$port) $port = '5432';
			if($this->use_pdo) {
				$dsn = "pgsql:host=$host port=$port dbname=$dbname user=$user password=$password";
				$this->pdo = new PDO($dsn,$user,$password,array(PDO::ATTR_PERSISTENT => $persistent));
			} elseif($persistent) {
				$this->pdo = pg_pconnect("host=$host dbname=$dbname user=$user password=$password")
					 or die('Could not connect: ' . pg_last_error());
			} else {
				$this->pdo = pg_connect("host=$host dbname=$dbname user=$user password=$password")
					 or die('Could not connect: ' . pg_last_error());
			}
		} elseif($system=='mysql') {
			if(!$port) $port = '3307';
			$dsn = "mysql:dbname=$dbname;host=$host;port=$port";
			$this->pdo = new PDO($dsn,$user,$password,array(PDO::ATTR_PERSISTENT => $persistent));
		} elseif($system=='sqlite') {
			$dsn = "sqlite2:$path/$dbname";
			$this->pdo = new PDO($dsn,'','');
		} else {
			$dsn = "$system:dbname=$dbname;host=$host;port=$port";
			$this->pdo = new PDO($dsn,$user,$password,array(PDO::ATTR_PERSISTENT => $persistent));
		}
		if(!$this->pdo) {
			die("Quicty error!:Can't connect database:$dsn\n");
		}
		if($this->use_pdo)
			$this->pdo->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
		$this->__db_system_type = $system;
	} catch (PDOException $e) {
		echo $e->getMessage();
	}
}

function exec_sql($sql) {
	if(!isset($this->pdo)) $this->connect_pdo($this->__dsn);
	try {
		if($this->use_pdo) {
			$stmt = $this->pdo->prepare($sql);
			$result = $stmt->execute();
		} else {
			switch($this->__db_system_type) {
				case 'pgsql':
					$result = pg_query($this->pdo,$sql) or die('Query failed: ' . pg_last_error());
					break;
			}
		
		}
	} catch (PDOException $e) {
		echo "sql=$sql<br>\n";
		echo $e->getMessage();
	}
	return $result;
}

//--------------------------------------------------------
//  transaction wrapper method
//--------------------------------------------------------
function transaction_begin() {
	$this->__transaction_mode = true;
	if($this->use_pdo) {
		$this->pdo->beginTransaction();
	} else {
		switch($this->__db_system_type) {
			case 'pgsql':
				pg_query( $this->pdo, "BEGIN TRANSACTION");
				break;
		}
	}
}

function transaction_commit() {
	if($this->use_pdo) {
		$this->pdo->commit();
	} else {
		switch($this->__db_system_type) {
			case 'pgsql':
				pg_query( $this->pdo, "COMMIT TRANSACTION");
				break;
		}
	}
	$this->__transaction_mode = false;
}

function transaction_rollback() {
	if($this->use_pdo) {
		$this->pdo->rollback();
	} else {
		switch($this->__db_system_type) {
			case 'pgsql':
				pg_query( $this->pdo, "ROLLBACK TRANSACTION");
				break;
		}
	}
	$this->__transaction_mode = false;
}

function is_transaction() {
	return $this->__transaction_mode;
}
//--------------------------------------------------------
//  save(insert/ update) table
//--------------------------------------------------------
function save($condition='',$mergeFiles = true) {
	if($mergeFiles === true) {
		$values = HTML_QuickForm::arrayMerge($this->_submitValues, $this->_submitFiles);
	} else {
		$values = $this->_submitValues;
	}
	//print_r($values);
	if($condition) {
		$result = call_user_func(array($this,'update_table'), $values, $condition);
	} else {
		$result = call_user_func(array($this,'insert_table'), $values);
	}
	return $result;
} 


function insert_table($data) {
	if(!isset($this->pdo)) $this->connect_pdo($this->__dsn);
	foreach($this->bind_column2form as $this->current_table=>$columns) {
		foreach($columns as $column=>$properties) {
			if(isset($data[$column])) {
				$icoumns_array[] = $column;
				$data_type = $properties['qs_type'];
				if($this->__force_values[$column]['call_function_last'] == 'yes') {
					eval($data[$column]);
					$data[$column] = $eval_result;
				}
				//echo "data_type=$data_type<br>";
				$value = call_user_func(array($this,'save_'.$data_type.'_value'),$column,$data[$column]);
				$ivalues_array[] = $value;
				$result[$this->current_table][$column] = $value;
			}
		}
		$icolumns = implode(',', $icoumns_array);
		$ivalues = implode(',', $ivalues_array);
		$sql = "INSERT INTO $this->current_table ($icolumns) VALUES ($ivalues)";
		$result[$this->current_table]['sql'] = $sql;
		try {
			if($this->use_pdo) {
				$stmt = $this->pdo->prepare($sql);
				if($stmt->execute())
					$result[$this->current_table]['count'] = $stmt->rowCount;
				//$result[$this->current_table]['count'] = $stmt->execute();
				if($this->__db_system_type=='pgsql') {
					$sequencer = $this->current_table.'_id_seq';
					$result[$this->current_table]['id'] = $this->pdo->lastInsertId($sequencer);
				} else {
					$result[$this->current_table]['id'] = $this->pdo->lastInsertId();
				}
			} else {
				switch($this->__db_system_type) {
					case 'pgsql':
						$sequencer = $this->current_table.'_id_seq';
						if($this->is_transaction()) $already_transaction = true;
							else $this->transaction_begin();
						$rtn = pg_query( $this->pdo, $sql);
						$result[$this->current_table]['count'] = pg_affected_rows($rtn);
						$rtn = pg_query( $this->pdo, "SELECT CURRVAL('$sequencer') AS seq" );
						$data = pg_fetch_assoc( $rtn );
						pg_free_result( $rtn );
						if($already_transaction) $already_transaction = false;
							else $this->transaction_commit();
						$result[$this->current_table]['id'] = $data[ 'seq' ];
						break;
				}
			}
			$result[$this->current_table]['state'] = true;
		} catch (PDOException $e) {
			echo "sql=$sql<br>\n";
			echo $e->getMessage();
			if($this->__transaction_mode) {
				$this->rollback();
				$result[$this->current_table]['state'] = false;
				$result[$this->current_table]['count'] = 0;
				return $result;
			}
		}
	}
	return $result;
}

function update_table($data,$condition) {
	if(!isset($this->pdo)) $this->connect_pdo($this->__dsn);
	foreach($this->bind_column2form as $this->current_table=>$columns) {
		$update_set_array = array();
		foreach($columns as $column=>$properties) {
			//echo "column=$column / data=".$data[$column]."<br>";
			if(isset($data[$column])) {
				$data_type = $properties['qs_type'];
				if($this->__force_values[$column]['call_function_last'] == 'yes') {
					eval($data[$column]);
					$data[$column] = $eval_result;
				}
				$value = call_user_func(array($this,'save_'.$data_type.'_value'),$column,$data[$column]);
				if($data_type=='password' and $value===NULL) continue;
				$update_set_array[]= $column.'='.$value;
				$result[$this->current_table][$column] = $value;
			}
		}
		if(count($update_set_array)<1) {
			die('Quicty error:there is no column in update set');
		}
		$update_set = implode(',',$update_set_array);
		$sql = "UPDATE $this->current_table SET $update_set $condition";
		$result[$this->current_table]['sql'] = $sql;
		try {
			if($this->use_pdo) {
				$stmt = $this->pdo->prepare($sql);
				if($stmt->execute())
					$result[$this->current_table]['count'] = $stmt->rowCount;
			} else {
				switch($this->__db_system_type) {
					case 'pgsql':
						$rtn = pg_query( $this->pdo, $sql);
						$result[$this->current_table]['count'] = pg_affected_rows($rtn);
						pg_free_result( $result );
						break;
				}
			}
			$result[$this->current_table]['state'] = true;
		} catch (PDOException $e) {
			echo $e->getMessage();
			if($this->__transaction_mode) {
				$this->rollback();
				$result[$this->current_table]['state'] = false;
				$result[$this->current_table]['count'] = 0;
				return $result;
			}
		}
	}
	return $result;
}

function save_advcheckbox_value($column,$value) {
	$result = NULL;
	foreach($this->data_view[$column]['values'] as $key=>$t_value) {
		if($t_value==$value) {
			$result = $key;
			break;
		}
	}
	return $result;
}

function save_checkbox_value($column,$value) {
	return $value;
}

function save_date_value($column,$value) {
	$second = empty($value['s']) ? '00' : $value['s'];
	$minutes = empty($value['i']) ? '00' : $value['i'];
	$hour = isset($value['H']) ? $value['H'] : '00';
	$hour = isset($value['h']) ? $value['h'] : $hour;
	$ampm = isset($value['A']) ? $value['A'] : isset($value['a']) ? $value['a'] : NULL;
	$day = isset($value['d']) ? $value['d'] : NULL;
	$weekday = isset($value['D']) ? $value['D'] : isset($value['l']) ? $value['l'] : NULL;
	$month = isset($value['M']) ? $value['M'] : isset($value['F']) ? $value['F'] : isset($value['m']) ? $value['m'] : NULL;
	$year = isset($value['Y']) ? $value['Y'] : NULL;
	if($year) {
		$result = $year.'-'.$month.'-'.$day.' '.$hour.':'.$minutes.':'.$second;
	} else {
		$result = $hour.':'.$minutes.':'.$second;
	}
	if($ampm) $result .= ' '.$ampm;
	return "'$result'";
}

function save_hidden_value($column,$value) {
	$data_type = $this->bind_column2form[$this->current_table][$column]['column_type'];
	//echo "column_type=".$GLOBALS['quicty_data_column_type'][$data_type]."<br>\n";
	if($GLOBALS['quicty_data_column_type'][$data_type]=='numeric') {
		if(is_numeric($value)) {
			return $value;
		} else {
			return 'NULL';
		}
	} else {
		return "'$value'";
	}
}

function save_hireselect_value($column,$value) {
	$result = $value[$column];
	return $result;
}

function save_int_value($column,$value) {
	return $value;
}

function save_password_value($column,$value) {
	if($value) {
		$md5pass = md5($value);
		return "'$md5pass'";
	} else {
		return NULL;
	}
}

function save_radio_value($column,$value) {
	$result = "'".$value[$column]."'";
	return $result;
}

function save_select_value($column,$value) {
	return $value;
}

function save_text_value($column,$value) {
	if($this->__force_escape_filter) 
		$value = call_user_func($this->escape_string_func,$value);
	return "'$value'";
}

function save_textarea_value($column,$value) {
	if($this->__force_escape_filter) 
		$value = call_user_func($this->escape_string_func,$value);
	return "'$value'";
}


//--------------------------------------------------------
//  delete table
//--------------------------------------------------------
function delete($condition='') {
	if(!isset($this->pdo)) $this->connect_pdo($this->__dsn);
	foreach($this->bind_column2form as $table=>$columns) {
		$sql = "DELETE FROM $table $condition";
		$result[$this->current_table]['sql'] = $sql;
		try {
			if($this->use_pdo) {
				$stmt = $this->pdo->prepare($sql);
				if($stmt->execute())
					$result[$this->current_table]['count'] = $stmt->rowCount;
				//$result[$table]['count'] = $stmt->execute();
			} else {
				switch($this->__db_system_type) {
					case 'pgsql':
						$rtn = pg_query( $this->pdo, $sql);
						$result[$this->current_table]['count'] = pg_affected_rows($rtn);
						pg_free_result($rtn);
						break;
				}
			}
			$result[$table]['state'] = true;
		} catch (PDOException $e) {
			echo $e->getMessage();
			if($this->__transaction_mode) {
				$this->rollback();
				$result[$table]['state'] = false;
				$result[$table]['count'] = 0;
				return $result;
			}
		}
	}
	return $result;
}

//--------------------------------------------------------
//  select table
//--------------------------------------------------------
function select($condition='',$fields='*') {
	return $this->select_table($condition,$fields);
}
function select_table($condition='',$fields='*') {
	if(!isset($this->pdo)) $this->connect_pdo($this->__dsn);
	foreach($this->bind_column2form as $table=>$columns) {
		$sql = "SELECT $fields FROM $table $condition";
		//echo "sql=$sql<br>\n";
		try {
			if($this->use_pdo) {
				$stmt = $this->pdo->prepare($sql);
				if($stmt->execute())
					$table_values = $stmt->fetchAll(PDO::FETCH_ASSOC);
				//$table_values = $this->pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
			} else {
				switch($this->__db_system_type) {
					case 'pgsql':
						$rtn = pg_query( $this->pdo, $sql);
						$table_values = pg_fetch_all($rtn);
						pg_free_result($rtn);
						break;
				}
			}
		} catch (PDOException $e) {
			echo "sql=$sql<br>\n";
			echo $e->getMessage();
		}
	}
	return $table_values;
}

function count_rows($condition='') {
	if(!isset($this->pdo)) $this->connect_pdo($this->__dsn);
	foreach($this->bind_column2form as $table=>$columns) {
		$sql = "SELECT count(id) FROM $table $condition";
		try {
			if($this->use_pdo) {
				$stmt = $this->pdo->prepare($sql);
				if($stmt->execute()) {
					$table_values = $stmt->fetchAll(PDO::FETCH_ASSOC);
					$num = $table_values[0]['count(id)'];
				}
			} else {
				switch($this->__db_system_type) {
					case 'pgsql':
						$rtn = pg_query( $this->pdo, $sql);
						$num = pg_num_rows($rtn);
						pg_free_result($rtn);
						break;
				}
			}
		} catch (PDOException $e) {
			echo "sql=$sql<br>\n";
			echo $e->getMessage();
		}
	}
	return $num;
}

//--------------------------------------------------------
//  select table with Pager
//--------------------------------------------------------

var $__pager_per_page = 20;
var $__pager_condition;
var $__pager_params;
var $__pager;

function bind_pager(array $params=array()) {
	$this->__pager_condition = isset($params['condition']) ? $params['condition'] : '';
	$total_items = $this->count_rows($this->__pager_condition);
	$per_page = $params['perPage'] ? $params['perPage'] : $this->__pager_per_page;
	foreach($params as $key=>$value) {
		$this->__pager_params[$key] = $value;
	}
	if(!array_key_exists('importQuery',$params)) {
		$this->__pager_params['importQuery'] = true;
	}
	$this->__pager_params['perPage'] = $per_page;
	$this->__pager_params['totalItems'] = $total_items;
	$this->__pager = Pager::factory($this->__pager_params);
}

function select_table_with_pager($condition='',$fields='*') {
	if($this->__pager_condition) 
		$condition = $this->__pager_condition.' '.$condition;
	$per_page = $this->__pager_params['perPage'];
	list($offset,$offset_end) = $this->__pager->getOffsetByPageId();
	$offset = $offset-1;
	$table_values = $this->select_table($condition.' limit '.$per_page.' offset '.$offset,$fields);
	return $table_values;
}

function get_pager_links() {
	return $this->__pager->getLinks();
}

function set_pager_per_page($num) {
	if($num) $this->__pager_per_page = $num;
	return $this->__pager_per_page;
}

//--------------------------------------------------------
//  get value from table DataSet.class.php version
//--------------------------------------------------------

// Quick build new data_view and data_set And object cache
//		DataSet.class.php version

public $memcached;
public $memcache_compress;
public $memcache_expire;

public function new_memcache() {
	if($this->memcached and class_exists('Memcache')) {
		isset($this->__page_obj->C['MEMCACHED_HOST'])
			? $memcached_host = $this->__page_obj->C['MEMCACHED_HOST']
			: $memcached_host = 'localhost';
		isset($this->__page_obj->C['MEMCACHED_PORT'])
			? $memcached_port = $this->__page_obj->C['MEMCACHED_PORT']
			: $memcached_port = '11211';
		$memcache = new Memcache;
		$memcache->connect($memcached_host,$memcached_port) or die ("memcached³ǤޤǤ");
	}
	return $memcache;
}


public function new_data_set($set_name) {

	if($this->memcached) {
		if(!is_object($this->memcache)) $this->memcache = $this->new_memcache();
		$DATA_SET_CACHE = $this->memcache->get('DATA_SET');
	}
	if(isset($DATA_SET_CACHE[$set_name])) {
		$data_set = $DATA_SET_CACHE[$set_name];
	} else {
		$data_set = $this->__page_obj->new_data_obj($set_name);
		$data_set->bind_data_view($set_name.'.view.conf');
		$data_set->bind_data_set($set_name.'.set.conf');	
		$DATA_SET_CACHE[$set_name] = $data_set;
		if($this->memcached)
			$this->memcache->set('DATA_SET',$DATA_SET_CACHE,
					$this->memcache_compress,$this->memcache_expire);
	}
	return $data_set;
}

function get_value_from_table($key,$tmp_array) {
	if($data_set = $tmp_array['_TABLE']) {
		$field = $tmp_array['_GET_COLUMN'];
		if(!is_object($this->reference_cache[$data_set]['object'])) {
			$this->reference_cache[$data_set]['object'] = $this->__page_obj->new_data_set($data_set);
			//$this->reference_cache[$data_set]['object'] = $this->new_data_set($data_set);
			/*
			$this->reference_cache[$data_set]['object'] = $this->__page_obj->new_data_obj($data_set);
			$this->reference_cache[$data_set]['object']->bind_data_view($data_set.'.view.conf');
			$this->reference_cache[$data_set]['object']->bind_data_set($data_set.'.set.conf');
			*/
		}
		if($this->reference_cache[$data_set][$key][$field]) {
			$result = $this->reference_cache[$data_set][$key][$field];
		} else {
			if(!is_numeric($key)) $key = "'$key'";
			$where = 'where '.$tmp_array['_WHERE_COLUMN'].'='.$key;
			$table = $this->reference_cache[$data_set]['object']->select_table($where,$field);
			$result = $table[0][$field];
			$this->reference_cache[$data_set][$key][$field] = $result;
		}
	} elseif($data_set = $tmp_array['_THIS_ARRAY']) {
		$array = $this->__page_obj->$data_set;
		if($key_2nd = $tmp_array['_2ND_COLUMN']) {
			if($key_3rd = $tmp_array['_3RD_COLUMN']) {
				$result = $array[$key][$key_2nd][$key_3rd];
			} else {
				$result = $array[$key][$key_2nd];
			}
		} else {
			$result = $array[$key];
		}
	}
	return $result;
}


//-----------------------------------------------------
// FORMɽfunction
//-----------------------------------------------------

function form_table_value($table_values) {
	foreach($table_values as $key=>$row) {
		$new_row = array();
		foreach($row as $column=>$value) {
			$qs_type = $this->data_view[$column]['type'];
			if(!$qs_type) {
				//echo 'Quicty error:'.$column."'s qs_type is not found.<br>\n";
				$new_row[$column] = $value;
			} else {
				$new_row[$column] = call_user_func(array($this,'form_'.$qs_type.'_value'),$column,$value);
			}
		} 
		$form_table[$key] = $new_row;
	}
	return $form_table;
}

function form_advcheckbox_value($column,$value) {
	return $this->data_view[$column]['values'][$value];
}

function form_checkbox_value($column,$value) {
	return $value;
}

function form_date_value($column,$value) {
	$da = strptime($value,'%Y-%m-%d %H:%M:%S');
	$timestamp = mktime($da['tm_hour'],$da['tm_min'],$da['tm_sec'],$da['tm_mon']+1,$da['tm_mday'],$da['tm_year']+1900);
	list($year,$mon_short,$mon_full,$month,$wday,$wday_full,$day,$hour_24,$hour_12,$minutes,$second,$am_lower,$am_upper) 
		= explode(',', date("Y,M,F,m,D,l,d,H,h,i,s,a,A",$timestamp));
	$result =  array('Y'=>$year,'M'=>$mon_short,'F'=>$mon_full,'m'=>$month,'D'=>$wday,'l'=>$wday_full,'d'=>$day,'H'=>$hour_24,'h'=>$hour_12,'i'=>$minutes,'s'=>$second,'a'=>$am_lower,'A'=>$am_upper);
	return $result;
}

function form_hidden_value($column,$value) {
	return $value;
}

function form_hireselect_value($column,$value) {
	return array($column=>$value);
}

function form_int_value($column,$value) {
	return $value;
}

function form_password_value($column,$value) {
	return NULL;
}

function form_radio_value($column,$value) {
	return array($column=>$value);
}

function form_select_value($column,$value) {
	return $value;
}

function form_text_value($column,$value) {
	return $value;
}

function form_textarea_value($column,$value) {
	return $value;
}



//-----------------------------------------------------
// TABLEɽfunction
//-----------------------------------------------------
function display_table_value($table_values) {
	$sequence = 1;
	if(is_array($table_values) and count($table_values)>0) {
		foreach($table_values as $key=>$row) {
			$new_row = array();
			$new_row['sequence']['value'] = $sequence;
			foreach($row as $column=>$value) {
				if($qs_type = $this->data_view[$column]['qs_type']) {
					$body = call_user_func(array($this,'display_'.$qs_type.'_value'),$column,$value);
					$new_row[$column]['label'] = $this->data_view[$column]['label'];
					$new_row[$column]['type'] = $this->data_view[$column]['type'];
					$new_row[$column]['qs_type'] = $this->data_view[$column]['qs_type'];
					$new_row[$column]['value'] = $value;
					$new_row[$column]['body'] = $body;
				}
			} 
			$sequence++;
			$display_table[$key] = $new_row;
		}
	}
	return $display_table;
}

function display_advcheckbox_value($column,$value) {
	$list = $this->data_view[$column]['values'];
	$result = $list[$value];
	return $result;
}

function display_checkbox_value($column,$value) {
	return $value;
}

function display_date_value($column,$value) {
	$format = $this->data_view[$column]['opt']['format'];
	$result = date($format,strtotime($value));
	return $result;
}

function display_hidden_value($column,$value) {
	if($this->data_view[$column]['reference']) {
		$result = $this->get_value_from_table($value,$this->data_view[$column]['reference']);
	} else {
		$result = $value;
	}
	return $result;
}

function display_hireselect_value($column,$value) {
	$list = $this->data_view[$column]['list'];
	$result = $list[$value];
	return $result;
}

function display_id_value($column,$value) {
	return $value;
}

function display_int_value($column,$value) {
	return $value;
}

function display_password_value($column,$value) {
	return NULL;
}


function display_radio_value($column,$value) {
	$list = $this->data_view[$column]['list'];
	$result = $list[$value];
	return $result;
}

function display_select_value($column,$value) {
	$list = $this->data_view[$column]['value'];
	$result = $list[$value];
	return $result;
}

function display_text_value($column,$value) {
	if($this->data_view[$column]['reference']) {
		$result = $this->get_value_from_table($value,$this->data_view[$column]['reference']);
	} else {
		$result = $value;
	}
	return $result;
}

function display_textarea_value($column,$value) {
	return $value;
}

function display_url_value($column,$value) {
	if($this->data_view[$column]['reference']) {
		$result = $this->get_value_from_table($value,$this->data_view[$column]['reference']);
	} else {
		$result = "<a href=\"$value\">$value</a>";
	}
	return $result;
}

} // end of class DataSet
// }}}
?>