<?php
/**
 *	Project:	Quicty: Quick application build environment depends on PEAR and Smarty
 *	File:		UserAuth.class.php
 *
 *	@copyright	Tomoyuki Negishi and ZubaPitaTech, Inc.
 *	@author		Tomoyuki Negishi <tomoyu-n@zubapita.jp>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Quicty
 *	@version	$Id:$
 */

// {{{ AuthSet
/**
 *	AuthSet bind Auth set to Quicty::QT_Auth that extends PEAR::Auth
 *
 *	@author		Tomoyuki Negishi <tomoyu-n@zubapita.jp>
 *	@access		public
 *	@package	Quicty
 */
class AuthSet extends DataView {
	public $__userdata;

	function AuthSet($formName='', $method='post', $action='', $target='', $attributes=null, $trackSubmit=false) 	{
		DataView::DataView($formName, $method, $action, $target, $attributes, $trackSubmit);
		$this->data_set_config_dir = '/etc/data_set';
	}
	
	/**
	 *	Bind data source to QT_Auth(PEAR::Auth) instance.
	 *
	 *	@access	public
	 *	@param	string $data_set_file name of data_set file.
	 *	@return	array parameters for QT_AUth(PEAR::Auth).
	 */
	function bind_auth_set($data_set_file) {
		if(function_exists(apc_fetch)) {
			$auth_params = unserialize(apc_fetch('CONFIG_SET_'.$data_set_file));
		}
		if(!$auth_params) {
			$config_dir = $this->__page_obj->home_dir.$this->data_set_config_dir;
			$data_set_array = $this->read_conf_to_array($config_dir,$data_set_file);
			$data_set = $data_set_array['root'];
			foreach($data_set as $data_set_name=>$attributes) {
				if($data_set_name=='dsn') {
					$system = $attributes['system'];
					$dbname = $attributes['dbname'];
					$path = $attributes['path'];
					$host = $attributes['host'];
					$port = $attributes['port'];
					$user = $attributes['user'];
					$password = $attributes['password'];
					if(!$system) {
						die('dsn: no system type! e.g.:pgsql');
					} else {
						$dsn = $system.'://';
						if($user) {
							$dsn .= $user;
							if($password) $dsn .= ':'.$password;
							$dsn .= '@';
						}
						if($host) {
							$dsn .= $host;
							if($port) $dsn .= ':'.$port;
						}
						if($path and $dbname) {
							$dsn .= '/'.$path.'/'.$dbname;
						} elseif(!$path and $dbname) {
							$dsn .= '/'.$dbname;
						}
					}
					$auth_params['dsn'] = $dsn;
				} elseif($data_set_name=='session') {
					if(isset($attributes['lifetime'])) $auth_params['lifetime'] = $attributes['lifetime'];
					if(isset($attributes['path'])) $auth_params['path'] = $attributes['path'];
					if(isset($attributes['domain'])) $auth_params['domain'] = $attributes['domain'];
				} elseif($data_set_name=='bind') {
					foreach($attributes as $auth_field=>$t_column) {
						list($table,$column) = explode('.' , $t_column);
						$auth_params['table'] = $table;
						$auth_params[$auth_field] = $column;
					}
				}
			}
		}
		if(function_exists(apc_store)) {
			$result = apc_store('CONFIG_SET_'.$data_set_file,serialize($auth_params));
		}
		return $auth_params;
	}


} // end of class AuthSet
// }}}


// {{{ QT_Auth
/**
 *	QT_Auth extends PEAR::Auth
 *
 *	@author		Tomoyuki Negishi <tomoyu-n@zubapita.jp>
 *	@access		public
 *	@package	Quicty
 */
class QT_Auth extends Auth{
public $__userdata;
public $qs_options;
public $__page_obj;

function QT_Auth($storageDriver='DB',$options='',$loginFunction='',$showLogin=false,$page_obj) {
	$this->qs_options = $options;
	$this->__page_obj = $page_obj;

	$cookie_set = session_get_cookie_params ();
	if(isset($this->qs_options['lifetime'])) $cookie_set['lifetime'] = $this->qs_options['lifetime'];
	if(isset($this->qs_options['path'])) $cookie_set['path'] = $this->qs_options['path'];
	if(isset($this->qs_options['domain'])) {
		if(substr($this->qs_options['domain'],0,3)=='_C.') {
			$domain_value_name = substr($this->qs_options['domain'],3);
			$this->qs_options['domain'] = $this->__page_obj->C[$domain_value_name];
		}
		$cookie_set['domain'] = $this->qs_options['domain'];
	}
	session_set_cookie_params($cookie_set['lifetime'],$cookie_set['path'],$cookie_set['domain']);

	Auth::Auth($storageDriver,$options,$loginFunction,$showLogin);
}

/**
 *	get authorized user data.
 *
 *	@access	public
 *	@return	array user data from user table.
 */
public function get_user_data() {
	return $this->__userdata;
}

} // end of class QT_Auth
// }}}
?>