<?php
/**
 *	Project:	Quicty: Quick application build environment depends on PEAR and Smarty
 *	File:		Quicty.class.php
 *
 *	@copyright	Tomoyuki Negishi and ZubaPitaTech, Inc.
 *	@author		Tomoyuki Negishi <tomoyu-n@zubapita.jp>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Quicty
 *	@version	$Id:$
 */

// {{{ Quicty
/**
 *	Quicty Framework class
 *
 *	@author		Tomoyuki Negishi <tomoyu-n@zubapita.jp>
 *	@access		public
 *	@package	Quicty
 */
class Quicty extends Smarty {
	public $QuictyStatus;
	public $debug_mode = 0;
	protected $user_quicty_name = 'myQuicty';
	protected $regular_class_ext = '.class.php';
	protected $root_class_lib = 'index';
	protected $current_template;
	protected $dispatch_module;
	protected $dispatch_action;
	protected $class_name; 
	protected $module_dir;
	protected $form_result;
	protected $quicty_plugin_names;
	protected $pathlist = array(0=>array(name=>'ȥå',url=>'/'));
	
	public $form_error_message = 'Ƥ˥顼ȯޤ';
	public $form_insert_confirm_message = 'ƤϿޤ';
	public $form_insert_message = 'Ͽޤ';
	public $form_update_confirm_message = 'Ƥǹޤ';
	public $form_update_message = 'ޤ';
	public $form_delete_message = 'ޤ';
	public $external_error_message;
	public $__auth_obj;
	public $__pager_params;
	public $__mail_queue;
	public $__plugin;
	public $C;
	public $home_dir = '..';

	const SEND = 'SEND';
	const START = 'START';
	const RESTART = 'RESTART';
	const REDO = 'REDO';
	const INSERT_CONFIRM = 'INSERT_CONFIRM';
	const INSERT = 'INSERT';
	const UPDATE_CONFIRM = 'UPDATE_CONFIRM';
	const UPDATE = 'UPDATE';
	const DELETE_CONFIRM = 'DELETE_CONFIRM';
	const DELETE = 'DELETE';
	const BROWSE = 'BROWSE';
	const EDIT = 'EDIT';
	const TABLE_VIEW = 'TABLE_VIEW';


function __construct($home_dir='..',$control='submit') {
	$this->Smarty();
	$this->home_dir = $home_dir;
	$this->template_dir = $home_dir.'/view';
	$this->compile_dir = $home_dir.'/var/compiled_view';
	$this->plugins_dir[] = $home_dir.'/lib/smarty_plugins';
	$this->cache_dir = $home_dir.'/var/smarty_cache';
	$this->cache_lifetime = 3600;
	$this->caching = 0; // smarty caching is off
	$this->config_dir = $home_dir.'/etc';
	$this->module_dir = $home_dir.'/lib/Pages';
	
	if($_SERVER['DOCUMENT_ROOT']) {
		$this->root_dir = substr($_SERVER['DOCUMENT_ROOT'],0,strrpos($_SERVER['DOCUMENT_ROOT'],'/'));
	}
	
	$this->quicty_plugin_dir = $home_dir.'/lib/Plugin';

	if(is_file($home_dir.'/etc/conf/conf_values.conf') and is_subclass_of($this,$this->user_quicty_name) ) {
		require $home_dir.'/etc/conf/conf_values.conf';
		$this->assign('C',$this->C);
	}

	$this->class_name = get_class($this);
	if(!is_subclass_of($this,$this->user_quicty_name)) {
		if($_SERVER['SCRIPT_URL']) {
			$request_path = substr($_SERVER['SCRIPT_URL'],1);
		} else {
			if($p = strpos($_SERVER['REQUEST_URI'],'?')) {
				$SCRIPT_URL_BASE = substr($_SERVER['REQUEST_URI'],0,$p);
			} else {
				$SCRIPT_URL_BASE = $_SERVER['REQUEST_URI'];
			}
			$request_path = substr($SCRIPT_URL_BASE,strlen(quicty_base_url().'/'));
			$this->force_post_action = $SCRIPT_URL_BASE;
		}

		if(substr($request_path,-1)=='/') $request_path = substr($request_path,0,-1);
		if(!$request_path) { // ex) http://qs.zubapita.jp/
			if(is_file($this->module_dir.'/'.$this->root_class_lib.$this->regular_class_ext)) {
				$this->request_type = "File / use index class";
				$this->current_template = 'index.html';
				$this->dispatch_module = $this->root_class_lib;
				$this->dispatch_action = 'index';
			} else {
				$this->request_type = "Default Root";
				$this->current_template = 'index.html';
				$this->dispatch_module = $this;
				$this->dispatch_action = 'index';
			}
		} elseif(is_dir($this->template_dir.'/'.$request_path)) { // ex) http://qs.zubapita.jp/usr/
			$this->request_type = "Dir / use index.html";
			$this->current_template = $request_path.'/index.html';
			$this->dispatch_module = $request_path;
			$this->dispatch_action = 'index';
		} elseif(is_file($this->template_dir.'/'.$request_path) or 		// ex) http://qs.zubapita.jp/usr/login.html
				is_file($this->template_dir.'/'.$request_path.'.html')) { // ex) http://qs.zubapita.jp/usr/login
			if(is_file($this->template_dir.'/'.$request_path.'.html')) $request_path = $request_path.'.html';
			$this->current_template = $request_path;
			if($slash_p = strrpos($request_path,'/')) {
				$this->request_type = "File / request file under directory";
				$this->dispatch_module = substr($request_path,0,$slash_p);
				$this->dispatch_action = substr($request_path,$slash_p+1);
				$this->dispatch_action = substr($this->dispatch_action,0,strrpos($this->dispatch_action,'.'));
			} else {
				if(is_file($this->module_dir.'/'.$this->root_class_lib.$this->regular_class_ext)) { // ex) http://qs.zubapita.jp/index.html
					$this->request_type = "File / use index class";
					$this->dispatch_module = $this->root_class_lib;
				} else {
					$this->request_type = "File / use default quicksmart class";
					$this->dispatch_module = $this;
				}
				$this->dispatch_action = substr($request_path,0,strrpos($request_path,'.'));
			}
		} else {
			if($slash_p = strrpos($request_path,'/')) {  // ex) http://qs.zubapita.jp/usr/edit/?id=xx
				$this->request_type = "Virtual Module";
				$this->dispatch_module = substr($request_path,0,$slash_p);
				$this->dispatch_action = substr($request_path,$slash_p+1);
				$this->current_template = $this->dispatch_module.'/index.html';
			} else {
				$this->request_type = "Default Root because file not found"; // For Debug
				$this->current_template = 'index.html';
				$this->dispatch_module = $this;
				$this->dispatch_action = $request_path;
			}
		}
		$this->request_path=$request_path;
		$this->QuictyStatus = $this->decide_status($control);
	} // end of if($this->class_name=='Quicty')
} // end of  __construct

function __destruct() {
	// nothing to do;
}

/**
 *	Decides Quicty status of current request from current action and POST 'control'.
 *
 * Quicty status variations are:
 *
 *	'START'	:	Display input form for entry new data.
 *	'INSERT_CONFIRM'	:	Confirm contents before insert data into table.
 *	'INSERT'	:	Insert data into table.
 *	'BROWSE'	:	Display contents of row on table.
 *	'EDIT'	:	Display input form for update existing data of row on table.
 *	'UPDATE_CONFIRM'	:	Confirm contents before update row(s) on table.
 *	'UPDATE'	:	Update row(s) on table.
 *	'DELTE_CONFIRM'	: Confirm contents before delete row(s) on table.
 *	'DELETE'	:	Delete row(s) on table.
 *	'SEND'	:	simple send data.
 *
 *	@access	protected
 *	@param	string:name of 'control'
 *	@return	status:string
 */
protected function decide_status($control) {
	if(!isset($_POST[$control])) {
		switch($this->dispatch_action) {
			case 'browse':
			case 'info':
				$status = self::BROWSE;
				break;
			case 'edit':
				$status = self::EDIT;
				break;
			case 'delete':
				$status = self::DELETE_CONFIRM;
				break;
			default:
				$status = self::START;
		}
	} elseif(isset($_POST[$control]['RESTART'])) {
		$status = self::START;
	} elseif(isset($_POST[$control]['REDO'])) {
		$status = self::START;
	} elseif(isset($_POST[$control]['DELETE_CONFIRM'])) {
		$status = self::DELETE_CONFIRM;
	} elseif(isset($_POST[$control]['DELETE'])) {
		$status = self::DELETE;
	} elseif(isset($_POST[$control]['INSERT_CONFIRM'])) {
		$status = self::INSERT_CONFIRM;
	} elseif(isset($_POST[$control]['INSERT'])) {
		$status = self::INSERT;
	} elseif(isset($_POST[$control]['UPDATE_CONFIRM'])) {
		$status = self::UPDATE_CONFIRM;
	} elseif(isset($_POST[$control]['UPDATE'])) {
		$status = self::UPDATE;
	}
	$this->assign('Quicty_status',$status);
	return $status;
}

/**
 *	Create instance of current dispatch module. And dispatch action method of instance.
 *
 *	Quicty's action method name must be start 'dispatch_' and action name.
 *
 *	If current template is 'index.html', action name is 'index' and dispatcher will
 *	dispatch 'dispatch_index'.
 *
 *	dispatcher disptach action 3 times in 1 request.there are 
 *	1) 'pre_dispatch_' + action name.
 *	2) 'dispatch_' + action name.
 *	3) 'post_dispatch_' + action name.
 *
 *	In case of action name is 'hoge' (because tempate is 'hoge.html'),
 *	dispatcher try dispatch 'pre_dispatch_hoge','dispatch_hoge','post_dispatch_hoge'.
 *	But if you don't need make 'pre_dispatch_hoge' and 'post_dispatch_hoge',
 *	You don't have to make them.dispatcher will try disptach 'pre_dispatch_index' and
 *	'post_dispatch_index' of current dispatch module.
 *	If you don't make them too,disptacher dispatch method of base Quicty class(they are empty).
 *
 *	Also if you don't make 'dispatch_hoge' method,dispatcher will try dispatch 'dispatch_index'.
 * It is empty too.
 *
 *	@access	protected
 *	@param	string $prefix:prefix of dispatch action name.
 *	@param	boolean $main_action:flag of main action or pre/post action.default is true.
 *	@return	string return of dispacthed action.
 */
public function dispatcher($prefix='dispatch_',$main_action=true) {
	if(!$this->current_template) $this->dispatch_error_404();
	if($main_action)
		$this->pre_dispatch_result = $this->dispatcher('pre_dispatch_',false);
	$dispatch_action = $prefix.$this->dispatch_action;
	if(!$this->dispatch_obj) {
		if(is_file($this->module_dir.'/'.$this->dispatch_module.$this->regular_class_ext)) {
			require_once $this->module_dir.'/'.$this->dispatch_module.$this->regular_class_ext;
			if($p=strrpos($this->dispatch_module,'/')) {
				$dispatch_module = substr($this->dispatch_module,$p+1);
			} else {
				$dispatch_module = $this->dispatch_module;
			}
			if(class_exists($dispatch_module)) {
				$this->dispatch_obj = new $dispatch_module;
				$this->dispatch_obj->force_post_action =& $this->force_post_action;
				$this->dispatch_obj->request_type =& $this->request_type;
				$this->dispatch_obj->current_template =& $this->current_template;
				$this->dispatch_obj->dispatch_module =& $this->dispatch_module;
				$this->dispatch_obj->dispatch_action =& $this->dispatch_action;
				$this->dispatch_obj->request_path =& $this->request_path;
				$this->dispatch_obj->QuictyStatus =& $this->QuictyStatus;
			} else {
				die('Quicty error! : '."'".$this->module_dir.'/'.$this->dispatch_module.$this->regular_class_ext."' is loaded. But '".$dispatch_module."' class is not exists.");
			}
		} else {
			$this->dispatch_module = ' - ';
			$this->dispatch_obj = $this;
		}
		$this->Quicty['template'] = $this->current_template;
		$this->Quicty['module'] = $this->dispatch_module;
		$this->Quicty['action'] = $this->dispatch_action;
		$this->Quicty['request_path'] = $this->request_path;
		$this->Quicty['status'] = $this->QuictyStatus;
		if($this->dispatch_obj!=$this) $this->dispatch_obj->Quicty =& $this->Quicty;
		$this->dispatch_obj->assign('quicty',$this->Quicty);
	}
	if(is_callable(array($this->dispatch_obj,$dispatch_action))) {
		$result = call_user_func(array($this->dispatch_obj,$dispatch_action));
	} else {
		$result = call_user_func(array($this->dispatch_obj,$prefix.'index'));
	}
	if($main_action) {
		if($this->debug_mode==1) $this->dispatch_obj->debug_monitor();
		$this->post__dispatch_result = $this->dispatcher('post_dispatch_',false);
	}
	return $result;
} // end of dispatcher

/**
 *	pre processing default action method.
 *
 *	If you want make common pre processing logic,
 *	you have to override this method instead of class constructer.
 *
 *	@access	public
 *	@return	boolean
 */
public function pre_dispatch_index() {
	return true; // nothing to do;
}

/**
 *	default action method.
 *
 * 	Usually, you have to override this method to processing default request.
 *
 *	@access	public
 *	@return	boolean
 */
public function dispatch_index() {
	$this->assign_pathlist();
	$result = $this->display($this->current_template);
	return $result;
}

/**
 *	post processing default action method.
 *
 *	If you want make common post processing logic,
 *	you have to override this method instead of class destructer.
 *
 *	@access	public
 *	@return	boolean
 */
public function post_dispatch_index() {
	return true; // nothing to do;
}

/**
 *	404 page not found action
 *
 *	@access	public
 *	@return	boolean
 */
public function dispatch_error_404() {
	//die('Page Not Found.');
 	redirect('/errors/404.html');  
}

/**
 *	Quicty satatus accesor method.
 *
 *	@access	public
 *	@param	string $status it must be START | INSERT_CONFIRM | INSERT | BROWSE | EDIT | UPDATE_CONFIRM | UPDATE | DELETE_CONFIRM | DELETE | SEND.
 *	@return	string Quicty satatus.
 */
public function set_qt_status($status) {
	switch($status) {
		case 'START':
		case 'INSERT_CONFIRM':
		case 'INSERT':
		case 'BROWSE':
		case 'EDIT':
		case 'UPDATE_CONFIRM':
		case 'UPDATE':
		case 'DELETE_CONFIRM':
		case 'DELETE':
		case 'SEND':
			$this->QuictyStatus = $status;
			break;
		default:
			echo "Quicty warning:set_qt_status:$status is invalid\n";
	}
	return $this->QuictyStatus;
}
// old version for conpatible
public function set_qs_status($status) { 
	return $this->set_qt_status($status);
}


/**
 *	Create Quicty::DataView object.
 *	DataView object can create, validate and process HTML forms with easy settings.
 *	This method use Quicty::DataView class that override PEAR::HTML_QuickForm.
 *
 *	@access	public
 *	@param	string $formName Form's name.
 *	@param	string $method (optional)Form's method defaults to 'POST'
 *	@param	string $action (optional)Form's action
 *	@param	string $target (optional)Form's target defaults to '_self'
 *	@param	mixed $attributes (optional)Extra attributes for <form> tag
 *	@param	bool $trackSubmit (optional)Whether to track if the form was submitted by adding a special hidden field
 *	@return	object DataView class object that override PEAR::HTML_QuickForm
 */
public function new_form_obj($name='',$method='post',$action='',$target='_self',$attribute='') {
	if(!$name) {
		$name = 'form'.$this->quick_form_no;
		$this->quick_form_no++;
	}
	if(!$action and $this->force_post_action) $action = $this->force_post_action;
	$form = new DataView($name,$method,$action,$target,$attribute);
	$form->__page_obj = $this;
	return $form;
}

/**
 *	Set DataView / DataSet form msessage.
 *
 *
 *	@access	public
 *	@param	string $message string of message to display with form.
 *	@param	string $status string of Quicty status. default is 'auto'.It's mean current status.
 *	@return	void.
 */
public function set_form_message($message,$status='auto') {
	if($status=='auto')
		$status = $this->QuictyStatus;
	switch($status) {
		case 'INSERT_CONFIRM':
			$this->form_insert_confirm_message = $message;
			break;
		case 'INSERT':
			$this->form_insert_message = $message;
			break;
		case 'UPDATE_CONFIRM':
			$this->form_update_confirm_message = $message;
			break;
		case 'UPDATE':
			$this->form_update_message = $message;
			break;
		case 'DELETE':
			$this->form_delete_message = $message;
			break;
	}
}

/**
 *	Bind form values to array for display Smarty template.
 *
 *	@access	public
 *	@param	object $form DataView / DataSet form object.
 *	@return	array form values mapped array for Smarty.
 */
public function get_form_result($form) {
	$renderer = new HTML_QuickForm_Renderer_ArraySmarty($this);
	$form->accept($renderer);
	return $renderer->toArray();
}

/**
 *	get value from table or array.
 *
 *	@access	public
 *	@param	string $key key of array.
 *	@param 	array $data_set_array parameters of table or array spec.
 *	@return	string value from table or array.
 */
function get_value_from_table($key,$data_set_array) {
	if($data_set = $data_set_array['_TABLE']) {
		$field = $data_set_array['_GET_COLUMN'];
		$form = $this->new_data_set($data_set);
		if($this->reference_cache[$data_set][$key][$field]) {
			$result = $this->reference_cache[$data_set][$key][$field];
		} else {
			if(!is_numeric($key)) $key = "'$key'";
			$where = 'where '.$data_set_array['_WHERE_COLUMN'].'='.$key;
			$table = $form->select_table($where,$field);
			$result = $table[0][$field];
			$this->reference_cache[$data_set][$key][$field] = $result;
		}
	} elseif($data_set = $data_set_array['_THIS_ARRAY']) {
		$array = $this->$data_set;
		if($key_2nd = $data_set_array['_2ND_COLUMN']) {
			if($key_3rd = $data_set_array['_3RD_COLUMN']) {
				$result = $array[$key][$key_2nd][$key_3rd];
			} else {
				$result = $array[$key][$key_2nd];
			}
		} else {
			$result = $array[$key];
		}
	}
	return $result;
}

/**
 *	Assign DataView / DataSet values to Smarty template value.
 *
 *	@access	public
 *	@param	string $name name of smarty tempalte value.
 *	@param	object $form instance of DataView / DataSet form object.
 *	@return	array values of form value.
 */
public function assign_form($name,$form) {
	$renderer = new HTML_QuickForm_Renderer_ArraySmarty($this);
	$form->accept($renderer);
	$this->form_result = $renderer->toArray();
	foreach($form->data_view as $column=>$attributes) {
		if($attributes['reference']) {
			$this->form_result[$column]['html'] = 
				$this->get_value_from_table($this->form_result[$column]['value'],$attributes['reference']);
		}
	}
	if(count($this->form_result['errors'])) {
		$this->form_result['information'] = $this->form_error_message;
	} elseif($this->external_error_message) {
		$this->form_result['information'] = $this->external_error_message;
	} else {
		switch($this->QuictyStatus) {
			case 'INSERT_CONFIRM':
				$this->form_result['information'] = $this->form_insert_confirm_message;
				break;
			case 'INSERT':
				$this->form_result['information'] = $this->form_insert_message;
				break;
			case 'UPDATE_CONFIRM':
				$this->form_result['information'] = $this->form_update_confirm_message;
				break;
			case 'UPDATE':
				$this->form_result['information'] = $this->form_update_message;
				break;
			case 'DELETE':
				$this->form_result['information'] = $this->form_delete_message;
				break;
		}
	}
	$this->form_result['qt_status'] = $this->form_result['qs_status'] = $this->QuictyStatus;
	$this->assign($name,$this->form_result);
	return $this->form_result;
}

/**
 *	Set DataView / DataSet form's error message.
 *
 *	@access	public
 *	@param	string $message message to display with form.
 *	@return	void.
 */
public function set_form_error($message) {
	$this->external_error_message = $message;
}

/**
 *	Create Quicty::DataSet object.
 *	DataSet object can create, validate and process HTML forms with easy settings.
 *	And bind SQL Database controller methods.
 *
 *	This method use Quicty::DataSet class that override Quicty::DataView.
 *	And Quicty::DataView class override PEAR::HTML_QuickForm.
 *
 *	@access	public
 *	@param	string $formName Form's name.
 *	@param	string $method (optional)Form's method defaults to 'POST'
 *	@param	string $action (optional)Form's action
 *	@param	string $target (optional)Form's target defaults to '_self'
 *	@param	mixed $attributes (optional)Extra attributes for <form> tag
 *	@param	bool $trackSubmit (optional)Whether to track if the form was submitted by adding a special hidden field
 *	@return	object DataView class object that override PEAR::HTML_QuickForm
 */
public function new_data_obj($name='',$method='post',$action='',$target='_self',$attribute='') {
	if(!$name) {
		$name = 'form'.$this->quick_form_no;
		$this->quick_form_no++;
	 }
	 if(!$action and $this->force_post_action) $action = $this->force_post_action;
	$form = new DataSet($name,$method,$action,$target,$attribute);
	$form->__page_obj = $this;
	$form->memcached = $this->memcached;
	$form->memcache_compress = $this->memcache_compress;
	$form->memcache_expire = $this->memcache_expire;
	return $form;
}

/**
 *	Get row data from table.
 *
 *	@access	public
 *	@param	string $data_set_name name of data_view and data_set file.
 *	@param	string $condition sql condition phrase. such as 'where column=hoge' or 'order by id',etc.
 *	@return	array contents of row data.
 */
public function get_row_from_table($data_set_name,$condition) {
	if($data_set_name and $condition) {
		$form = $this->new_data_set($data_set_name);
		$result = $form->select_table($condition);
		if(count($result)>0) $row = $result;
	}
	return $row;
}


/**
 *	Quick build DataSet object and bind data_view and data_set
 *
 *	@access	public
 *	@param	string $set_name DataSet form's name and data_view file's name and data_set file's name.
 *	@return	object DataSet object.
 */
public function new_data_set($set_name,$cache=false) {

	if($cache and $this->memcached) {
		$DATA_SET_CACHE = $this->memcache->get('DATA_SET_'.$set_name);
	} elseif($cache and function_exists(apc_fetch)) {
		$DATA_SET_CACHE = unserialize(apc_fetch('DATA_SET_'.$set_name));
	}
	if(is_object($DATA_SET_CACHE)) {
		$data_set = $DATA_SET_CACHE;
		$this->memcache_use .= $set_name." : get from cache.\n";
	} else {
		$data_set = $this->new_data_obj($set_name);
		$data_set->bind_data_view($set_name.'.view.conf');
		$data_set->bind_data_set($set_name.'.set.conf');	
		$this->memcache_use .= $set_name." : generated.\n";
		if($cache and $this->memcached) {
			$result = $this->memcache->set('DATA_SET_'.$set_name,$data_set,
					$this->memcache_compress,$this->memcache_expire);
		} elseif($cache and function_exists(apc_store)) {
			$result = apc_store('DATA_SET_'.$set_name,serialize($data_set));
		}
	}

	return $data_set;
}

/**
 *	Create Quicty::QT_Auth object.
 *	AuthSet object can provides authentication system with easy settings.
 *
 *	This method use Quicty::QT_Auth class that override PEAR::Auth.
 *
 *	Also this method use Quicty::AuthSet class that override Quicty::DataView.
 *	And Quicty::DataView class override PEAR::HTML_QuickForm.
 *
 *	@access	public
 *	@param	string $data_set_file name of data_set file for auth.
 *	@param	string $strage_driver Type of the storage driver. Default is 'DB'.
 *	@return	object QT_Auth object.
 */
public function new_auth_obj($data_set_file,$strage_driver='DB') {
	$form = new AuthSet('auth');
	$form->__page_obj = $this;
	$auth_params = $form->bind_auth_set($data_set_file);
	$this->__auth_obj = new QT_Auth($strage_driver,$auth_params,NULL,false,$this);
	$this->__auth_obj->start();
	if($this->__auth_obj->getAuth()) {
		$userdata = $this->__auth_obj->getAuthData();
		$userdata['authorized'] = true;
	} else {
		$userdata['authorized'] = false;
	}
	$this->__auth_obj->__userdata = $userdata;
	return $this->__auth_obj;
}

/**
 *	Get QT_Auth object of cureent request.
 *
 *	@access	public
 *	@return	object current QT_Auth object.
 */
public function get_auth_obj() {
	return $this->__auth_obj;
}

/**
 *	Create new PEAR::Pager object.
 *
 *	@access	public
 *	@param	array PEAR::Pager parameters.
 *	@return	object PEAR::Pager object.
 */
public function new_pager_obj(array $params=array()) {
	if(!isset($params['totalItems'])) {
		die ("Quicty error!: function new_pager_obj() must need 'totalItems' parameter. ex) new_pager_obj(array('totalItems'=>10))");
	}
	foreach($params as $key=>$value) {
		$this->__pager_params[$key] = $value;
	}
	$this->__pager_params['perPage'] = isset($params['perPage']) ? $params['perPage'] : 20;
	$pager = Pager::factory($this->__pager_params);
	return $pager;
}

/**
 *	Create new PEAR::Mail_Queue object.
 *
 *	@access	public
 *	@param	string $data_set_file name of data_set file name for Mail_Queue.
 *	@param	string $table name of table for Mail_Queue.
 *	@param	array PEAR::Mail_Queue parameters.
 *	@return	object PEAR::Mail_Queue object.
 */
public function new_mail_queue($data_set_file,$table='mail_queue',$mail_option=array("driver"=>"mail")) {
	$form = new QueueSet('queue');
	$form->__page_obj = $this;
	$mail_queue_params = $form->bind_queue_set($data_set_file);
	$db_option=array(
		'type'=>'db',
		'dsn'=>$mail_queue_params['dsn'],
		'mail_table'=>$table
	);
	$this->__mail_queue = new QS_Mail_Queue($db_option,$mail_option);
	return $this->__mail_queue;

}

/**
 *	Create new PEAR::Mail_Mime object.
 *
 *	@access	public
 *	@param	string $from email address of sender.
 *	@param	string $to email address of receiver.
 *	@param	string $subject subject of mail.
  *	@param	string $article message body of mail.
 *	@return	object PEAR::Mail_Mime object.
 */
public function new_mail_obj($from,$to,$subject,$article) {
	$MIME_obj = new QS_Mail_mime();
	$MIME_obj ->set_data($from,$to,$subject,$article);
	return $MIME_obj;
}

/**
 *	Set directory path list (a.k.a 'bread crumbs') for Quicty::default template.
 *	pathlist parameter array must be have 'name' key and 'url' key. Such as
 *		$pathlist = array(
 *			array('name'=>'top','url'=>'/'),
 *			array('name'=>'item list','url'=>'/items/index'),
 *			array('name'=>'item detail of no.1','url'=>'/items/info?id=1')
 *			);
 *
 *	@access	public
 *	@param	array $pathlist array of each pages.
 *	@return	bolean if you give correct pathlist,return true.
 */
public function set_pathlist($pathlist=array()) {
	if(is_array($pathlist) and count($pathlist)>0) {
		$this->pathlist = $pathlist;
		return true;
	} else {
		return false;
	}
}

/**
 *	Add page to end of directory path list for Quicty::default template.
 *
 *	@access	public
 *	@param	string $url url or path of page.
 *	@param	string $name name of page.
 *	@param	boolean $assign assign new path list to template value 'pathlist'. Default is true.
 *	@return	boolean if you success to set path list,return true.
 */
public function add_pathlist($url,$name,$assign=true) {
	if($name) {
		$this->pathlist = array_merge(
			$this->pathlist,array(array('name'=>$name,'url'=>$url)
			));
		if($assign) {
			return $this->assign('pathlist',$this->pathlist);
		} else {
			return true;
		}
	} else {
		return false;
	}
}

/**
 *	Clear current path list.
 *
 *	@access	public
 *	@return	boolean always return true.
 */
public function clear_pathlist() {
	$this->pathlist = array();
	return true;
}

/**
 *	Set path list and assign path list to template value 'pathlist'.
 *
 *	@access	public
 *	@param	array $pathlist array of each pages.
 *	@return	bolean if you give correct pathlist,return true.
 */
public function assign_pathlist($pathlist=array()) {
	if(is_array($pathlist) and count($pathlist)>0) {
		$this->pathlist = $pathlist;
	}
	return $this->assign('pathlist',$this->pathlist);
}

/**
 *	Get all Quicty plugin name list in plugin directory.
 *	Default plugin directory is 'lib/Plugin'.
 *
 *	@access	public
 *	@param	string $sub_dir sub directory name in plugin directry.
 *	@return	array plugin name list.
 */
public function get_plugin_names($sub_dir='') {
	foreach(glob($this->quicty_plugin_dir.$sub_dir.'/*.php') as $file_path) {
		$file_name = substr($file_path,strrpos($file_path,'/')+1);
		$plugin_names[] = substr($file_name,0,strpos($file_name,'.'));
	}
	return $plugin_names;
}

/**
 *	Checks whether a Quicty plugin exists
 *
 *	@access	public
 *	@param	string $plugin_name base name of plugin file.
 *	@return	boolean return true if plugin exists.
 */
public function is_exist_plugin_file($plugin_name) {
	if(is_file($this->quicty_plugin_dir.'/'.$plugin_name.$this->regular_class_ext)) {
		return TRUE;
	} else {
		return FALSE;
	}
}

/**
 *	Create new Quicty plugin instance.
 *
 *	You must be set unique plugin id for each plugin class.
 *
 *	@access	public
 *	@param	string $file_path kind and name of plugin. such as 'sidebar/calendar'.
 *	@param	array parameters of plugin.
 *	@return	object plugin instance object.
 */
public function new_plugin($file_path,$params=array()) {
	require_once $this->quicty_plugin_dir.'/'.$file_path.$this->regular_class_ext;
	$file = pathinfo($file_path);
	$class_name = $file['basename'];
	$plugin = new $class_name($this,$params);
	return $plugin;
}

/**
 *	Create all plugin instances in specific sub directory.
 *	And return array of plugin instances list.
 *	You must be set unique plugin id for each plugin class.
 *
 *	@access	public
 *	@param	string $sub_dir sub directory of Quicty plugin directoty.
 *	@return	array plugin instances array.
 */
public function include_plugin($sub_dir='') {
	foreach(glob($this->quicty_plugin_dir.$sub_dir.'/*.php') as $file_path) {
		require_once $file_path;
		$file_name = substr($file_path,strrpos($file_path,'/')+1);
		$plugin_name = substr($file_name,0,strpos($file_name,'.'));
		if($sub_dir) {
			$plugin_class = substr($sub_dir,1).'_'.$plugin_name;
		} else {
			$plugin_class = $plugin_name;
		}
		if(!$this->__plugin[$plugin_class])
			$this->__plugin[$plugin_class] = new $plugin_class($this,$plugin_params);
		$plugin_id = $this->__plugin[$plugin_class]->get_id();
		$plugins[$plugin_id] = $plugin_name;
	}
	return $plugins;
}



public function __toString() {
	return $this->class_name;
}

public function __autoload($class_name) {
	require_once $this->module_dir.'/'.$class_name.$this->regular_class_ext;
}



/**
 *	debug monitor.
 *	display current status and values.
 *
 *	@access	public
 *	@return	void.
 */
public function debug_monitor() {
	$quicty_base_url = quicty_base_url();
	echo "\n".<<<END_OF_MONITOR
	<html><head>
	<meta http-equiv="Content-Style-Type" content="text/css">
	<link href="/css/main.css" rel="stylesheet" type="text/css">
	</head><body>
	<table id="container"><tr><td>
	<hr>
	<strong>[ debug monitor ]</strong><br>
	<br>
	<pre>
END_OF_MONITOR;
	echo "dispatch_module=";echo $this->dispatch_module; echo "\n";
	echo "dispatch_obj=";echo $this->dispatch_obj; echo "\n";
	echo <<<END_OF_MONITOR
	root_dir = $this->root_dir
	request_path = $this->request_path
	request_type = $this->request_type
	dispatch_action=$this->dispatch_action
	current_template=$this->current_template
	quicty_base_url=$quicty_base_url
	QuictyStatus=$this->QuictyStatus
END_OF_MONITOR;
	echo "\n";
	echo "_GET=";print_r($_GET);echo "\n";
	echo "_POST=";print_r($_POST);echo "\n";
	echo "_COOKIE=";print_r($_COOKIE);echo "\n";
	echo "_SESSION=";print_r($_SESSION);echo "\n";
	echo "session_prams=";print_r(session_get_cookie_params ());echo "\n";
	echo "SID=".SID."\n";
	echo "_SERVER=";print_r($_SERVER);echo "\n";
	echo "memcache_use=".$this->memcache_use."\n";
	echo "use_cache=".$this->use_memcache."\n";
	//echo "this->memcached=";var_dump($this->memcached);echo "\n";
	/*
	if($this->memcached) {
		$DATA_SET_CACHE = $this->memcache->get('DATA_SET');
		echo "DATA_SET_CACHE=";print_r($DATA_SET_CACHE);
	} elseif(function_exists(apc_fetch)) {
		//$DATA_SET_CACHE = apc_fetch('DATA_SET');
		echo "DATA_SET_CACHE=";print_r(apc_cache_info());
	}
	*/
	echo <<<END_OF_MONITOR
	</pre>
	<hr>
	</td></tr></table>
	</body></html>
END_OF_MONITOR;
}

} 
// end of class Quicty
// }}}
?>