#ifndef PARTS_PLACE_SCENE_H
#define PARTS_PLACE_SCENE_H

/*!
  \file
  \brief 配置部品の閲覧用

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QGraphicsScene>


/*!
  \brief 部品配置の閲覧シーンクラス
*/
class PartsPlaceScene : public QGraphicsScene {
  Q_OBJECT;

  PartsPlaceScene(const PartsPlaceScene& rhs);
  PartsPlaceScene& operator = (const PartsPlaceScene& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

protected:
  /*!
	\brief イベント制御

	\param mouseEvent [i/o] イベント
  */
  void mousePressEvent(QGraphicsSceneMouseEvent *mouseEvent);

public:
  /*!
	\brief コンストラクタ

	\param parent [i] 親ウィジット
  */
  PartsPlaceScene(QObject* parent = 0);
  ~PartsPlaceScene(void);

signals:
  /*!
    \brief クリック位置の送信シグナル

    \param x [i] ウィジット内クリック X 値
    \param y [i] ウィジット内クリック Y 値
  */
  void clicked(int x, int y);
};

#endif /* !PARTS_PLACE_SCENE_H */
