#ifndef STRING_SPLIT_H
#define STRING_SPLIT_H

/*!
  \file
  \brief string 用の split 関数

  \author Satofumi KAMIMURA

  $Id$
*/

#include <vector>
#include <string>


namespace qrk {

  /*!
    \brief 指定文字による分割

    \param tokens [o] 分割後の文字列
    \param original [i] 分割対象の文字列
    \param split_pattern [i] 分割を行う文字の列

    \return 分割後のトークン数
  */
  size_t split(std::vector<std::string>& tokens,
               const std::string& original,
               const char* split_pattern = " \t");
};

#endif /* !STRING_SPLIT_H */
