#ifndef CLOCK_PARTS_DRAW_H
#define CLOCK_PARTS_DRAW_H

/*!
  \file
  \brief テーマ時計の部品描画

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QVector>

class QPainter;
class QPoint;
class QRegion;
class ThemeResource;


namespace ClockPartsDraw {

  enum {
    InvalidCellIndex = -1,      //!< 無効なセル番号
    NoAnimationCell = -2,       //!< セルを描画しない場合
  };

  /*!
    \brief テーマ時計の再描画を行う

    \param region [o] 描画 Pixel マスク領域の和
    \param resource [i] 描画リソース
    \param digital_positions [i] デジタル部品の描画位置
    \param calendar_positions [i] カレンダー部品の表示位置
    \param scaling_percent [i] 拡大率 [%]
    \param sec_offset [i] 描画時の秒オフセット [sec]
  */
  extern void updatePixmaps(QRegion& region,
                            const ThemeResource& resource,
                            const QVector<QPoint>& digital_positions,
                            const QVector<QPoint>& calendar_positions,
                            size_t scaling_percent = 100, int sec_offset = 0,
                            int cell_index = InvalidCellIndex);

  /*!
    \brief Pixel 画像の描画

    \param painter [i] 描画対象
  */
  extern void drawPixmaps(QPainter& painter, bool force_draw = false);
};

#endif /* !CLOCK_PARTS_DRAW_H */
