#ifndef THEME_CONFIG_WINDOW_H
#define THEME_CONFIG_WINDOW_H

/*!
  \file
  \brief テーマファイル作成用のメインウィンドウ管理

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ui_ThemeConfigWindowForm.h"


/*!
  \brief テーマ時計のメインウィンドウ管理
*/
class ThemeConfigWindow : public QMainWindow, private Ui::ThemeConfigWindow {
  Q_OBJECT;

  ThemeConfigWindow(const ThemeConfigWindow& rhs);
  ThemeConfigWindow& operator = (const ThemeConfigWindow& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

  void closeEvent(QCloseEvent* event);

private slots:
  void newFile(void);
  void openFile(void);
  void saveFile(void);
  void saveFileAs(void);
  void releaseData(void);
  void previewClock(void);
  void aboutApplication(void);
  void imageUploadHandler(void);

  void previewRedraw(void);

  void centerCheckHandler(bool checked);
  void showColonCheckHandler(bool checked);
  void blinkCheckHandler(bool checked);
  void analogCheckHandler(bool checked);
  void digitalCheckHandler(bool checked);
  void monthCheckHandler(bool checked);
  void ampmCheckHandler(bool checked);
  void digitalAboveCheckHandler(bool checked);

  void leftPressed(void);
  void rightPressed(void);
  void upPressed(void);
  void downPressed(void);

  void partsEditHandler(void);
  void updateHandlelr(void);

  void releaseHandler(const QString& file, const QString& key);

  void previewCloseHandler(void);
  void offsetUpdated(int value);

  void partsClickedHandler(int x, int y);
  void updateAnimationItems(QTreeWidgetItem* item, int column);

  void probabilityChangedHandler(int index, double probability);
  void cycleChangedHandler(int index, int cycle_msec);
  void patternChangedHandler(int index, const std::string& pattern);

public:

  /*!
    \brief コンストラクタ

    \param config_file [i] テーマ設定ファイル
  */
  explicit ThemeConfigWindow(const QString& config_file = "");
  ~ThemeConfigWindow(void);
};

#endif /* !THEME_CONFIG_WINDOW_H */
