/*!
  \file
  \brief データファイルのリリース処理

  \author Satofumi KAMIMURA

  $Id$
*/

#include <string>
#include "ReleaseDataFile.h"
#include "ArchiveConfig.h"
#include "RrdaDecoder.h"


bool releaseDataFile(const ArchiveConfig& archive_config, size_t cell_max) {

  RrdaDecoder decoder(archive_config.getReleaseName(),
                      archive_config.getRrdaKey());

  const char* tags[] = {
    "config", "base", "digital", "hari_h", "hari_m", "hari_s",
    "days", "separator", "week", "near",
  };

  size_t n = sizeof(tags) / sizeof(tags[0]);

  for (size_t i = 0; i < n; ++i) {

    // 通常データ
    const std::string normal_value = archive_config.getNormalData(tags[i]);
    if (! normal_value.empty()) {
      decoder.setNormalData(tags[i], normal_value);
    }

    // 制限データ
    const std::string restrict_value = archive_config.getRestrictData(tags[i]);
    if (! restrict_value.empty()) {
      decoder.setRestrictData(tags[i], restrict_value);
    }
  }

  // アニメーション用の画像データ
  for (size_t i = 0; i < cell_max; ++i) {

    char tag_name[] = "cell_000";
    snprintf(tag_name, strlen(tag_name) + 1, "cell_%03d", i);

    const std::string value = archive_config.getNormalData(tag_name);
    if (! value.empty()) {
      decoder.setNormalData(tag_name, value);
    }

  }

  return decoder.release();
}

