#ifndef PATTERN_REGISTER_WIDGET_H
#define PATTERN_REGISTER_WIDGET_H

/*!
  \file
  \brief パターンの登録ウィジット

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QWidget>
#include "ui_PatternRegisterWidgetForm.h"


/*!
  \brief アニメーションパターンの登録ウィジット
*/
class PatternRegisterWidget
  : public QWidget, private Ui::PatternRegisterWidgetForm {
  Q_OBJECT;

  PatternRegisterWidget(const PatternRegisterWidget& rhs);
  PatternRegisterWidget& operator = (const PatternRegisterWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

public:
  /*!
	\brief コンストラクタ

	\param parent [i] 親ウィジット
  */
  PatternRegisterWidget(QWidget* parent = 0);
  ~PatternRegisterWidget(void);

  /*!
	\brief パターン名の登録

	\param name [i] パターン名
  */
  void setName(const std::string& name);

  /*!
	\brief 発生確率の登録

	\param probability [i] 発生確率 / 秒
  */
  void setProbability(double probability);

  /*!
	\brief 描画周期の登録

	\param msec [i] ミリ秒
  */
  void setCycle(size_t msec);

  /*!
	\brief パターンの登録

	\param pattern [i] 再生パターン
   */
  void setPattern(const std::string& pattern);
};

#endif /* !PATTERN_REGISTER_WIDGET_H */
