/*!
  \file
  \brief テーマ時計のリソース

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QPoint>
#include <QVector>
#include <QPixmap>
#include "ThemeResource.h"


namespace {

  // デジタル文字の描画位置を設定
  void positionUpdate(QVector<QPoint>& positions,
                      int index,
                      const QMap<std::string, std::string>& tags,
                      const std::string& x_tag,
                      const std::string& y_tag) {

    int x = atoi(tags.value(x_tag, "0").c_str());
    int y = atoi(tags.value(y_tag, "0").c_str());
    positions[index] = QPoint(x, y);
  }
};


// デジタル画像の描画位置を読み出し
void loadDigitalPosition(QVector<QPoint>& digital_positions,
                         const QMap<std::string, std::string>& tags) {

  // "hh:mm ss x";
  digital_positions.clear();
  digital_positions.resize(10);

  positionUpdate(digital_positions,
                 0, tags, "digital/h1_xpos", "digital/h1_ypos");
  positionUpdate(digital_positions,
                 1, tags, "digital/h2_xpos", "digital/h2_ypos");

  positionUpdate(digital_positions,
                 2, tags, "digital/cl_xpos", "digital/cl_ypos");

  positionUpdate(digital_positions,
                 3, tags, "digital/m1_xpos", "digital/m1_ypos");
  positionUpdate(digital_positions,
                 4, tags, "digital/m2_xpos", "digital/m2_ypos");

  positionUpdate(digital_positions,
                 6, tags, "digital/s1_xpos", "digital/s1_ypos");
  positionUpdate(digital_positions,
                 7, tags, "digital/s2_xpos", "digital/s2_ypos");

  positionUpdate(digital_positions,
                 9, tags, "digital/ap_xpos", "digital/ap_ypos");
}


// デジタル画像の描画位置を読み出し
void loadDigitalPosition(QVector<QPoint>& digital_positions,
                         QMap<std::string, QPoint>& parts_positions) {

  digital_positions.resize(10);

  digital_positions[0] = parts_positions["digital/h1"];
  digital_positions[1] = parts_positions["digital/h2"];
  digital_positions[2] = parts_positions["digital/cl"];
  digital_positions[3] = parts_positions["digital/m1"];
  digital_positions[4] = parts_positions["digital/m2"];
  digital_positions[6] = parts_positions["digital/s1"];
  digital_positions[7] = parts_positions["digital/s2"];
  digital_positions[9] = parts_positions["digital/ap"];
}


// カレンダー画像の描画位置を読み出し
void loadCalendarPosition(QVector<QPoint>& calendar_positions,
                          const QMap<std::string, std::string>& tags) {

  // "mmdd //w";
  calendar_positions.clear();
  calendar_positions.resize(7);

  positionUpdate(calendar_positions,
                 0, tags, "calendar/m1_xpos", "calendar/m1_ypos");
  positionUpdate(calendar_positions,
                 1, tags, "calendar/m2_xpos", "calendar/m2_ypos");

  positionUpdate(calendar_positions,
                 2, tags, "calendar/d1_xpos", "calendar/d1_ypos");
  positionUpdate(calendar_positions,
                 3, tags, "calendar/d2_xpos", "calendar/d2_ypos");

  positionUpdate(calendar_positions,
                 4, tags, "calendar/s1_xpos", "calendar/s1_ypos");
  positionUpdate(calendar_positions,
                 5, tags, "calendar/s2_xpos", "calendar/s2_ypos");

  positionUpdate(calendar_positions,
                 6, tags, "calendar/we_xpos", "calendar/we_ypos");
}


// カレンダー画像の描画位置を読み出し
void loadCalendarPosition(QVector<QPoint>& calendar_positions,
                         QMap<std::string, QPoint>& parts_positions) {

  calendar_positions.resize(7);

  calendar_positions[0] = parts_positions["calendar/m1"];
  calendar_positions[1] = parts_positions["calendar/m2"];
  calendar_positions[2] = parts_positions["calendar/d1"];
  calendar_positions[3] = parts_positions["calendar/d2"];
  calendar_positions[4] = parts_positions["calendar/s1"];
  calendar_positions[5] = parts_positions["calendar/s2"];
  calendar_positions[6] = parts_positions["calendar/we"];
}
