/*!
  \file
  \brief パターンの登録ウィジット

  \author Satofumi KAMIMURA

  $Id$
*/

#include "PatternRegisterWidget.h"


struct PatternRegisterWidget::pImpl {

  // !!!
};


PatternRegisterWidget::PatternRegisterWidget(QWidget* parent)
  : QWidget(parent), pimpl(new pImpl) {
  setupUi(this);

  // !!!
}


PatternRegisterWidget::~PatternRegisterWidget(void) {
}


void PatternRegisterWidget::setName(const std::string& name) {

  groupbox_->setTitle(name.c_str());
}


void PatternRegisterWidget::setProbability(double probability) {

  probability_spinbox_->setValue(probability);
}


void PatternRegisterWidget::setCycle(size_t msec) {

  cycle_spinbox_->setValue(msec);
}


void PatternRegisterWidget::setPattern(const std::string& pattern) {

  pattern_edit_->setText(pattern.c_str());
}
