/*!
  \file
  \brief 部品生成ツールのウィンドウ管理

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QCloseEvent>
#include <QMessageBox>
#include <QFontDatabase>
#include "PartsGeneratorWindow.h"
#include "PartsDrawWidget.h"


struct PartsGeneratorWindow::pImpl {

  QAction* new_act_;
  QAction* open_act_;
  QAction* save_act_;
  PartsDrawWidget* parts_draw_;

  void initializeForm(PartsGeneratorWindow* parent) {

    // アイコンの適用
    parent->setWindowIcon(QIcon(":icons/parts_generator_icon"));

    // フォントツリーの作成
    initializeFontTree(parent);

    // 画像描画ウィジットの配置
    parts_draw_ = new PartsDrawWidget(parent->centralwidget);
    parent->scrollarea_->setWidget(parts_draw_);

    // フォントの選択変更イベント
    // !!! isChanged() で、表示中のフォントが変更されるようにする
    // !!! この処理は、Undo したいかも

    // メニューイベント
    connect(parent->action_quit_, SIGNAL(triggered()), parent, SLOT(close()));

    // 画像ボタンのイベントで設定の表示を変更し、
    // 設定の変更で、描画ウィジットの画像を更新する
    // !!! って感じのイベントを設定
  }


  // フォントツリーの作成
  void initializeFontTree(PartsGeneratorWindow* parent) {

    QFontDatabase database;
    foreach (QString family, database.families()) {
      const QStringList styles = database.styles(family);
      if (styles.isEmpty()) {
        continue;
      }

      QTreeWidgetItem* family_item = new QTreeWidgetItem(parent->font_tree_);
      family_item->setText(0, family);

      foreach (QString style, styles) {
        QTreeWidgetItem* style_item = new QTreeWidgetItem(family_item);
        style_item->setText(0, style);
        style_item->setData(0, Qt::UserRole,
                            QVariant(database.weight(family, style)));
        style_item->setData(0, Qt::UserRole + 1,
                            QVariant(database.italic(family, style)));
      }
    }
  }
};


PartsGeneratorWindow::PartsGeneratorWindow(void)
  : QMainWindow(), pimpl(new pImpl) {
  setupUi(this);

  // 以下の初期化は、pImpl 内で行うと tr() が使えないため、ここで行っている

  // ツールバーの初期化
  pimpl->new_act_ = new QAction(QIcon(":icons/new_icon"), tr("New"), this);
  pimpl->new_act_->setStatusTip(tr("Create a new config file."));
  connect(pimpl->new_act_, SIGNAL(triggered()), this, SLOT(newFile()));

  pimpl->open_act_ = new QAction(QIcon(":icons/open_icon"), tr("Open"), this);
  pimpl->open_act_->setStatusTip(tr("Open an exist config file."));
  connect(pimpl->open_act_, SIGNAL(triggered()), this, SLOT(openFile()));

  pimpl->save_act_ = new QAction(QIcon(":icons/save_icon"), tr("Save"), this);
  pimpl->save_act_->setStatusTip(tr("Save the config file to disk."));
  connect(pimpl->save_act_, SIGNAL(triggered()), this, SLOT(saveFile()));

  toolbar_->addAction(pimpl->new_act_);
  toolbar_->addAction(pimpl->open_act_);
  toolbar_->addAction(pimpl->save_act_);

  // フォントツリーのタイトル設定
  font_tree_->setColumnCount(1);
  font_tree_->setHeaderLabels(QStringList() << tr("Font"));

  // フォームの初期化
  pimpl->initializeForm(this);

  // メニューの初期化
  connect(action_about_, SIGNAL(triggered()), this, SLOT(aboutApplication()));
}


PartsGeneratorWindow::~PartsGeneratorWindow(void) {
}


// 終了
void PartsGeneratorWindow::closeEvent(QCloseEvent* event) {

  event->accept();
}


// このアプリケーションについて
void PartsGeneratorWindow::aboutApplication(void) {

  QMessageBox::about(this, tr("About parts_generator"),
                     tr("<h2>Parts generator</h2>"
                        "<p>Theme making sub tool for Qtmclock.</p>"
                        "<p>Report bugs to "
                        "&lt;satofumi@users.sourceforge.jp&gt;</p>"));
}
