package org.qrone.one.inner;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;

import org.qrone.one.QrONEServer;
import org.qrone.one.QrONESession;
import org.qrone.one.QrONEUser;
import org.qrone.one.event.QrONEUserListener;
import org.w3c.dom.Document;

public class DefaultSession implements QrONESession{
	private String id;
	private long createtime;
	private long lasttime;
	private int maxintervaltime;
	private int connectcount;
	private Hashtable attributeMap = new Hashtable();
	
	private QrONEServer server;
	private LinkedList userlist = new LinkedList();
	public DefaultSession(String id, QrONEServer server){
		this.id = id;
		this.server = server;
		createtime = System.currentTimeMillis();
		lasttime = createtime;
		maxintervaltime = 0;
	}
	
	public void joinUser(final QrONEUser user){
		if(userlist.isEmpty()){
			long nowtime = System.currentTimeMillis();
			int lastinterval = (int)((nowtime - lasttime) / 1000);
			if(maxintervaltime < lastinterval){
				maxintervaltime = lastinterval;
			}
		}
		
		if(!userlist.contains(user)){
			userlist.add(user);
			user.addQrONEUserListener(new QrONEUserListener(){
				public void onConnect(boolean success) {}
				public void onClose() {
					userlist.remove(user);
					if(userlist.isEmpty()){
						lasttime = System.currentTimeMillis();
					}
				}
				public void onXML(Document xmldoc) {}
				public void onData(String xmlstr) {}
				public void onUpdate(String sessionkey) {}
			});
		}
	}
	
	public long getCreationTime(){
		return createtime;
	}
	
	public String getId(){
		return id;
	}
	
	public long getLastAccessedTime(){
		return lasttime;
	}
	
	public int getMaxInactiveInterval() {
		return maxintervaltime;
	}

	public void setMaxInactiveInterval(int interval) {
		maxintervaltime = interval;
	}


	public Object getAttribute(String name){
		return attributeMap.get(name);
	}
	
	public Enumeration getAttributeNames(){
		return attributeMap.keys();
	}
	
	public void removeAttribute(String name){
		attributeMap.remove(name);
	}
	
	public void setAttribute(String name, Object value){
		attributeMap.put(name,value);
	}

	public void invalidate() {
		server.removeSession(this);
	}
}
