package org.qrone.one;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Iterator;
import java.util.LinkedList;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;

import org.qrone.IDTools;
import org.qrone.XMLTools;
import org.qrone.one.event.QrONEUserListener;
import org.qrone.one.inner.ServiceException;
import org.qrone.xmlsocket.XMLSocketNIO;
import org.qrone.xmlsocket.event.XMLSocketListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/**
 * T[o[ƒʐMs[U[[\NXłB<BR>
 * <BR>
 * K̂obAlɈł͂ȂA XMLSocket ʐMɑ΂ẴCX^X
 * ƍlĂB̈ו̃T[rX𓯎ɎgĂ郆[U[͕ QrONEUser 
 * CX^X܂B<BR>
 * <BR>
 * ׁ̈A̒ʐMPʂŊ蓖Ă ID  UniqueIDB[U[ʂ邽߂ɁA
 * ob̃ZbVƂɊ蓖Ă ID @SessionID łB UniqueID ͕ʂ QrONEUser
 * CX^XɌŗL ID łASessionID ͕̃T[rXlɎgĂꍇɂ
 * ̒̕ʐMœ SessionID 蓖Ă܂B<BR>
 * <BR>
 * ׁ̈AʐM\PbgPʂ̎ʂɂ<code>getUniqueID()</code> AlPʂ̎ʂɂ
 * <code>getSessionID()</code> AČlPʂł̃f[^̕ۊǂɂ Servlet Ɠl
 * <code>getSession()</code>@p܂B
 * 
 * @author J.Tabuchi
 * @since 2005/8/6
 * @version 1.0
 * @link QrONE Technology : http://www.qrone.org/
 */
public class QrONEUser{
	private static final int USER_CLOSED		= 0;
	private static final int USER_CONNECTED	= 1;
	private static final int USER_INITED		= 2;
	private static final int USER_REGISTERED = 3;
	
	private static TransformerFactory tfactory = TransformerFactory.newInstance();
	private Transformer transformer;

	private QrONEServer server;
	private int status = USER_CLOSED;
	
	private String uniqueId;
	private String sessionId;
	private String preferedServiceURI;
	private String userCharset;

	private LinkedList userlistener = new LinkedList();
	
	private XMLSocketNIO xmlsocket;
	private QrONEService service;
	private String browser = "ie";
	
	public QrONEUser(QrONEServer server, final XMLSocketNIO xmlsocket){
		this.server = server;
		uniqueId  = IDTools.generateID();
		sessionId = IDTools.generateID();
		
		this.xmlsocket = xmlsocket;
		
		xmlsocket.addXMLSocketListener(new XMLSocketListener(){
			public void onConnect(boolean success) {
				if(success){
					status = USER_CONNECTED;
				}else{
					status = USER_CLOSED;
					QrONEUser.this.onConnect(false);
				}
			}

			public void onClose() {
				status = USER_CLOSED;
				QrONEUser.this.onClose();
			}

			public void onError(Exception e) {
			}
			public void onTimeout() {
			}
			public void onData(String data) {
				if(status == USER_CLOSED){
				}else if(status == USER_CONNECTED){
				}else{
					QrONEUser.this.onData(data);
				}
			}
			
			public void onXML(Document doc) {
				if(status == USER_CLOSED){
				}else if(status == USER_CONNECTED){
					Element element = doc.getDocumentElement();
					String stateAttr = element.getAttribute("state");
					String uriAttr = element.getAttribute("uri");
					String charset = element.getAttribute("charset");
					browser = element.getAttribute("browser");
					
					if(element.getNodeName().equals("QrONE") &&
							stateAttr != null &&
							stateAttr.equals("onConnect")){
						
						if(!charset.equals(userCharset)){
							try{
								xmlsocket.setEncoding(Charset.forName(charset));
								userCharset = charset;
								
								transformer = tfactory.newTransformer();
								transformer.setOutputProperty(
										OutputKeys.ENCODING,userCharset);
								
							}catch(UnsupportedCharsetException e){
							}catch(IllegalCharsetNameException e){
							}catch(TransformerConfigurationException e){
								e.printStackTrace();
							}
						}
						/*
						if(interval!=null){
							try{
								xmlsocket.setWriteIntervalTime(
										Integer.parseInt(interval));
							} catch (NumberFormatException e){}
						}*/
						
						if(uriAttr != null){
							preferedServiceURI = uriAttr;
						}
						status = USER_INITED;
						if(browser.indexOf("ie") == -1){
							xmlsocket.send(toLiteral(
								"<?xml version=\"1.0\" encoding=\""+userCharset+"\"?>"+
								"<QrONE status=\"onInit\" uid=\""
								+getUniqueId()+"\" sid=\""
								+getSessionId()+"\" test=\"{\"/>"));
						}else{
							xmlsocket.send(
								"<?xml version=\"1.0\" encoding=\""+userCharset+"\"?>"+
								"<QrONE status=\"onInit\" uid=\""
								+getUniqueId()+"\" sid=\""
								+getSessionId()+"\" test=\"{\"/>");
						}
					}
				}
			}
		});
	}
	
	public String getSessionId(){
		return sessionId;
	}
	public String getUniqueId(){
		return uniqueId;
	}
	public boolean isOnline(){
		if( status == USER_REGISTERED ){
			return true;
		}else{
			return false;
		}
	}

	public QrONEServer getServer(){
		return server;
	}
	
	public QrONEService getService(){
		return service;
	}
	
	public QrONESession getSession(){
		return server.getSession(this);
	}
	
	public QrONESession getSession(boolean create){
		return server.getSession(this,create);
	}
	
	public void close(){
		xmlsocket.close();
	}
	
	public void update(String sessionkey){
		for (Iterator iter = userlistener.iterator(); iter.hasNext();) {
			((QrONEUserListener) iter.next()).onUpdate(sessionkey);
		}
	}
	
	/**
	 * xmldoc ̃[U[ɑM܂B
	 * @param xmldoc@M XML Document
	 * @throws TransformerException
	 */
	public void send(Document xmldoc) throws TransformerException{
		if(status >= USER_REGISTERED){
			if(browser.indexOf("ie") == -1){
				xmlsocket.send(toLiteral(XMLTools.write(xmldoc,transformer)));
			}else{
				xmlsocket.send(XMLTools.write(xmldoc,transformer));
			}
		}
	}
	
	/**
	 * xmlstr ̃[U[ɑM܂Bxmlstr ́Awell-formed XML@łKv
	 * XML錾͐΂Ɋ܂܂ĂĂ͂܂BiMΏۃ[U[ɂėp镶R[h
	 * ςKv邽߂łBj<BR>
	 * <BR>
	 * XML 錾 <code>&lt;?xml version="1.0" encoding="<i>Charset</i>"/?&gt;</code>
	 * Iɒǉ܂Bxmlstr ́AK[gm[hJnĂKv܂B
	 * @param xmlstr@M XML String
	 */
	public void send(String xmlstr){
		if(status >= USER_REGISTERED){
			if(browser.indexOf("ie") == -1){
				xmlsocket.send(toLiteral(
						"<?xml version=\"1.0\" encoding=\""+userCharset+"\"?>"
						+xmlstr));
			}else{
				xmlsocket.send(
						"<?xml version=\"1.0\" encoding=\""+userCharset+"\"?>"
						+xmlstr);
			}
		}
	}
	
	private String toLiteral(String str){
		StringBuffer buf = new StringBuffer();
		char[] ch = str.toCharArray();
		for (int i = 0; i < ch.length; i++) {
			switch(ch[i]){
			case '\b':
				buf.append("\\b");
				break;
			case '\f':
				buf.append("\\f");
				break;
			case '\n':
				buf.append("\\n");
				break;
			case '\r':
				buf.append("\\r");
				break;
			case '\t':
				buf.append("\\t");
				break;
			case '\'':
				buf.append("\\\'");
				break;
			case '\"':
				buf.append("\\\"");
				break;
			case '\\':
				buf.append("\\\\");
				break;
			default:
				buf.append(ch[i]);
				break;
			}
		}
		return buf.toString();
	}
	
	private void onConnect(boolean success){
		for (Iterator iter = userlistener.iterator(); iter.hasNext();) {
			((QrONEUserListener) iter.next()).onConnect(success);
		}
	}
	
	private void onClose(){
		for (Iterator iter = userlistener.iterator(); iter.hasNext();) {
			((QrONEUserListener) iter.next()).onClose();
		}
	}
	
	public void onData(String xmlstr) {
		Document xmldoc=null;
		try {
			xmldoc = XMLTools.read(xmlstr);
			if(status < USER_INITED){
				return;
			}else if(status == USER_INITED){
				Element element = xmldoc.getDocumentElement();
				String sidAttr = element.getAttribute("sid");
				String uriAttr = element.getAttribute("uri");
				
				sessionId = sidAttr;
				try {
					service = server.getService(uriAttr);
					if(service != null){
						if(service.addUser(this, xmldoc)){
							status = USER_REGISTERED;
							onConnect(true);
							return;
						}
					}else{
						throw new ServiceException("Unknown",null);
					}
				} catch (ServiceException e) {
					xmlsocket.close();
					status = USER_CLOSED;
					return;
				}
			}
		} catch (SAXException e) {}
		for (Iterator iter = userlistener.iterator(); iter.hasNext();) {
			((QrONEUserListener) iter.next()).onData(xmlstr);
		}
		if(xmldoc!=null){
			for (Iterator iter = userlistener.iterator(); iter.hasNext();) {
				((QrONEUserListener) iter.next()).onXML(xmldoc);
			}
		}
	}

	/**
	 * Add QrONEUserListener instance.
	 * @param listener eventhandler instance
	 */
	public void addQrONEUserListener(QrONEUserListener listener) {
		if (userlistener == null)
			userlistener = new LinkedList();
		userlistener.add(listener);
	}

	/**
	 * Remove QrONEUserListener instance that is already added.
	 * @param listener eventhandler instance
	 */
	public void removeQrONEUserListener(QrONEUserListener listener) {
		userlistener.remove(listener);
	}
}
