/*!
  \example gd_scan.c

  \brief GD XLTv

  GD R}hpāA̋f[^擾s

  \author Satofumi KAMIMURA

  $Id: gd_scan.c 1299 2009-09-15 00:56:12Z satofumi $
*/

#include "urg_ctrl.h"
#include <stdio.h>
#include <stdlib.h>


static void urg_exit(urg_t *urg, const char *message)
{
  printf("%s: %s\n", message, urg_error(urg));
  urg_disconnect(urg);

#ifdef MSC
  getchar();
#endif
  exit(1);
}


int main(int argc, char *argv[])
{
  //const char device[] = "COM3"; /* Windows ł̗ */
  const char device[] = "/dev/ttyACM0"; /* Linux ł̗ */

  int data_max;
  long *data;
  int timestamp;
  int ret;
  int n;
  int i;

  /* ڑ */
  urg_t urg;
  ret = urg_connect(&urg, device, 115200);
  if (ret < 0) {
    urg_exit(&urg, "urg_connect()");
  }

  /* Mobt@̊m */
  data_max = urg_dataMax(&urg);
  data = (long*)malloc(sizeof(long) * data_max);
  if (data == NULL) {
    perror("malloc");
    exit(1);
  }

  /* GD ł̃f[^v */
  ret = urg_requestData(&urg, URG_GD, URG_FIRST, URG_LAST);
  if (ret < 0) {
    urg_exit(&urg, "urg_requestData()");
  }

  /* M */
  n = urg_receiveData(&urg, data, data_max);
  printf("# n = %d\n", n);
  if (n < 0) {
    urg_exit(&urg, "urg_receiveData()");
  }

  /* \ */
  timestamp = urg_recentTimestamp(&urg);
  printf("# timestamp: %d\n", timestamp);
  for (i = 0; i < n; ++i) {
    /* urg_minDistance() ȉ̋f[^́Al\ */
    printf("%d %ld, ", i, data[i]);
  }
  printf("\n");

  urg_disconnect(&urg);
  free(data);

#ifdef MSC
  getchar();
#endif

  return 0;
}
