#ifndef QRK_C_URG_CTRL_H
#define QRK_C_URG_CTRL_H

/*!
  \file
  \brief URG 

  \author Satofumi KAMIMURA

  $Id: urg_ctrl.h 1300 2009-09-15 06:36:54Z satofumi $

  \todo e֐Ɏgp`
*/

#if !defined(NO_INTENSITY)
#define USE_INTENSITY
#endif

#include "urg_t.h"


/*!
  \brief IvVpp[^
*/
enum {
  UrgLineWidth = 64 + 1 + 1,    /*!< Ps̍ő咷 */
  UrgInfinityTimes = 0,         /*!< Af[^Mw */
};


/*!
  \brief URG ̃R}h^Cv
*/
typedef enum {
  URG_GD,                       /*!< GD R}h */
  URG_GD_INTENSITY,             /*!< GD R}h(xf[^t) */
  URG_GS,                       /*!< GS R}h */
  URG_MD,                       /*!< MD R}h */
  URG_MD_INTENSITY,             /*!< MD R}h(xf[^t) */
  URG_MS,                       /*!< MS R}h */
} urg_request_type;


/*!
  \brief URG f[^͈͎w̏ȗp
*/
enum {
  URG_FIRST = -1,          /*!< S̃f[^擾Ƃ̊Jnʒu  */
  URG_LAST = -1,           /*!< S̃f[^擾Ƃ̏Iʒu  */

  UrgInvalidTimestamp = -1,     /*!< ^CX^ṽG[l */
};


/*!
  \brief ڑ

  \param[in,out] urg URG ̍\
  \param[in] device ڑfoCX
  \param[in] baudrate ڑ{[[g

  \retval 0 
  \retval <0 G[

  \see gd_scan.c, md_scan.c

  gp
\code
urg_t urg;

// ڑ
if (urg_connect(&urg, "COM3", 115200) < 0) {
  printf("urg_connect: %s\n", urg_error(&urg));
  return -1;
}

...

urg_disconnect(&urg); \endcode
*/
extern int urg_connect(urg_t *urg, const char *device, long baudrate);


/*!
  \brief ؒf

  \param[in,out] urg URG ̍\

  \see urg_connect()
  \see gd_scan.c, md_scan.c
*/
extern void urg_disconnect(urg_t *urg);


/*!
  \brief ڑԂ

  \param[in,out] urg URG ̍\

  \retval 0 ڑ
  \retval <0 ڑ

  \see urg_connect(), urg_disconnect()

  gp
\code
if (urg_isConnected(&urg) < 0) {
  printf("not connected.\n");
} else {
  printf("connected.\n");
} \endcode
*/
extern int urg_isConnected(const urg_t *urg);


/*!
  \brief G[̎擾

  \param[in,out] urg URG ̍\

  \return G[

  \see urg_connect()
  \see gd_scan.c, md_scan.c
*/
extern const char *urg_error(const urg_t *urg);


/*!
  \brief o[W̎擾

  \param[in,out] urg URG ̍\
  \param[out] lines o[W̊i[obt@
  \param[in] lines_max o[Wi[̍ős

  \retval 0 
  \retval <0 G[

  \attention obt@Ps̒ #UrgLineWidth [byte] ȏłȂ΂ȂȂ

  \see get_version_lines.c
*/
extern int urg_versionLines(urg_t *urg, char* lines[], int lines_max);


/*!
  \brief URG p[^Ԃ

  \param[in,out] urg URG ̍\
  \param[out] parameters URG p[^̍\

  \retval 0 
  \retval <0 G[

  \see urg_maxDistance(), urg_minDistance(), urg_scanMsec(), urg_dataMax()
  \see get_parameters.c

  get_parameters.c ̎s (Classic-URG)
  \verbatim
% ./get_parameters
urg_getParameters: No Error.
distance_min: 20
distance_max: 5600
area_total: 1024
area_min: 44
area_max: 725
area_front: 384
scan_rpm: 600

urg_getDistanceMax(): 5600
urg_getDistanceMin(): 20
urg_getScanMsec(): 100
urg_getDataMax(): 726 \endverbatim
  */
extern int urg_parameters(urg_t *urg, urg_parameter_t* parameters);


/*!
  \brief URG ZT̃^CvԂ

  \param[in,out] urg URG ̍\

  \retval URG ZT̃^Cv

  \code
printf("URG type: %s\n", urg_model(&urg)); \endcode
*/
extern const char* urg_model(const urg_t *urg);


/*!
  \brief PXL̍őf[^Ԃ

  \param[in,out] urg URG ̍\

  \retval >=0 PXL̍őf[^
  \retval <0 G[

  \see gd_scan.c

gp
\code
enum { BufferSize = 2048 };
long data[BufferSize];

...

// URG ZT̎擾f[^őlAMobt@zȂmF
// (IɃobt@TCY擾ꍇɂ͕sv)
int data_max = urg_dataMax(&urg);
ASSERT(BufferSize >= data_max);
\endcode
*/
extern int urg_dataMax(const urg_t *urg);


/*!
  \brief PXĽvԂԂ

  [^x 100% ŵƂ̂PXĽvԂԂB

  \param[in,out] urg URG ̍\

  \retval >=0 PXĽv [msec]
  \retval <0 G[

  \see urg_setMotorSpeed()

  \see md_scan.c
*/
extern int urg_scanMsec(const urg_t *urg);


/*!
  \brief \ȍő勗

  \param[in,out] urg URG ̍\

  \retval >=0 \ȍő勗 [mm]
  \retval <0 G[

  \see expand_2d.c

gp
\code
...
n = urg_receiveData(&urg, data, data_max);

min_distance = urg_minDistance(&urg);
max_distance = urg_minDistance(&urg);

// Lȃf[^̂ݏo
for (i = 0; i < n; ++i) {
  long length = data[i];
  if ((length > min_distance) && (length < max_distance)) {
    printf("%d:%d\n", i, length);
  }
}
\endcode
*/
extern long urg_maxDistance(const urg_t *urg);


/*!
  \brief \ȍŏ

  \param[in,out] urg URG ̍\

  \retval >=0 \ȍŏ [mm]
  \retval <0 G[

  \see expand_2d.c
*/
extern long urg_minDistance(const urg_t *urg);


/* ---------------------------------------------------------------------- */


/*!
  \brief 擾f[^̃O[vݒ

  ̎擾f[^Pɂ܂Ƃ߁A擾f[^ʂB

  \param[in,out] urg URG ̍\
  \param[in] lines Pɂ܂Ƃ߂擾f[^

  \retval 0 
  \retval < G[
*/
extern int urg_setSkipLines(urg_t *urg, int lines);


/*!
  \brief XL̊Ԉݒ

  P̃f[^擾AwXL񐔂f[^擾xށB

  \param[in,out] urg URG ̍\
  \param[in] frames Ԉt[

  \retval 0 
  \retval <0 G[

  \attention MD/MS R}hł̃f[^擾ɑ΂Ă̂ݗL
*/
extern int urg_setSkipFrames(urg_t *urg, int frames);


/*!
  \brief Af[^擾񐔂̐ݒ

  \param[in,out] urg URG ̍\
  \param[in] times f[^擾

  \retval 0 
  \retval <0 G[

  \attention MD/MS R}hł̃f[^擾ɑ΂Ă̂ݗL
  \attention 100 ȏ̃f[^擾sƂ́A#UrgInfinityTimes w肷邱

  gp
  \code
// ̃f[^擾
urg_setCaptureTimes(&urg, UrgInfinityTimes);

...

// [UƁAf[^擾͒~
urg_laserOff(&urg);
  \endcode
*/
extern int urg_setCaptureTimes(urg_t *urg, int times);


/*!
  \brief MD/MS f[^擾ɂcXL擾

  \param[in,out] urg URG ̍\

  \retval cXLBÃf[^擾̂Ƃ 100 Ԃ

  \see md_scan.c
*/
extern int urg_remainCaptureTimes(const urg_t *urg);


/*!
  \brief f[^̎擾v

  [first_index, last_index] ̋f[^vBfirst_index, last_index ɂꂼ URG_FIRST, URG_LAST w肷邱ƂŁAS͈͂̃f[^擾s킹邱ƂłB

  \param[in,out] urg URG ̍\
  \param[in] request_type f[^擾^Cv
  \param[in] first_index f[^擾JnCfbNX
  \param[in] last_index f[^擾ICfbNX

  \retval 0 
  \retval <0 G[

  \see urg_receiveData()
  \see gd_scan.c, md_scan.c

gp
\code
// GD XLɂPXL̃f[^擾
urg_requestData(&urg, URG_GD, URG_FIRST, URG_LAST);
n = urg_receiveData(&urg, data, data_max);

// MD XLɂÃf[^擾
urg_requestData(&urg, URG_MD, URG_FIRST, URG_LAST);
while (1) {
  n = urg_receiveData(&urg, data, data_max);
  if (n > 0) {
    // f[^̕\Ȃ
    ...
  }
}
\endcode
*/
extern int urg_requestData(urg_t *urg,
                           urg_request_type request_type,
                           int first_index,
                           int last_index);


/*!
  \brief URG f[^̎M

  \param[in,out] urg URG ̍\
  \param[out] data Mf[^̊i[
  \param[in] data_max Mf[^̍ő吔

  \retval 0 > 擾f[^
  \retval <0 G[

  \see urg_requestData()
*/
extern int urg_receiveData(urg_t *urg, long data[], int data_max);


#if defined(USE_INTENSITY)
/*!
  \brief xtf[^̎擾

  \param[in,out] urg URG ̍\
  \param[out] data Mf[^̊i[
  \param[in] data_max Mf[^̍ő吔
  \param[out] intensity x̎Mf[^i[

  \attention Classic-URG, Top-URG ̂ݑΉ (2009-04-19 )
  \attention Top-URG  ME Ή́A擾f[^̃O[sOQɌŒ
*/
extern int urg_receiveDataWithIntensity(urg_t *urg, long data[], int data_max,
                                        long intensity[]);
#endif


/*!
  \brief URG f[^̕M

  \param[in,out] urg URG ̍\
  \param[out] data Mf[^̊i[
  \param[in] data_max Mf[^̍ő吔
  \param[in] first_index f[^i[JnCfbNX
  \param[in] last_index f[^i[ICfbNX

  \retval 0 > 擾f[^
  \retval <0 G[

  \attention 

  \see gd_scan.c, md_scan.c
*/
extern int urg_receivePartialData(urg_t *urg, long data[], int data_max,
                                  int first_index, int last_index);


/*!
  \brief ^CX^v̎擾

  \param[in,out] urg URG ̍\

  \retval ^CX^v [msec]

  \see md_scan.c

gp
\code
urg_requestData(&urg, URG_GD, URG_FIRST, URG_LAST);
n = urg_receiveData(&urg, data, data_max);
if (n > 0) {
  long timestamp = urg_recentTimestamp(&urg);
  printf("timestamp: %d\n", timestamp);

  // f[^̕\Ȃ
  // !!!
}
\endcode
*/
extern long urg_recentTimestamp(const urg_t *urg);


/* ---------------------------------------------------------------------- */


/*!
  \brief CfbNXl radian pxɕϊ

  \image html urg_sensor_radian.png ZTʂ X ̐̕

  \param[in,out] urg URG ̍\
  \param[in] index CfbNXl

  \return px [radian]

  \see index_convert.c
*/
extern double urg_index2rad(const urg_t *urg, int index);


/*!
  \brief CfbNXl degree pxɕϊ

  \param[in,out] urg URG ̍\
  \param[in] index CfbNXl

  \return px [degree]

  \see index_convert.c
*/
extern int urg_index2deg(const urg_t *urg, int index);


/*!
  \brief radian pxCfbNXlɕϊ

  \image html urg_sensor_radian.png ZTʂ X ̐̕

  \param[in,out] urg URG ̍\
  \param[in] radian px

  \return CfbNXl

  \see index_convert.c
*/
extern int urg_rad2index(const urg_t *urg, double radian);


/*!
  \brief degree pxCfbNXlɕϊ

  \param[in,out] urg URG ̍\
  \param[in] degree px

  \return CfbNXl

  \see index_convert.c
*/
extern int urg_deg2index(const urg_t *urg, int degree);


/* ---------------------------------------------------------------------- */


/*!
  \brief [U̓_w

  \param[in,out] urg URG ̍\

  \retval 0 
  \retval <0 G[

  \see gd_scan.c
*/
extern int urg_laserOn(urg_t *urg);


/*!
  \brief [Ȕw

  \param[in,out] urg URG ̍\

  \retval 0 
  \retval <0 G[
*/
extern int urg_laserOff(urg_t *urg);


/*!
  \brief n[hEFAEZbg

  \retval 0 
  \retval <0 G[
*/
extern int urg_reset(urg_t *urg);


/* ---------------------------------------------------------------------- */


/*!
  \brief ^CX^v[hɓ

  \param[in,out] urg URG ̍\

  \retval 0 
  \retval <0 G[
*/
extern int urg_enableTimestampMode(urg_t *urg);


/*!
  \brief ^CX^v[h甲

  \param[in,out] urg URG ̍\

  \retval 0 
  \retval <0 G[
*/
extern int urg_disableTimestampMode(urg_t *urg);


/*!
  \brief ^CX^v̎擾

  TM1 ̉ԂB

  \param[in,out] urg URG ̍\

  \retval >=0 ^CX^v [msec]
  \retval <0 G[

gp
\code
// ^CX^v[hɓ
urg_enableTimestampMode(&urg);

// URG ̃^CX^vAĎ擾
for (i = 0; i < 5; ++i) {
  long timestamp = urg_currentTimestamp(&urg);
  printf("timestamp: %ld\n", timestamp)
}

// ^CX^v[h甲
urg_disableTimestampMode(&urg);
\endcode
*/
extern long urg_currentTimestamp(urg_t *urg);

#endif /* !QRK_C_URG_CTRL_H */
