#ifndef GRID_TYPES_H
#define GRID_TYPES_H

/*!
  \file
  \brief 型定義

  \author Satofumi KAMIMURA

  $Id$
*/

namespace qrk {

  /*!
    \brief ２次元位置
  */
  template<class T> class Grid {
  public:
    T x;
    T y;

    Grid(void) : x(0), y(0) {
    }

    Grid(const Grid& rhs) : x(rhs.x), y(rhs.y) {
    }

    Grid(T x_, T y_) : x(x_), y(y_) {
    }

    Grid& operator = (const Grid& rhs) {
      this->x = rhs.x;
      this->y = rhs.y;

      return *this;
    }

    ~Grid(void) {
    }
  };


  /*!
    \brief ３次元位置

    \todo Grid<> を継承すべきか検討する
  */
  template<class T> class Grid3D {
  public:
    T x;
    T y;
    T z;

    Grid3D(void) : x(0), y(0), z(0) {
    }

    Grid3D(const Grid3D& rhs) : x(rhs.x), y(rhs.y), z(rhs.z) {
    }

    Grid3D(T x_, T y_, T z_) : x(x_), y(y_), z(z_) {
    }

    Grid3D& operator = (const Grid3D& rhs) {
      this->x = rhs.x;
      this->y = rhs.y;
      this->z = rhs.z;

      return *this;
    }

    ~Grid3D(void) {
    }
  };
};

#endif /* !GRID_TYPES_H */
