package example;

import jp.sourceforge.qrcode.QRCodeDecoder;
import jp.sourceforge.qrcode.util.ContentConverter;
import jp.sourceforge.qrcode.data.QRCodeImage;
import jp.sourceforge.qrcode.exception.DecodingFailedException;
import jp.sourceforge.qrcode.exception.InvalidVersionInfoException;

import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import java.io.File;
import java.io.IOException;
import jp.sourceforge.qrcode.util.DebugCanvas;
import jp.sourceforge.qrcode.util.DebugCanvasAdapter;
import java.net.URL;

// Smallest example of QRCode Decoder

public class QRCodeDecoderCUIExample {
	public static void main(String[] args) {
    DebugCanvas canvas = new J2SECanvas();
		if (args.length < 1) {
			canvas.println("Usage: QRCodeDecoderCUIExample imageFilePath");
			System.exit(1);
		}
		QRCodeDecoder decoder = new QRCodeDecoder();
    decoder.setCanvas(canvas);
		BufferedImage image = null;
		try {
      if (args[0].startsWith("http://"))
        image = ImageIO.read(new URL(args[0]));
      else
			  image = ImageIO.read(new File(args[0]));
			String decodedString = new String(decoder.decode(new J2SEImage(image)));
		  decodedString = ContentConverter.convert(decodedString);
			System.out.println(decodedString);
		} catch (IOException e) {
			canvas.println("Error: "+ e.getMessage() + " " + args[0]);
      System.exit(1);
		} catch (DecodingFailedException dfe) {
			canvas.println("Error: " + dfe.getMessage());
      System.exit(1);
		} catch (Exception e) {
			canvas.println("Error: " + e.getMessage());
      System.exit(1);
    }
	}
}

class J2SEImage implements QRCodeImage {
	BufferedImage image;

	public J2SEImage(BufferedImage image) {
		this.image = image;
	}

	public int getWidth() {
		return image.getWidth();
	}
	
	public int getHeight() {
		return image.getHeight();
	}

	public int getPixel(int x, int y) {
		return image.getRGB(x, y);
	}
}

class J2SECanvas extends DebugCanvasAdapter {
  public void println(String s) {
    System.err.println(s);
  }
}
