/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode;

import java.util.Vector;
import jp.sourceforge.qrcode.data.QRCodeImage;
import jp.sourceforge.qrcode.data.QRCodeSymbol;
import jp.sourceforge.qrcode.ecc.ReedSolomon;
import jp.sourceforge.qrcode.exception.DecodingFailedException;
import jp.sourceforge.qrcode.exception.InvalidDataBlockException;
import jp.sourceforge.qrcode.exception.SymbolNotFoundException;
import jp.sourceforge.qrcode.geom.Point;
import jp.sourceforge.qrcode.reader.QRCodeDataBlockReader;
import jp.sourceforge.qrcode.reader.QRCodeImageReader;
import jp.sourceforge.qrcode.util.DebugCanvas;
import jp.sourceforge.qrcode.util.DebugCanvasAdapter;

public class QRCodeDecoder {
    int numTryDecode = 0;
    QRCodeSymbol qrCodeSymbol;
    Vector results;
    Vector lastResults = new Vector();
    static DebugCanvas canvas;
    QRCodeImageReader imageReader;
    int numLastCorrections;
    boolean correctionSucceeded;

    public static void setCanvas(DebugCanvas debugCanvas) {
        canvas = debugCanvas;
    }

    public static DebugCanvas getCanvas() {
        return canvas;
    }

    public QRCodeDecoder() {
        this.results = new Vector();
        canvas = new DebugCanvasAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decode(QRCodeImage qRCodeImage) throws DecodingFailedException {
        Point[] pointArray = this.getAdjustPoints();
        Vector<DecodeResult> vector = new Vector<DecodeResult>();
        while (this.numTryDecode < pointArray.length) {
            try {
                DecodeResult decodeResult = this.decode(qRCodeImage, pointArray[this.numTryDecode]);
                if (decodeResult.isCorrectionSucceeded()) {
                    byte[] byArray = decodeResult.getDecodedBytes();
                    return byArray;
                }
                vector.addElement(decodeResult);
                canvas.println("Decoding succeeded but could not correct");
                canvas.println("all errors. Retrying..");
            }
            catch (DecodingFailedException decodingFailedException) {
                if (decodingFailedException.getMessage().indexOf("Finder Pattern") < 0) continue;
                throw decodingFailedException;
            }
            finally {
                ++this.numTryDecode;
            }
        }
        if (vector.size() == 0) {
            throw new DecodingFailedException("Give up decoding");
        }
        int n = -1;
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < vector.size(); ++i) {
            DecodeResult decodeResult = (DecodeResult)vector.elementAt(i);
            if (decodeResult.getNumErrors() >= n2) continue;
            n2 = decodeResult.getNumErrors();
            n = i;
        }
        canvas.println("All trials need for correct error");
        canvas.println("Reporting #" + n + " that,");
        canvas.println("corrected minimum errors (" + n2 + ")");
        canvas.println("Decoding finished.");
        return ((DecodeResult)vector.elementAt(n)).getDecodedBytes();
    }

    Point[] getAdjustPoints() {
        int n;
        int n2;
        Vector<Point> vector = new Vector<Point>();
        for (n2 = 0; n2 < 4; ++n2) {
            vector.addElement(new Point(1, 1));
        }
        n2 = 0;
        int n3 = 0;
        for (int i = 0; i > -4; --i) {
            for (n = 0; n > -4; --n) {
                if (n == i || (n + i) % 2 != 0) continue;
                vector.addElement(new Point(n - n2, i - n3));
                n2 = n;
                n3 = i;
            }
        }
        Point[] pointArray = new Point[vector.size()];
        for (n = 0; n < pointArray.length; ++n) {
            pointArray[n] = (Point)vector.elementAt(n);
        }
        return pointArray;
    }

    DecodeResult decode(QRCodeImage qRCodeImage, Point point) throws DecodingFailedException {
        Object object;
        try {
            if (this.numTryDecode == 0) {
                canvas.println("Decoding started");
                object = this.imageToIntArray(qRCodeImage);
                this.imageReader = new QRCodeImageReader();
                this.qrCodeSymbol = this.imageReader.getQRCodeSymbol((int[][])object);
            } else {
                canvas.println("--");
                canvas.println("Decoding restarted #" + this.numTryDecode);
                this.qrCodeSymbol = this.imageReader.getQRCodeSymbolWithAdjustedGrid(point);
            }
        }
        catch (SymbolNotFoundException symbolNotFoundException) {
            throw new DecodingFailedException(symbolNotFoundException.getMessage());
        }
        canvas.println("Created QRCode symbol.");
        canvas.println("Reading symbol.");
        canvas.println("Version: " + this.qrCodeSymbol.getVersionReference());
        canvas.println("Mask pattern: " + this.qrCodeSymbol.getMaskPatternRefererAsString());
        object = this.qrCodeSymbol.getBlocks();
        canvas.println("Correcting data errors.");
        object = this.correctDataBlocks((int[])object);
        try {
            byte[] byArray = this.getDecodedByteArray((int[])object, this.qrCodeSymbol.getVersion(), this.qrCodeSymbol.getNumErrorCollectionCode());
            return new DecodeResult(byArray, this.numLastCorrections, this.correctionSucceeded);
        }
        catch (InvalidDataBlockException invalidDataBlockException) {
            canvas.println(invalidDataBlockException.getMessage());
            throw new DecodingFailedException(invalidDataBlockException.getMessage());
        }
    }

    int[][] imageToIntArray(QRCodeImage qRCodeImage) {
        int n = qRCodeImage.getWidth();
        int n2 = qRCodeImage.getHeight();
        int[][] nArray = new int[n][n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[j][i] = qRCodeImage.getPixel(j, i);
            }
        }
        return nArray;
    }

    int[] correctDataBlocks(int[] nArray) {
        int n = 0;
        int n2 = this.qrCodeSymbol.getDataCapacity();
        int[] nArray2 = new int[n2];
        int n3 = this.qrCodeSymbol.getNumErrorCollectionCode();
        int n4 = this.qrCodeSymbol.getNumRSBlocks();
        int n5 = n3 / n4;
        if (n4 == 1) {
            ReedSolomon reedSolomon = new ReedSolomon(nArray, n5 / 2);
            reedSolomon.correct();
            if ((n += reedSolomon.getNumCorrectedErrors()) > 0) {
                canvas.println(String.valueOf(n) + " data errors corrected.");
            } else {
                canvas.println("No errors found.");
            }
            this.numLastCorrections = n;
            this.correctionSucceeded = reedSolomon.isCorrectionSucceeded();
            return nArray;
        }
        int n6 = n2 % n4;
        if (n6 == 0) {
            int n7;
            int n8 = n2 / n4;
            int[][] nArray3 = new int[n4][n8];
            for (n7 = 0; n7 < n4; ++n7) {
                for (int i = 0; i < n8; ++i) {
                    nArray3[n7][i] = nArray[i * n4 + n7];
                }
                canvas.println("eccPerRSBlock=" + n5);
                ReedSolomon reedSolomon = new ReedSolomon(nArray3[n7], n5 / 2);
                reedSolomon.correct();
                n += reedSolomon.getNumCorrectedErrors();
                this.correctionSucceeded = reedSolomon.isCorrectionSucceeded();
            }
            n7 = 0;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n8 - n5; ++j) {
                    nArray2[n7++] = nArray3[i][j];
                }
            }
        } else {
            int n9;
            int n10;
            int n11 = n2 / n4;
            int n12 = n2 / n4 + 1;
            int n13 = n4 - n6;
            int[][] nArray4 = new int[n13][n11];
            int[][] nArray5 = new int[n6][n12];
            for (n10 = 0; n10 < n4; ++n10) {
                ReedSolomon reedSolomon;
                if (n10 < n13) {
                    n9 = 0;
                    for (int i = 0; i < n11; ++i) {
                        if (i == n11 - n5) {
                            n9 = n6;
                        }
                        nArray4[n10][i] = nArray[i * n4 + n10 + n9];
                    }
                    canvas.println("eccPerRSBlock(shorter)=" + n5);
                    reedSolomon = new ReedSolomon(nArray4[n10], n5);
                    reedSolomon.correct();
                    n += reedSolomon.getNumCorrectedErrors();
                    this.correctionSucceeded = reedSolomon.isCorrectionSucceeded();
                    continue;
                }
                n9 = 0;
                for (int i = 0; i < n12; ++i) {
                    if (i == n11 - n5) {
                        n9 = n13;
                    }
                    nArray5[n10 - n13][i] = nArray[i * n4 + n10 - n9];
                }
                canvas.println("eccPerRSBlock(longer)=" + n5);
                reedSolomon = new ReedSolomon(nArray5[n10 - n13], n5);
                reedSolomon.correct();
                n += reedSolomon.getNumCorrectedErrors();
                this.correctionSucceeded = reedSolomon.isCorrectionSucceeded();
            }
            n10 = 0;
            for (n9 = 0; n9 < n4; ++n9) {
                int n14;
                if (n9 < n13) {
                    for (n14 = 0; n14 < n11 - n5; ++n14) {
                        nArray2[n10++] = nArray4[n9][n14];
                    }
                    continue;
                }
                for (n14 = 0; n14 < n12 - n5; ++n14) {
                    nArray2[n10++] = nArray5[n9 - n13][n14];
                }
            }
        }
        if (n > 0) {
            canvas.println(String.valueOf(n) + " data errors corrected.");
        } else {
            canvas.println("No errors found.");
        }
        this.numLastCorrections = n;
        return nArray2;
    }

    byte[] getDecodedByteArray(int[] nArray, int n, int n2) throws InvalidDataBlockException {
        QRCodeDataBlockReader qRCodeDataBlockReader = new QRCodeDataBlockReader(nArray, n, n2);
        byte[] byArray = qRCodeDataBlockReader.getDataByte();
        return byArray;
    }

    String getDecodedString(int[] nArray, int n, int n2) throws InvalidDataBlockException {
        String string = null;
        QRCodeDataBlockReader qRCodeDataBlockReader = new QRCodeDataBlockReader(nArray, n, n2);
        try {
            string = qRCodeDataBlockReader.getDataString();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new InvalidDataBlockException(arrayIndexOutOfBoundsException.getMessage());
        }
        return string;
    }

    class DecodeResult {
        int numCorrections;
        boolean correctionSucceeded;
        byte[] decodedBytes;

        public DecodeResult(byte[] byArray, int n, boolean bl) {
            this.decodedBytes = byArray;
            this.numCorrections = n;
            this.correctionSucceeded = bl;
        }

        public byte[] getDecodedBytes() {
            return this.decodedBytes;
        }

        public int getNumErrors() {
            return this.numCorrections;
        }

        public boolean isCorrectionSucceeded() {
            return this.correctionSucceeded;
        }
    }
}

