/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.ecc;

public class ReedSolomon {
    int[] y;
    int[] gexp = new int[512];
    int[] glog = new int[256];
    int NPAR;
    int MAXDEG;
    int[] synBytes;
    int[] Lambda;
    int[] Omega;
    int[] ErrorLocs = new int[256];
    int NErrors;
    int[] ErasureLocs = new int[256];
    int NErasures = 0;
    boolean correctionSucceeded = true;

    public ReedSolomon(int[] nArray, int n) {
        this.initializeGaloisTables();
        this.y = nArray;
        this.NPAR = n;
        this.MAXDEG = this.NPAR * 2;
        this.synBytes = new int[this.MAXDEG];
        this.Lambda = new int[this.MAXDEG];
        this.Omega = new int[this.MAXDEG];
    }

    void initializeGaloisTables() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 1;
        this.gexp[0] = 1;
        this.gexp[255] = this.gexp[0];
        this.glog[0] = 0;
        for (n = 1; n < 256; ++n) {
            n9 = n2;
            n2 = n3;
            n3 = n4;
            n4 = n5;
            n5 = n6 ^ n9;
            n6 = n7 ^ n9;
            n7 = n8 ^ n9;
            n8 = n10;
            n10 = n9;
            this.gexp[n] = n10 + n8 * 2 + n7 * 4 + n6 * 8 + n5 * 16 + n4 * 32 + n3 * 64 + n2 * 128;
            this.gexp[n + 255] = this.gexp[n];
        }
        block1: for (n = 1; n < 256; ++n) {
            for (int i = 0; i < 256; ++i) {
                if (this.gexp[i] != n) continue;
                this.glog[n] = i;
                continue block1;
            }
        }
    }

    int gmult(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return 0;
        }
        int n3 = this.glog[n];
        int n4 = this.glog[n2];
        return this.gexp[n3 + n4];
    }

    int ginv(int n) {
        return this.gexp[255 - this.glog[n]];
    }

    void decode_data(int[] nArray) {
        for (int i = 0; i < this.MAXDEG; ++i) {
            int n = 0;
            for (int j = 0; j < nArray.length; ++j) {
                n = nArray[j] ^ this.gmult(this.gexp[i + 1], n);
            }
            this.synBytes[i] = n;
        }
    }

    public void correct() {
        this.decode_data(this.y);
        this.correctionSucceeded = true;
        boolean bl = false;
        for (int i = 0; i < this.synBytes.length; ++i) {
            if (this.synBytes[i] == 0) continue;
            bl = true;
        }
        if (bl) {
            this.correctionSucceeded = this.correct_errors_erasures(this.y, this.y.length, 0, new int[1]);
        }
    }

    public boolean isCorrectionSucceeded() {
        return this.correctionSucceeded;
    }

    public int getNumCorrectedErrors() {
        return this.NErrors;
    }

    void Modified_Berlekamp_Massey() {
        int n;
        int[] nArray = new int[this.MAXDEG];
        int[] nArray2 = new int[this.MAXDEG];
        int[] nArray3 = new int[this.MAXDEG];
        int[] nArray4 = new int[this.MAXDEG];
        this.init_gamma(nArray4);
        this.copy_poly(nArray3, nArray4);
        this.mul_z_poly(nArray3);
        this.copy_poly(nArray, nArray4);
        int n2 = -1;
        int n3 = this.NErasures;
        for (int i = this.NErasures; i < 8; ++i) {
            int n4 = this.compute_discrepancy(nArray, this.synBytes, n3, i);
            if (n4 != 0) {
                for (n = 0; n < this.MAXDEG; ++n) {
                    nArray2[n] = nArray[n] ^ this.gmult(n4, nArray3[n]);
                }
                if (n3 < i - n2) {
                    int n5 = i - n2;
                    n2 = i - n3;
                    for (n = 0; n < this.MAXDEG; ++n) {
                        nArray3[n] = this.gmult(nArray[n], this.ginv(n4));
                    }
                    n3 = n5;
                }
                for (n = 0; n < this.MAXDEG; ++n) {
                    nArray[n] = nArray2[n];
                }
            }
            this.mul_z_poly(nArray3);
        }
        for (n = 0; n < this.MAXDEG; ++n) {
            this.Lambda[n] = nArray[n];
        }
        this.compute_modified_omega();
    }

    void compute_modified_omega() {
        int[] nArray = new int[this.MAXDEG * 2];
        this.mult_polys(nArray, this.Lambda, this.synBytes);
        this.zero_poly(this.Omega);
        for (int i = 0; i < this.NPAR; ++i) {
            this.Omega[i] = nArray[i];
        }
    }

    void mult_polys(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int[] nArray4 = new int[this.MAXDEG * 2];
        for (n = 0; n < this.MAXDEG * 2; ++n) {
            nArray[n] = 0;
        }
        for (n = 0; n < this.MAXDEG; ++n) {
            int n2;
            for (n2 = this.MAXDEG; n2 < this.MAXDEG * 2; ++n2) {
                nArray4[n2] = 0;
            }
            for (n2 = 0; n2 < this.MAXDEG; ++n2) {
                nArray4[n2] = this.gmult(nArray3[n2], nArray2[n]);
            }
            for (n2 = this.MAXDEG * 2 - 1; n2 >= n; --n2) {
                nArray4[n2] = nArray4[n2 - n];
            }
            for (n2 = 0; n2 < n; ++n2) {
                nArray4[n2] = 0;
            }
            for (n2 = 0; n2 < this.MAXDEG * 2; ++n2) {
                int n3 = n2;
                nArray[n3] = nArray[n3] ^ nArray4[n2];
            }
        }
    }

    void init_gamma(int[] nArray) {
        int[] nArray2 = new int[this.MAXDEG];
        this.zero_poly(nArray);
        this.zero_poly(nArray2);
        nArray[0] = 1;
        for (int i = 0; i < this.NErasures; ++i) {
            this.copy_poly(nArray2, nArray);
            this.scale_poly(this.gexp[this.ErasureLocs[i]], nArray2);
            this.mul_z_poly(nArray2);
            this.add_polys(nArray, nArray2);
        }
    }

    void compute_next_omega(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i = 0; i < this.MAXDEG; ++i) {
            nArray2[i] = nArray3[i] ^ this.gmult(n, nArray[i]);
        }
    }

    int compute_discrepancy(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i <= n; ++i) {
            n3 ^= this.gmult(nArray[i], nArray2[n2 - i]);
        }
        return n3;
    }

    void add_polys(int[] nArray, int[] nArray2) {
        for (int i = 0; i < this.MAXDEG; ++i) {
            int n = i;
            nArray[n] = nArray[n] ^ nArray2[i];
        }
    }

    void copy_poly(int[] nArray, int[] nArray2) {
        for (int i = 0; i < this.MAXDEG; ++i) {
            nArray[i] = nArray2[i];
        }
    }

    void scale_poly(int n, int[] nArray) {
        for (int i = 0; i < this.MAXDEG; ++i) {
            nArray[i] = this.gmult(n, nArray[i]);
        }
    }

    void zero_poly(int[] nArray) {
        for (int i = 0; i < this.MAXDEG; ++i) {
            nArray[i] = 0;
        }
    }

    void mul_z_poly(int[] nArray) {
        for (int i = this.MAXDEG - 1; i > 0; --i) {
            nArray[i] = nArray[i - 1];
        }
        nArray[0] = 0;
    }

    void Find_Roots() {
        this.NErrors = 0;
        for (int i = 1; i < 256; ++i) {
            int n = 0;
            for (int j = 0; j < this.NPAR + 1; ++j) {
                n ^= this.gmult(this.gexp[j * i % 255], this.Lambda[j]);
            }
            if (n != 0) continue;
            this.ErrorLocs[this.NErrors] = 255 - i;
            ++this.NErrors;
        }
    }

    boolean correct_errors_erasures(int[] nArray, int n, int n2, int[] nArray2) {
        int n3;
        this.NErasures = n2;
        for (n3 = 0; n3 < this.NErasures; ++n3) {
            this.ErasureLocs[n3] = nArray2[n3];
        }
        this.Modified_Berlekamp_Massey();
        this.Find_Roots();
        if (this.NErrors <= this.NPAR || this.NErrors > 0) {
            int n4;
            for (n4 = 0; n4 < this.NErrors; ++n4) {
                if (this.ErrorLocs[n4] < n) continue;
                return false;
            }
            for (n4 = 0; n4 < this.NErrors; ++n4) {
                int n5;
                n3 = this.ErrorLocs[n4];
                int n6 = 0;
                for (n5 = 0; n5 < this.MAXDEG; ++n5) {
                    n6 ^= this.gmult(this.Omega[n5], this.gexp[(255 - n3) * n5 % 255]);
                }
                int n7 = 0;
                for (n5 = 1; n5 < this.MAXDEG; n5 += 2) {
                    n7 ^= this.gmult(this.Lambda[n5], this.gexp[(255 - n3) * (n5 - 1) % 255]);
                }
                int n8 = this.gmult(n6, this.ginv(n7));
                int n9 = n - n3 - 1;
                nArray[n9] = nArray[n9] ^ n8;
            }
            return true;
        }
        return false;
    }
}

