/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.QRCodeDecoderMIDletExample;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;

class CameraCanvas
extends Canvas
implements CommandListener {
    private final QRCodeDecoderMIDletExample midlet;
    private final Command exitCommand;
    private Command captureCommand = null;
    private Player player = null;
    private VideoControl videoControl = null;
    private boolean active = false;
    private String message1 = null;
    private String message2 = null;

    public CameraCanvas(QRCodeDecoderMIDletExample midlet) {
        this.midlet = midlet;
        this.exitCommand = new Command("Exit", 7, 1);
        this.addCommand(this.exitCommand);
        this.setCommandListener(this);
        try {
            this.player = Manager.createPlayer((String)"capture://video");
            this.player.realize();
            this.videoControl = (VideoControl)this.player.getControl("VideoControl");
            if (this.videoControl == null) {
                this.discardPlayer();
                this.message1 = "Unsupported:";
                this.message2 = "Can't get video control";
            } else {
                this.videoControl.initDisplayMode(1, (Object)this);
                this.captureCommand = new Command("Capture", 1, 1);
                this.addCommand(this.captureCommand);
            }
        }
        catch (IOException ioe) {
            this.discardPlayer();
            this.message1 = "IOException:";
            this.message2 = ioe.getMessage();
        }
        catch (MediaException me) {
            this.discardPlayer();
            this.message1 = "MediaException:";
            this.message2 = me.getMessage();
        }
        catch (SecurityException se) {
            this.discardPlayer();
            this.message1 = "SecurityException";
            this.message2 = se.getMessage();
        }
    }

    private void discardPlayer() {
        if (this.player != null) {
            this.player.close();
            this.player = null;
        }
        this.videoControl = null;
    }

    public void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.message1 != null) {
            g.setColor(0);
            g.drawString(this.message1, 1, 1, 20);
            g.drawString(this.message2, 1, 1 + g.getFont().getHeight(), 20);
        }
    }

    synchronized void start() {
        if (this.player != null && !this.active) {
            try {
                this.player.start();
                this.videoControl.setVisible(true);
            }
            catch (MediaException me) {
                this.message1 = "Media exception:";
                this.message2 = me.getMessage();
            }
            catch (SecurityException se) {
                this.message1 = "SecurityException";
                this.message2 = se.getMessage();
            }
            this.active = true;
        }
    }

    synchronized void stop() {
        if (this.player != null && this.active) {
            try {
                this.videoControl.setVisible(false);
                this.player.stop();
            }
            catch (MediaException me) {
                this.message1 = "MediaException:";
                this.message2 = me.getMessage();
            }
            this.active = false;
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.exitCommand) {
            this.midlet.cameraCanvasExit();
        } else if (c == this.captureCommand) {
            this.takeSnapshot();
        }
    }

    public void keyPressed(int keyCode) {
        if (this.getGameAction(keyCode) == 8) {
            this.takeSnapshot();
        }
    }

    private void takeSnapshot() {
        if (this.player != null) {
            try {
                byte[] pngImage = this.videoControl.getSnapshot(null);
                this.midlet.cameraCanvasCaptured(pngImage);
            }
            catch (MediaException me) {
                this.message1 = "MediaException;";
                this.message2 = me.getMessage();
            }
        }
    }
}

