#ifndef CHARACTER_T_H
#define CHARACTER_T_H

/*!
  \file
  \brief キャラクターの情報管理

  \author Satofumi KAMIMURA

  $Id: character_t.h 13 2009-12-29 03:17:42Z satofumi $
*/

#include <QString>
#include <QPoint>


//! キャラクター情報の管理
typedef struct
{
  QString name;                 //!< 表示名

  QString picture_unknown;      //!< システム情報が取得できないときの画像
  QString picture_charging;     //!< 充電中の画像
  QString picture_discharging;  //!< 充電していないときの画像
  QString percent_bar;          //!< 充電率を表示するためのバー
  QPoint bar_position;          //!< バーの表示位置
} character_t;

#endif /* !CHARACTER_T_H */
