/*!
  \file
  \brief APM ばってりーもにたー

  Qt 実装

  \author Satofumi KAMIMURA

  $Id: main.cpp 32 2010-01-03 02:19:19Z satofumi $
*/

#include "BatmonWidget.h"
#include <QApplication>
#include <QLocale>
#include <QTranslator>
#include <iostream>

using namespace std;

const char*const VersionString = "0.0.3";


namespace
{
  class ArgsInformation
  {
  public:
    bool geometry_specified;


    ArgsInformation(void)
      : geometry_specified(false)
    {
    }
  };


  void printHelp(const char* program_name)
  {
    const QString message =
      QString("usage:\n"
              "\t%1 [options]\n"
              "\n"
              "options\n"
              "  --help, -h                  print this message.\n"
              "  --version, -v               output version infromation.\n"
              "  --geometry <position>       Place to <position>.\n"
              "\n"
              "Report bugs to <satofumi@users.sourceforge.jp>.")
      .arg(program_name);

    cout << message.toStdString() << endl;
  }


  void printVersion(void)
  {
    cout << "qlm_batmon " << VersionString << endl;
  }


  bool parseArgs(ArgsInformation& args, int argc, char *argv[])
  {
    for (int i = 1; i < argc; ++i) {
      char* token = argv[i];

      if ((! strcmp(token, "-h") || (! strcmp(token, "--help")))) {
        printHelp(argv[0]);
        return false;

      } else if ((! strcmp(token, "-v") || (! strcmp(token, "--version")))) {
        printVersion();
        return false;

      } else if ((! strcmp("--geometry", token)) ||
                 (! strcmp("-geometry", token))) {
        // 位置指定があれば、その位置に描画するようにする
        args.geometry_specified = true;
      }
    }

    return true;
  }
}


//! main
int main(int argc, char *argv[])
{
  ArgsInformation args;
  if (! parseArgs(args, argc, argv)) {
    return 1;
  }

  QApplication app(argc, argv);

  // ロケールの適用
  QString locale = QLocale::system().name();
  QTranslator translator;
  translator.load("qlm_batmon_" + locale);
  app.installTranslator(&translator);

  BatmonWidget widget(args.geometry_specified);
  widget.show();

  return app.exec();
}
