/*!
  \file
  \brief キャラクターの描画

  \author Satofumi KAMIMURA

  $Id: DrawCharacter.cpp 7 2009-12-28 13:51:44Z satofumi $
*/

#include "DrawCharacter.h"
#include <QPainter>
#include <QPixmap>
#include <QBitmap>


struct DrawCharacter::pImpl
{
  QString previous_base_name_;
  QPixmap bar_pixmap_;


  QString baseName(character_t& character, ChargingState state)
  {
    switch (state) {
    case Charging:
      return character.picture_charging;
      break;

    case Discharging:
      return character.picture_discharging;
      break;

    default:
    case Unknown:
      return character.picture_unknown;
      break;
    }
  }
};


DrawCharacter::DrawCharacter(void) : pimpl(new pImpl)
{
}


DrawCharacter::~DrawCharacter(void)
{
}


bool DrawCharacter::draw(QPainter& painter,
                         QRect& base_rect, QRegion& region,
                         character_t& character,
                         ChargingState state, size_t percent)
{
  QString base_name = pimpl->baseName(character, state);

  // ベース画像の描画
  QPixmap base_pixmap(base_name);
  painter.drawPixmap(QPoint(0, 0), base_pixmap);
  base_rect = base_pixmap.rect();

  // 前回の描画画像と異なっていたら、背景の透過設定を更新する
  bool update_background = false;
  if (pimpl->previous_base_name_.compare(base_name)) {
    region = base_pixmap.mask();
    update_background = true;
  }

  // システム情報が不定でなければ、バッテリーの充電率を表示する
  if (state != Unknown) {

    // バッテリー充電率を描画
    if (pimpl->bar_pixmap_.isNull()) {
      pimpl->bar_pixmap_.load(character.percent_bar);
    }
    QRect bar_rect(character.bar_position.x(),
                   character.bar_position.y(),
                   pimpl->bar_pixmap_.width(),
                   pimpl->bar_pixmap_.height());
    size_t offset = bar_rect.height() * (100 - percent) / 100;
    bar_rect.setY(bar_rect.y() + offset);
    painter.drawPixmap(bar_rect, pimpl->bar_pixmap_);
  }

  pimpl->previous_base_name_ = base_name;
  return update_background;
}
