#ifndef BATMON_WIDGET_H
#define BATMON_WIDGET_H

/*!
  \file
  \brief qlm_batmon の描画ウィジット

  \author Satofumi KAMIMURA

  $Id: BatmonWidget.h 26 2010-01-02 01:37:37Z satofumi $
*/

#include <QWidget>
#include <QSystemTrayIcon>
#include <memory>


//! バッテリーモニター Widget
class BatmonWidget : public QWidget
{
  Q_OBJECT;

public:
  //! コンストラクタ
  explicit BatmonWidget(bool geometry_specified, QWidget* widget = NULL);
  ~BatmonWidget(void);

private slots:
  void paintEvent(QPaintEvent* event);
  void updateTimeout(void);
  void hideSpecified(void);
  void girlSkinSelected(void);
  void limoSkinSelected(void);

private:
  void mousePressEvent(QMouseEvent* event);
  void mouseMoveEvent(QMouseEvent* event);

  BatmonWidget(const BatmonWidget& rhs);
  BatmonWidget& operator = (const BatmonWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;
};

#endif /* !BATMON_WIDGET_H */
