#ifndef DRAW_CHARACTER_H
#define DRAW_CHARACTER_H

/*!
  \file
  \brief キャラクターの描画

  \author Satofumi KAMIMURA

  $Id: DrawCharacter.h 13 2009-12-29 03:17:42Z satofumi $
*/

#include "character_t.h"
#include "ChargingState.h"
#include <memory>

class QPainter;
class QRect;
class QRegion;


//! キャラクターの描画
class DrawCharacter
{
public:
  DrawCharacter(void);
  ~DrawCharacter(void);

  //! 描画
  bool draw(QPainter& painter, QRect& base_rect, QRegion& region,
            character_t& character, ChargingState state, size_t percent);

private:
  DrawCharacter(const DrawCharacter& rhs);
  DrawCharacter& operator = (const DrawCharacter& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;
};

#endif /* !DRAW_CHARACTER_H */
