/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class Sticky {
    private JComponent _target;
    private static final StrickyMouseMotionListener STICKY_MOUSE_MOTION_LISTENER = new StrickyMouseMotionListener();

    public Sticky(JList jList) {
        this._target = jList;
        this.install();
    }

    public Sticky(JTree jTree) {
        this._target = jTree;
        this.install();
    }

    public Sticky(JTable jTable) {
        this._target = jTable;
        this.install();
    }

    public void install() {
        this._target.addMouseMotionListener(STICKY_MOUSE_MOTION_LISTENER);
    }

    public void uninstall() {
        this._target.removeMouseMotionListener(STICKY_MOUSE_MOTION_LISTENER);
    }

    private static void updateListSelectionForEvent(MouseEvent mouseEvent, JList jList, boolean bl) {
        Point point = mouseEvent.getPoint();
        if (jList == null) {
            return;
        }
        int n = jList.locationToIndex(point);
        if (n == -1) {
            if (point.y < 0) {
                n = 0;
            } else {
                int n2 = n = jList.getModel() == null ? 0 : jList.getModel().getSize() - 1;
            }
        }
        if (jList.getSelectedIndex() != n && n >= 0 && n < jList.getModel().getSize()) {
            jList.setSelectedIndex(n);
            if (bl) {
                jList.ensureIndexIsVisible(n);
            }
        }
    }

    private static void updateTreeSelectionForEvent(MouseEvent mouseEvent, JTree jTree, boolean bl) {
        Point point = mouseEvent.getPoint();
        if (jTree == null) {
            return;
        }
        int n = jTree.getRowForLocation(point.x, point.y);
        if (n != -1) {
            TreePath treePath = jTree.getPathForRow(n);
            if (jTree.getSelectionPath() != treePath) {
                jTree.setSelectionRow(n);
                if (bl) {
                    jTree.makeVisible(treePath);
                }
            }
        }
    }

    private static void updateTableSelectionForEvent(MouseEvent mouseEvent, JTable jTable, boolean bl) {
        Point point = mouseEvent.getPoint();
        if (jTable == null) {
            return;
        }
        int n = jTable.rowAtPoint(point);
        if (n == -1) {
            if (point.y < 0) {
                n = 0;
            } else {
                int n2 = n = jTable.getModel() == null ? 0 : jTable.getModel().getRowCount() - 1;
            }
        }
        if (jTable.getSelectedRow() != n) {
            jTable.getSelectionModel().setSelectionInterval(n, n);
            if (bl) {
                JideSwingUtilities.ensureRowVisible(jTable, n);
            }
        }
    }

    private static class StrickyMouseMotionListener
    extends MouseMotionAdapter {
        private StrickyMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof JList) {
                JList jList = (JList)mouseEvent.getSource();
                Point point = mouseEvent.getPoint();
                Rectangle rectangle = new Rectangle();
                jList.computeVisibleRect(rectangle);
                if (rectangle.contains(point)) {
                    Sticky.updateListSelectionForEvent(mouseEvent, jList, false);
                }
            } else if (mouseEvent.getSource() instanceof JTree) {
                JTree jTree = (JTree)mouseEvent.getSource();
                Point point = mouseEvent.getPoint();
                Rectangle rectangle = new Rectangle();
                jTree.computeVisibleRect(rectangle);
                if (rectangle.contains(point)) {
                    Sticky.updateTreeSelectionForEvent(mouseEvent, jTree, false);
                }
            } else if (mouseEvent.getSource() instanceof JTable) {
                JTable jTable = (JTable)mouseEvent.getSource();
                Point point = mouseEvent.getPoint();
                Rectangle rectangle = new Rectangle();
                jTable.computeVisibleRect(rectangle);
                if (rectangle.contains(point)) {
                    Sticky.updateTableSelectionForEvent(mouseEvent, jTable, false);
                }
            }
        }
    }
}

