/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.lists;

import com.sun.messaging.jmq.util.lists.EventBroadcastHelper;
import com.sun.messaging.jmq.util.lists.EventBroadcaster;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Filter;
import com.sun.messaging.jmq.util.lists.FilterMap;
import com.sun.messaging.jmq.util.lists.Limitable;
import com.sun.messaging.jmq.util.lists.OutOfLimitsException;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.lists.Sized;
import com.sun.messaging.jmq.util.lists.WeakValueHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SimpleNFLHashMap
extends HashMap
implements EventBroadcaster,
Limitable {
    EventBroadcastHelper ebh = new EventBroadcastHelper();
    private boolean enforceLimits = true;
    private int highWaterCnt = 0;
    private long highWaterBytes = 0L;
    private long largestMessageHighWater = 0L;
    private float averageCount = 0.0f;
    private double averageBytes = 0.0;
    private double messageAverage = 0.0;
    private long numberSamples = 0L;
    protected int maxCapacity = -1;
    protected long maxByteCapacity = -1L;
    protected long bytes = 0L;
    protected long maxBytePerObject = -1L;
    Object limitLock = new Object();
    private NLMapEntry oldEntry = new NLMapEntry();
    private NLMapEntry newEntry = new NLMapEntry();
    Map comparatorSets = null;
    Map filterMaps = null;

    public void reset() {
        this.highWaterCnt = 0;
        this.highWaterBytes = 0L;
        this.largestMessageHighWater = 0L;
        this.averageCount = 0.0f;
        this.averageBytes = 0.0;
        this.messageAverage = 0.0;
        this.numberSamples = 0L;
    }

    public Set removeAll(Collection collection) {
        return this.removeAll(collection, null);
    }

    public Set removeAll(Collection collection, Reason reason) {
        Iterator iterator = collection.iterator();
        HashSet<Object> hashSet = new HashSet<Object>();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object object = this.remove(e, reason);
            if (object == null) continue;
            hashSet.add(object);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        HashSet hashSet = null;
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            hashSet = new HashSet(this.keySet());
        }
        this.removeAll(hashSet, null);
    }

    public Map subMap(Filter filter) {
        throw new RuntimeException("Implementation not complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set subSet(Comparator comparator) {
        TreeSet treeSet = new TreeSet(comparator);
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            treeSet.addAll(this.values());
            if (this.comparatorSets == null) {
                this.comparatorSets = Collections.synchronizedMap(new WeakValueHashMap("Comparator"));
            }
            this.comparatorSets.put(comparator, treeSet);
        }
        return treeSet;
    }

    public void putAll(Map map) {
        this.putAll(map, null);
    }

    public void putAll(Map map, Reason reason) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue(), reason);
        }
    }

    public Object put(Object object, Object object2) {
        return this.put(object, object2, null);
    }

    public Object remove(Object object) {
        return this.remove(object, null);
    }

    public Object put(Object object, Object object2, Reason reason) {
        return this.put(object, object2, reason, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2, Reason reason, boolean bl) {
        Object object3;
        Iterator iterator;
        if (this.hasListeners(EventType.SET_CHANGED_REQUEST)) {
            this.notifyChange(EventType.SET_CHANGED_REQUEST, null, object2, reason);
        }
        if (object == null && object2 == null) {
            throw new NullPointerException("Unable to support null keys or values");
        }
        if (this.maxByteCapacity != -1L && !(object2 instanceof Sized)) {
            throw new ClassCastException("Unable to add object not of type Sized when byteCapacity has been set");
        }
        if (this.maxBytePerObject != -1L && !(object2 instanceof Sized)) {
            throw new ClassCastException("Unable to add object not of type Sized when maxByteSize has been set");
        }
        long l = 0L;
        if (object2 instanceof Sized) {
            l = ((Sized)object2).byteSize();
        }
        long l2 = 0L;
        long l3 = 0L;
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Object object4 = null;
        Object object5 = this;
        synchronized (object5) {
            l2 = this.bytes;
            n = this.size();
            n2 = n + 1;
            bl2 = n == 0;
            bl3 = n2 == 0;
            l3 = this.bytes + l;
            bl4 = this.isFull();
            boolean bl6 = bl5 = this.maxCapacity > 0 && n2 >= this.maxCapacity || this.maxByteCapacity > 0L && l3 >= this.maxByteCapacity;
            if (this.enforceLimits && this.maxBytePerObject != -1L && l > this.maxBytePerObject) {
                throw new OutOfLimitsException(2, new Long(l), new Long(this.maxBytePerObject));
            }
            if (this.enforceLimits && this.maxCapacity != -1 && this.maxCapacity - n2 < 0) {
                throw new OutOfLimitsException(0, new Integer(n2), new Integer(this.maxCapacity));
            }
            if (this.enforceLimits && this.maxByteCapacity != -1L && this.maxByteCapacity - l3 < 0L) {
                throw new OutOfLimitsException(1, new Long(l3), new Long(this.maxByteCapacity));
            }
            this.bytes = l3;
            if (!bl && super.get(object) != null) {
                throw new IllegalStateException("Message exist in the store");
            }
            object4 = super.put(object, object2);
            if (object4 != null && object4 instanceof Sized) {
                this.bytes -= ((Sized)object4).byteSize();
            }
        }
        object5 = this.limitLock;
        synchronized (object5) {
            if (n2 > this.highWaterCnt) {
                this.highWaterCnt = n2;
            }
            if (l > this.largestMessageHighWater) {
                this.largestMessageHighWater = l;
            }
            if (this.bytes > this.highWaterBytes) {
                this.highWaterBytes = this.bytes;
            }
            this.averageCount = ((float)this.numberSamples * this.averageCount + (float)n2) / ((float)this.numberSamples + 1.0f);
            this.averageBytes = ((double)this.numberSamples * this.averageBytes + (double)l3) / ((double)this.numberSamples + 1.0);
            this.messageAverage = ((double)this.numberSamples * this.messageAverage + (double)l) / ((double)this.numberSamples + 1.0);
            ++this.numberSamples;
        }
        if (this.comparatorSets != null && !this.comparatorSets.isEmpty()) {
            object5 = this.comparatorSets;
            synchronized (object5) {
                iterator = this.comparatorSets.values().iterator();
                while (iterator.hasNext()) {
                    object3 = (Set)iterator.next();
                    if (object3 != null) {
                        Set set = object3;
                        synchronized (set) {
                            object3.add(object2);
                            continue;
                        }
                    }
                    iterator.remove();
                }
            }
        }
        if (this.filterMaps != null && !this.filterMaps.isEmpty()) {
            object5 = this.filterMaps;
            synchronized (object5) {
                iterator = this.filterMaps.values().iterator();
                while (iterator.hasNext()) {
                    object3 = (FilterMap)iterator.next();
                    if (object3 != null && (((FilterMap)object3).getFilter() == null || ((FilterMap)object3).getFilter().matches(object2))) {
                        ((HashMap)object3).put(object, object2);
                        continue;
                    }
                    if (object3 != null) continue;
                    iterator.remove();
                }
            }
        }
        if (this.hasListeners(EventType.SIZE_CHANGED) && n != n2) {
            this.notifyChange(EventType.SIZE_CHANGED, new Integer(n), new Integer(n2), reason);
        }
        if (this.hasListeners(EventType.BYTES_CHANGED) && l2 != l3) {
            this.notifyChange(EventType.BYTES_CHANGED, new Long(l2), new Long(l3), reason);
        }
        if (this.hasListeners(EventType.SET_CHANGED)) {
            object5 = null;
            this.newEntry.update(object, object2);
            if (object4 != null) {
                this.oldEntry.update(object, object4);
                object5 = this.oldEntry;
            }
            this.notifyChange(EventType.SET_CHANGED, object5, this.newEntry, reason);
        }
        if (this.hasListeners(EventType.EMPTY) && bl2 != bl3) {
            this.notifyChange(EventType.EMPTY, bl2, bl3, reason);
        }
        if (this.hasListeners(EventType.FULL) && bl4 != bl5) {
            this.notifyChange(EventType.FULL, bl4, bl5, reason);
        }
        return object4;
    }

    public void enforceLimits(boolean bl) {
        this.enforceLimits = bl;
    }

    public boolean getEnforceLimits() {
        return this.enforceLimits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            return super.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object, Reason reason) {
        Set set;
        Iterator iterator;
        Object var3_3 = null;
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        long l3 = 0L;
        Object object2 = this;
        synchronized (object2) {
            var3_3 = super.remove(object);
            if (var3_3 == null) {
                return null;
            }
            if (var3_3 instanceof Sized) {
                l3 = ((Sized)var3_3).byteSize();
            }
            l = this.bytes;
            n = this.size() + 1;
            n2 = n - 1;
            bl = n == 0;
            bl2 = n2 == 0;
            l2 = this.bytes - l3;
            bl3 = this.maxCapacity > 0 && n >= this.maxCapacity || this.maxByteCapacity > 0L && l >= this.maxByteCapacity;
            bl4 = this.maxCapacity > 0 && n2 >= this.maxCapacity || this.maxByteCapacity > 0L && l2 >= this.maxByteCapacity;
            this.bytes = l2;
        }
        if (this.hasListeners(EventType.SET_CHANGED_REQUEST)) {
            this.notifyChange(EventType.SET_CHANGED_REQUEST, var3_3, null, reason);
        }
        object2 = this.limitLock;
        synchronized (object2) {
            this.averageCount = ((float)this.numberSamples * this.averageCount + (float)n2) / ((float)this.numberSamples + 1.0f);
            this.averageBytes = ((double)this.numberSamples * this.averageBytes + (double)l2) / ((double)this.numberSamples + 1.0);
            this.messageAverage = ((double)this.numberSamples * this.messageAverage + (double)l3) / ((double)this.numberSamples + 1.0);
            ++this.numberSamples;
        }
        if (this.comparatorSets != null && !this.comparatorSets.isEmpty()) {
            object2 = this.comparatorSets;
            synchronized (object2) {
                iterator = this.comparatorSets.values().iterator();
                while (iterator.hasNext()) {
                    set = (Set)iterator.next();
                    if (set != null) {
                        Set set2 = set;
                        synchronized (set2) {
                            set.remove(var3_3);
                            continue;
                        }
                    }
                    iterator.remove();
                }
            }
        }
        if (this.filterMaps != null && !this.filterMaps.isEmpty()) {
            object2 = this.filterMaps;
            synchronized (object2) {
                iterator = this.filterMaps.values().iterator();
                while (iterator.hasNext()) {
                    set = (Set)iterator.next();
                    if (set != null) {
                        set.remove(object);
                        continue;
                    }
                    iterator.remove();
                }
            }
        }
        if (this.hasListeners(EventType.SIZE_CHANGED) && n != n2) {
            this.notifyChange(EventType.SIZE_CHANGED, new Integer(n), new Integer(n2), reason);
        }
        if (this.hasListeners(EventType.BYTES_CHANGED) && l != l2) {
            this.notifyChange(EventType.BYTES_CHANGED, new Long(l), new Long(l2), reason);
        }
        if (this.hasListeners(EventType.SET_CHANGED) && var3_3 != null) {
            object2 = this.oldEntry;
            this.oldEntry.update(object, var3_3);
            iterator = null;
            this.notifyChange(EventType.SET_CHANGED, object2, iterator, reason);
        }
        if (this.hasListeners(EventType.EMPTY) && bl != bl2) {
            this.notifyChange(EventType.EMPTY, bl, bl2, reason);
        }
        if (this.hasListeners(EventType.FULL) && bl3 != bl4) {
            this.notifyChange(EventType.FULL, bl3, bl4, reason);
        }
        return var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAll(Filter filter) {
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            HashMap hashMap = new HashMap();
            Set set = this.entrySet();
            for (Map.Entry entry : set) {
                Object v = entry.getValue();
                if (filter != null && !filter.matches(v)) continue;
                hashMap.put(entry.getKey(), v);
            }
            return hashMap;
        }
    }

    public Object addEventListener(EventListener eventListener, EventType eventType, Object object) {
        return this.ebh.addEventListener(eventListener, eventType, object);
    }

    public Object addEventListener(EventListener eventListener, EventType eventType, Reason reason, Object object) {
        return this.ebh.addEventListener(eventListener, eventType, reason, object);
    }

    public Object removeEventListener(Object object) {
        return this.ebh.removeEventListener(object);
    }

    protected boolean hasListeners(EventType eventType) {
        return this.ebh.hasListeners(eventType);
    }

    protected void notifyChange(EventType eventType, Object object, Object object2, Reason reason) {
        this.ebh.notifyChange(eventType, reason, this, object, object2);
    }

    public void setMaxByteSize(long l) {
        if (l < -1L) {
            l = -1L;
        }
        this.maxBytePerObject = l;
    }

    public long maxByteSize() {
        return this.maxBytePerObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCapacity(int n) {
        if (n < -1) {
            n = -1;
        }
        if (!this.hasListeners(EventType.FULL)) {
            this.maxCapacity = n;
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            bl = this.isFull();
            this.maxCapacity = n;
            bl2 = this.isFull();
        }
        if (bl != bl2) {
            this.notifyChange(EventType.FULL, bl, bl2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setByteCapacity(long l) {
        if (l < -1L) {
            l = -1L;
        }
        if (!this.hasListeners(EventType.FULL)) {
            this.maxByteCapacity = l;
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            bl = this.isFull();
            this.maxByteCapacity = l;
            bl2 = this.isFull();
        }
        if (bl != bl2) {
            this.notifyChange(EventType.FULL, bl, bl2, null);
        }
    }

    public int capacity() {
        return this.maxCapacity;
    }

    public long byteCapacity() {
        return this.maxByteCapacity;
    }

    public boolean isFull() {
        return this.maxCapacity > 0 && this.size() >= this.maxCapacity || this.maxByteCapacity > 0L && this.bytes >= this.maxByteCapacity;
    }

    public int freeSpace() {
        if (this.maxCapacity == -1) {
            return -1;
        }
        int n = this.maxCapacity - this.size();
        if (n < 0) {
            return 0;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long freeBytes() {
        if (this.maxByteCapacity == -1L) {
            return -1L;
        }
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            long l = this.maxByteCapacity - this.bytes;
            if (l < 0L) {
                return 0L;
            }
            return l;
        }
    }

    public long byteSize() {
        return this.bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            return super.size();
        }
    }

    public int highWaterCount() {
        return this.highWaterCnt;
    }

    public long highWaterBytes() {
        return this.highWaterBytes;
    }

    public long highWaterLargestMessageBytes() {
        return this.largestMessageHighWater;
    }

    public float averageCount() {
        return this.averageCount;
    }

    public double averageBytes() {
        return this.averageBytes;
    }

    public double averageMessageBytes() {
        return this.messageAverage;
    }

    static class NLMapEntry
    implements Map.Entry {
        Object key = null;
        Object value = null;

        public void update(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return (entry.getKey() == this.key || this.key != null && this.key.equals(entry.getKey())) && (entry.getValue() == this.value || this.value != null && this.value.equals(entry.getValue()));
            }
            return false;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException("Can not set values on the entry");
        }
    }
}

