/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.util;

import com.qbrowser.container.MessageContainer;
import com.qbrowser.localstore.LocalMessageContainer;
import com.qbrowser.localstore.genericdest.LocalQueue;
import com.qbrowser.localstore.genericdest.LocalTopic;
import com.qbrowser.property.Property;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QBrowserUtil {
    private static String[] pad = new String[]{"", "0", "00", "000", "0000"};
    static JDialog errDialog = null;
    private static JPanel panel_parent;

    public static void setPanel_Parent(JPanel value) {
        panel_parent = value;
    }

    public static void cleanupPassFile() {
        File the_pass_file = new File(QBrowserUtil.getTargetPassfilePath());
        the_pass_file = the_pass_file.exists() ? the_pass_file : null;
        if (the_pass_file != null) {
            try {
                the_pass_file.delete();
                return;
            }
            catch (Throwable thex) {
                System.err.println(thex.getMessage());
            }
        }
    }

    public static int getVersionAsInt() {
        String versionString = System.getProperty("java.version");
        int firstDot = versionString.indexOf(".");
        String tensString = versionString.substring(0, firstDot);
        int nextDot = versionString.indexOf(".", firstDot + 1);
        if (nextDot < 0) {
            nextDot = versionString.length();
        }
        String onesString = versionString.substring(firstDot + 1, nextDot);
        int version2 = -1;
        try {
            int tens = new Integer(tensString);
            int ones = new Integer(onesString);
            version2 = tens * 10 + ones;
        }
        catch (NumberFormatException numberFormatException) {}
        return version2;
    }

    public static void createPassfile(String password) {
        try {
            File targetps = new File(QBrowserUtil.getQBrowserTempFileDir());
            targetps.mkdirs();
            File targetpassfile = new File(QBrowserUtil.getTargetPassfilePath());
            targetpassfile.createNewFile();
            PrintWriter pwr = new PrintWriter(new FileWriter(targetpassfile));
            pwr.println("imq.imqcmd.password=" + password);
            pwr.close();
            return;
        }
        catch (Exception exception) {
            Exception e = exception;
            exception.printStackTrace();
            return;
        }
    }

    public static String getQBrowserTempFileDir() {
        return System.getProperty("user.home") + File.separator + ".qbrowserv2" + File.separator;
    }

    public static String getTargetPassfilePath() {
        return QBrowserUtil.getQBrowserTempFileDir() + "passfile.txt";
    }

    public static void copy(File from, File to) throws IOException {
        FilterOutputStream out = null;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(from));
            out = new BufferedOutputStream(new FileOutputStream(to));
            Object buff = new byte[4096];
            int len = 0;
            while ((len = in.read((byte[])buff, 0, ((Object)buff).length)) >= 0) {
                ((BufferedOutputStream)out).write((byte[])buff, 0, len);
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        try {
            out.close();
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void ArrayListToJComboBox(ArrayList inputarray, JComboBox targetcombobox) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)targetcombobox.getModel();
        for (int i = 0; i < inputarray.size(); ++i) {
            boolean bl;
            String key;
            block3: {
                key = (String)inputarray.get(i);
                Serializable serializable = targetcombobox;
                String string = key;
                serializable = (DefaultComboBoxModel)((JComboBox)serializable).getModel();
                for (int j = 0; j < ((DefaultComboBoxModel)serializable).getSize(); ++j) {
                    String string2 = (String)((DefaultComboBoxModel)serializable).getElementAt(j);
                    if (!string2.trim().equals(string.trim())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            if (!bl) continue;
            model.insertElementAt(key, 0);
        }
        if (targetcombobox.getItemCount() > 0) {
            targetcombobox.setSelectedIndex(0);
        }
    }

    public static ArrayList jcomboBoxToArrayList(JComboBox inputbox) {
        ArrayList<String> targetArray = new ArrayList<String>();
        try {
            for (int i = 0; i < inputbox.getItemCount(); ++i) {
                String key = (String)inputbox.getItemAt(i);
                targetArray.add(key);
            }
        }
        catch (Throwable thex) {
            System.err.println(thex.getMessage());
        }
        return targetArray;
    }

    /*
     * Loose catch block
     */
    public static void saveHistoryToFile(String history_name, ArrayList target_history) {
        block13: {
            String targetFilePath = QBrowserUtil.getQBrowserTempFileDir() + history_name;
            String targethisfile = new File(targetFilePath);
            PrintWriter pwr = null;
            if (!((File)((Object)targethisfile)).exists()) {
                ((File)((Object)targethisfile)).createNewFile();
            }
            pwr = new PrintWriter(new FileWriter((File)((Object)targethisfile)));
            for (int i = target_history.size() - 1; i >= 0; --i) {
                String history_entry = (String)target_history.get(i);
                pwr.println(history_entry);
            }
            try {
                pwr.close();
            }
            catch (Exception i) {
                return;
            }
            catch (Exception ioe) {
                try {
                    System.err.println(ioe.getMessage());
                    if (pwr == null) break block13;
                }
                catch (Throwable throwable) {
                    if (pwr != null) {
                        try {
                            pwr.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                try {
                    pwr.close();
                }
                catch (Exception exception) {
                    return;
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArrayList getHistoryFromFile(String history_name) {
        String targetFilePath = QBrowserUtil.getQBrowserTempFileDir() + history_name;
        String ifile = new File(targetFilePath);
        ArrayList<Object> retVal = new ArrayList<Object>();
        BufferedReader br = null;
        if (((File)((Object)ifile)).exists()) {
            br = new BufferedReader(new FileReader((File)((Object)ifile)));
            String line = null;
            while ((line = br.readLine()) != null) {
                retVal.add(line);
            }
        }
        if (br == null) return retVal;
        try {
            br.close();
            return retVal;
        }
        catch (Exception line) {}
        return retVal;
        catch (Exception ex) {
            try {
                System.err.println(ex.getMessage());
                if (br == null) return retVal;
            }
            catch (Throwable throwable) {
                if (br == null) throw throwable;
                try {
                    br.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                br.close();
                return retVal;
            }
            catch (Exception exception) {}
            return retVal;
        }
    }

    /*
     * Loose catch block
     */
    public static byte[] extractBytes(String filepath) {
        Throwable throwable;
        block22: {
            Throwable retv;
            File ftest = new File(filepath);
            if (!ftest.exists()) {
                return null;
            }
            FileInputStream fi = null;
            ByteArrayOutputStream baos = null;
            fi = new FileInputStream((String)((Object)retv));
            baos = new ByteArrayOutputStream();
            Throwable buf = (Throwable)new byte[1024];
            int len = 0;
            while ((len = fi.read((byte[])buf)) != -1) {
                baos.write((byte[])buf, 0, len);
            }
            buf = (Throwable)baos.toByteArray();
            try {
                fi.close();
            }
            catch (IOException iOException) {}
            try {
                baos.close();
            }
            catch (IOException iOException) {}
            break block22;
            catch (Throwable throwable2) {
                block21: {
                    try {
                        Throwable ie = throwable2;
                        QBrowserUtil.popupErrorMessageDialog(throwable2, panel_parent);
                        Object var3_5 = null;
                        if (fi == null) break block21;
                    }
                    catch (Throwable throwable3) {
                        if (fi != null) {
                            try {
                                fi.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (baos != null) {
                            try {
                                baos.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable3;
                    }
                    try {
                        fi.close();
                    }
                    catch (IOException iOException) {}
                }
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (IOException iOException) {}
                }
                return null;
            }
        }
        return throwable;
    }

    private static String displayFloatValueKirisute(float value, int maxsyousutenketa) {
        StringBuilder result = new StringBuilder();
        Float ft = new Float(value);
        char[] chars = ft.toString().toCharArray();
        int kcount = 0;
        boolean is_syosu = false;
        for (int i = 0; chars.length > i; ++i) {
            if (chars[i] == '.') {
                is_syosu = true;
            } else if (is_syosu) {
                ++kcount;
            }
            result.append(chars[i]);
            if (kcount != 2) continue;
            return result.toString();
        }
        return result.toString();
    }

    public static String bytesLengthAsString(byte[] bytes) {
        String result = "N/A";
        boolean kbflag = false;
        try {
            float f;
            float lengthr = bytes.length;
            if (f > 1023.0f) {
                lengthr /= 1024.0f;
                kbflag = true;
            }
            if (lengthr != -1.0f) {
                result = QBrowserUtil.displayFloatValueKirisute(lengthr, 2);
            }
            if (result.endsWith(".0")) {
                result = result.substring(0, result.length() - 2);
            }
            result = kbflag ? result + " KB" : result + " byte";
        }
        catch (Exception exception) {}
        return result;
    }

    public static void addLabelAndValueComponent(GridBagConstraints valueConstraints, JPanel targetPanel, GridBagLayout valueGbag, String labelStr, Component value, int yAxis) {
        JLabel label = new JLabel(labelStr, 2);
        valueConstraints.gridx = 0;
        valueConstraints.gridy = yAxis;
        valueConstraints.weightx = 1.0;
        valueConstraints.weighty = 1.0;
        valueConstraints.anchor = 13;
        valueGbag.setConstraints(label, valueConstraints);
        targetPanel.add(label);
        valueConstraints.gridx = 1;
        valueConstraints.gridy = yAxis;
        valueConstraints.weightx = 1.0;
        valueConstraints.weighty = 1.0;
        valueConstraints.anchor = 17;
        valueGbag.setConstraints(value, valueConstraints);
        targetPanel.add(value);
    }

    public static void addRadioButtonAndValueComponent(GridBagConstraints valueConstraints, JPanel targetPanel, GridBagLayout valueGbag, JRadioButton jrb, Component value, int yAxis) {
        valueConstraints.gridx = 0;
        valueConstraints.gridy = yAxis;
        valueConstraints.weightx = 1.0;
        valueConstraints.weighty = 1.0;
        valueConstraints.anchor = 13;
        valueGbag.setConstraints(jrb, valueConstraints);
        targetPanel.add(jrb);
        valueConstraints.gridx = 1;
        valueConstraints.gridy = yAxis;
        valueConstraints.weightx = 1.0;
        valueConstraints.weighty = 1.0;
        valueConstraints.anchor = 17;
        valueGbag.setConstraints(value, valueConstraints);
        targetPanel.add(value);
    }

    public static ArrayList<String> getTargetMsgidArrayFromStringFlavor(String orig) {
        ArrayList<String> result = new ArrayList<String>();
        if (orig == null || orig.length() == 0) {
            return result;
        }
        ArrayList lines = QBrowserUtil.parseDelimitedString(orig, "\n");
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            StringTokenizer st = new StringTokenizer(line);
            int count = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (++count != 2) continue;
                result.add(token);
            }
        }
        return result;
    }

    public static ArrayList parseDelimitedString(String orig, String delim) {
        if (orig == null) {
            return null;
        }
        ArrayList<String> ar = new ArrayList<String>();
        try {
            String cur;
            int icur = 0;
            while ((icur = cur.indexOf(delim)) != -1) {
                String token = cur.substring(0, icur);
                ar.add(token);
                cur = cur.substring(icur + delim.length());
            }
            ar.add(cur);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ar;
    }

    public static void addBlankRow(GridBagConstraints valueConstraints, JPanel targetPanel, GridBagLayout valueGbag, int yAxis) {
        JLabel label = new JLabel(" ", 2);
        valueConstraints.gridx = 0;
        valueConstraints.gridy = yAxis;
        valueConstraints.weightx = 1.0;
        valueConstraints.weighty = 1.0;
        valueConstraints.anchor = 13;
        valueGbag.setConstraints(label, valueConstraints);
        targetPanel.add(label);
    }

    public static void copyMessageHeaders(Message srcmsg, Message destmsg) throws JMSException {
        destmsg.setJMSMessageID(srcmsg.getJMSMessageID());
        destmsg.setJMSDestination(srcmsg.getJMSDestination());
        destmsg.setJMSReplyTo(srcmsg.getJMSReplyTo());
        destmsg.setJMSCorrelationID(srcmsg.getJMSCorrelationID());
        destmsg.setJMSDeliveryMode(srcmsg.getJMSDeliveryMode());
        destmsg.setJMSPriority(srcmsg.getJMSPriority());
        destmsg.setJMSExpiration(srcmsg.getJMSExpiration());
        destmsg.setJMSType(srcmsg.getJMSType());
        destmsg.setJMSRedelivered(srcmsg.getJMSRedelivered());
        destmsg.setJMSTimestamp(srcmsg.getJMSTimestamp());
    }

    public static String getPureDestName(String orig) {
        int index = orig.indexOf(" :");
        if (index != -1) {
            return orig.substring(0, index);
        }
        index = orig.toLowerCase().indexOf("topic://");
        if (index != -1) {
            return orig.substring(index + 8);
        }
        index = orig.toLowerCase().indexOf("queue://");
        if (index != -1) {
            return orig.substring(index + 8);
        }
        return orig;
    }

    public static void copyMessageHeaders(ArrayList headers, Message destmsg) throws JMSException {
        for (int i = 0; i < headers.size(); ++i) {
            try {
                String jms_type;
                String colid;
                LocalQueue lq;
                LocalTopic tp;
                String destname;
                Property prop = (Property)headers.get(i);
                String key = prop.getKey();
                if (key.equals("JMSMessageID")) {
                    destmsg.setJMSMessageID(prop.getProperty_valueASString());
                    continue;
                }
                if (key.equals("JMSDestination")) {
                    destname = prop.getProperty_valueASString();
                    if (destname == null || destname.length() <= 0) continue;
                    if (destname.toLowerCase().indexOf(": topic") != -1 || destname.trim().toLowerCase().startsWith("topic://")) {
                        tp = new LocalTopic(QBrowserUtil.getPureDestName(destname));
                        destmsg.setJMSDestination((Destination)tp);
                        continue;
                    }
                    lq = new LocalQueue(QBrowserUtil.getPureDestName((String)((Object)tp)));
                    destmsg.setJMSDestination((Destination)lq);
                    continue;
                }
                if (key.equals("JMSReplyTo")) {
                    destname = ((Property)((Object)lq)).getProperty_valueASString();
                    if (destname == null || destname.length() <= 0) continue;
                    if (destname.toLowerCase().indexOf(": topic") != -1 || destname.trim().toLowerCase().startsWith("topic://")) {
                        tp = new LocalTopic(QBrowserUtil.getPureDestName(destname));
                        destmsg.setJMSReplyTo((Destination)tp);
                        continue;
                    }
                    lq = new LocalQueue(QBrowserUtil.getPureDestName((String)((Object)tp)));
                    destmsg.setJMSReplyTo((Destination)lq);
                    continue;
                }
                if (key.equals("JMSCorrelationID")) {
                    colid = ((Property)((Object)lq)).getProperty_valueASString();
                    if (colid == null || colid.length() <= 0 || colid.equals("null")) continue;
                    destmsg.setJMSCorrelationID(colid);
                    continue;
                }
                if (key.equals("JMSDeliverMode")) {
                    destmsg.setJMSDeliveryMode(((Property)((Object)colid)).getProperty_valueASInt());
                    continue;
                }
                if (key.equals("JMSPriority")) {
                    destmsg.setJMSPriority(((Property)((Object)colid)).getProperty_valueASInt());
                    continue;
                }
                if (key.equals("JMSExpiration")) {
                    destmsg.setJMSExpiration(((Property)((Object)colid)).getProperty_valueASLong());
                    continue;
                }
                if (key.equals("JMSType")) {
                    jms_type = ((Property)((Object)colid)).getProperty_valueASString();
                    if (jms_type == null || jms_type.length() <= 0 || jms_type.equals("null")) continue;
                    destmsg.setJMSType(jms_type);
                    continue;
                }
                if (key.equals("JMSRedelivered")) {
                    destmsg.setJMSRedelivered(((Property)((Object)jms_type)).getProperty_valueASBoolean());
                    continue;
                }
                if (!key.equals("JMSTimestamp")) continue;
                destmsg.setJMSTimestamp(((Property)((Object)jms_type)).getProperty_valueASLong());
                continue;
            }
            catch (Exception exception) {
                Exception ex = exception;
                exception.printStackTrace();
            }
        }
    }

    public static void copyUserProperties(Message srcmsg, Message destmsg) throws JMSException {
        if (srcmsg == null || destmsg == null) {
            return;
        }
        Enumeration enu = srcmsg.getPropertyNames();
        while (enu.hasMoreElements()) {
            String name = enu.nextElement().toString();
            Object propvalueobj = srcmsg.getObjectProperty(name);
            if (propvalueobj instanceof String) {
                destmsg.setStringProperty(name, (String)propvalueobj);
                continue;
            }
            if (propvalueobj instanceof Integer) {
                destmsg.setIntProperty(name, ((Integer)propvalueobj).intValue());
                continue;
            }
            if (propvalueobj instanceof Boolean) {
                destmsg.setBooleanProperty(name, ((Boolean)propvalueobj).booleanValue());
                continue;
            }
            if (propvalueobj instanceof Byte) {
                destmsg.setByteProperty(name, ((Byte)propvalueobj).byteValue());
                continue;
            }
            if (propvalueobj instanceof Double) {
                destmsg.setDoubleProperty(name, ((Double)propvalueobj).doubleValue());
                continue;
            }
            if (propvalueobj instanceof Float) {
                destmsg.setFloatProperty(name, ((Float)propvalueobj).floatValue());
                continue;
            }
            if (propvalueobj instanceof Long) {
                destmsg.setLongProperty(name, ((Long)propvalueobj).longValue());
                continue;
            }
            if (propvalueobj instanceof Short) {
                destmsg.setShortProperty(name, ((Short)propvalueobj).shortValue());
                continue;
            }
            destmsg.setObjectProperty(name, propvalueobj);
        }
    }

    public static void populateHeadersOfLocalMessageContainer(ArrayList headers, LocalMessageContainer destmsg) throws JMSException {
        ArrayList<Property> additional = new ArrayList<Property>();
        for (int i = 0; i < headers.size(); ++i) {
            try {
                String jms_type;
                String colid;
                LocalQueue lq;
                LocalTopic tp;
                String destname;
                Property prop = (Property)headers.get(i);
                String key = prop.getKey();
                if (key.equals("JMSMessageID")) {
                    destmsg.setVmsgid(prop.getProperty_valueASString());
                    continue;
                }
                if (key.equals("JMSDestination")) {
                    destname = prop.getProperty_valueASString();
                    if (destname == null || destname.length() <= 0) continue;
                    if (destname.toLowerCase().indexOf(": topic") != -1 || destname.trim().toLowerCase().startsWith("topic://")) {
                        tp = new LocalTopic(QBrowserUtil.getPureDestName(destname));
                        destmsg.setVdest(tp);
                        continue;
                    }
                    lq = new LocalQueue(QBrowserUtil.getPureDestName((String)((Object)tp)));
                    destmsg.setVdest(lq);
                    continue;
                }
                if (key.equals("JMSReplyTo")) {
                    destname = ((Property)((Object)lq)).getProperty_valueASString();
                    if (destname == null || destname.length() <= 0) continue;
                    if (destname.toLowerCase().indexOf(": topic") != -1 || destname.trim().toLowerCase().startsWith("topic://")) {
                        tp = new LocalTopic(QBrowserUtil.getPureDestName(destname));
                        destmsg.setVreplyto(tp);
                        continue;
                    }
                    lq = new LocalQueue(QBrowserUtil.getPureDestName((String)((Object)tp)));
                    destmsg.setVreplyto(lq);
                    continue;
                }
                if (key.equals("JMSCorrelationID")) {
                    colid = ((Property)((Object)lq)).getProperty_valueASString();
                    if (colid == null || colid.length() <= 0 || colid.equals("null")) continue;
                    destmsg.setVcorrelationid(colid);
                    continue;
                }
                if (key.equals("JMSDeliverMode")) {
                    destmsg.setVdeliverymode(((Property)((Object)colid)).getProperty_valueASInt());
                    continue;
                }
                if (key.equals("JMSPriority")) {
                    destmsg.setVpriority(((Property)((Object)colid)).getProperty_valueASInt());
                    continue;
                }
                if (key.equals("JMSExpiration")) {
                    destmsg.setVexpiration(((Property)((Object)colid)).getProperty_valueASLong());
                    continue;
                }
                if (key.equals("JMSType")) {
                    jms_type = ((Property)((Object)colid)).getProperty_valueASString();
                    if (jms_type == null || jms_type.length() <= 0 || jms_type.equals("null")) continue;
                    destmsg.setVjms_type(jms_type);
                    continue;
                }
                if (key.equals("JMSRedelivered")) {
                    destmsg.setVredelivered(((Property)((Object)jms_type)).getProperty_valueASBoolean());
                    continue;
                }
                if (key.equals("JMSTimestamp")) {
                    destmsg.setVtimestamp(((Property)((Object)jms_type)).getProperty_valueASLong());
                    continue;
                }
                additional.add((Property)((Object)jms_type));
                continue;
            }
            catch (Exception exception) {
                Exception ex = exception;
                exception.printStackTrace();
            }
        }
        destmsg.setAdditionalHeaders(additional);
    }

    public static void populateHeadersOfLocalMessageContainer(Message srcmsg, LocalMessageContainer destmsg) throws JMSException {
        destmsg.setMessage(srcmsg);
        destmsg.setVmsgid(srcmsg.getJMSMessageID());
        destmsg.setVdest(srcmsg.getJMSDestination());
        destmsg.setVreplyto(srcmsg.getJMSReplyTo());
        destmsg.setVcorrelationid(srcmsg.getJMSCorrelationID());
        destmsg.setVdeliverymode(srcmsg.getJMSDeliveryMode());
        destmsg.setVpriority(srcmsg.getJMSPriority());
        destmsg.setVexpiration(srcmsg.getJMSExpiration());
        destmsg.setVjms_type(srcmsg.getJMSType());
        destmsg.setVredelivered(srcmsg.getJMSRedelivered());
        destmsg.setVtimestamp(srcmsg.getJMSTimestamp());
    }

    public static void populateHeadersOfLocalMessageContainer(LocalMessageContainer srcmsg, LocalMessageContainer destmsg) throws JMSException {
        destmsg.setMessage(srcmsg.getMessage());
        destmsg.setMessage_type(srcmsg.getMessage_type());
        destmsg.setBody_size(srcmsg.getBody_size());
        destmsg.setReal_file_path(srcmsg.getReal_file_path());
        destmsg.setVmsgid(srcmsg.getVmsgid());
        destmsg.setVdest(srcmsg.getVdest());
        destmsg.setVreplyto(srcmsg.getVreplyto());
        destmsg.setVcorrelationid(srcmsg.getVcorrelationid());
        destmsg.setVdeliverymode(srcmsg.getVdeliverymode());
        destmsg.setVpriority(srcmsg.getVpriority());
        destmsg.setVexpiration(srcmsg.getVexpiration());
        destmsg.setVjms_type(srcmsg.getVjms_type());
        destmsg.setVredelivered(srcmsg.isVredelivered());
        destmsg.setVtimestamp(srcmsg.getVtimestamp());
        destmsg.setAdditionalHeaders(srcmsg.getAdditionalHeaders());
    }

    public static void populateHeadersOfLocalMessageContainer2(LocalMessageContainer srcmsg, LocalMessageContainer destmsg) throws JMSException {
        destmsg.setMessage(srcmsg.getMessage());
        destmsg.setMessage_type(srcmsg.getMessage_type());
        destmsg.setReal_file_path(srcmsg.getReal_file_path());
        destmsg.setVmsgid(srcmsg.getVmsgid());
        destmsg.setVdest(srcmsg.getVdest());
        destmsg.setVreplyto(srcmsg.getVreplyto());
        destmsg.setVcorrelationid(srcmsg.getVcorrelationid());
        destmsg.setVdeliverymode(srcmsg.getVdeliverymode());
        destmsg.setVpriority(srcmsg.getVpriority());
        destmsg.setVexpiration(srcmsg.getVexpiration());
        destmsg.setVjms_type(srcmsg.getVjms_type());
        destmsg.setVredelivered(srcmsg.isVredelivered());
        destmsg.setVtimestamp(srcmsg.getVtimestamp());
        destmsg.setAdditionalHeaders(srcmsg.getAdditionalHeaders());
    }

    public static String getMessageTypeFromRealFilePath(String filepath) {
        if (filepath == null) {
            return null;
        }
        if (filepath.indexOf("_TextMessage") != -1) {
            return "TextMessage";
        }
        if (filepath.indexOf("_BytesMessage") != -1) {
            return "BytesMessage";
        }
        if (filepath.indexOf("_MapMessage") != -1) {
            return "MapMessage";
        }
        if (filepath.indexOf("_StreamMessage") != -1) {
            return "StreamMessage";
        }
        if (filepath.indexOf("_ObjectMessage") != -1) {
            return "ObjectMessage";
        }
        if (filepath.indexOf("_Message") != -1) {
            return "Message";
        }
        return null;
    }

    public static void populateHeadersOfLocalMessageContainer(MessageContainer srcmsg, LocalMessageContainer destmsg) throws JMSException {
        destmsg.setMessage(srcmsg.getMessage());
        destmsg.setVmsgid(srcmsg.getVmsgid());
        destmsg.setVdest(srcmsg.getVdest());
        destmsg.setVreplyto(srcmsg.getVreplyto());
        destmsg.setVcorrelationid(srcmsg.getVcorrelationid());
        destmsg.setVdeliverymode(srcmsg.getVdeliverymode());
        destmsg.setVpriority(srcmsg.getVpriority());
        destmsg.setVexpiration(srcmsg.getVexpiration());
        destmsg.setVjms_type(srcmsg.getVjms_type());
        destmsg.setVredelivered(srcmsg.isVredelivered());
        destmsg.setVtimestamp(srcmsg.getVtimestamp());
        destmsg.setAdditionalHeaders(srcmsg.getAdditionalHeaders());
    }

    public static void copyUserProperties(ArrayList userprops, Message message) {
        for (int i = 0; i < userprops.size(); ++i) {
            try {
                Property userprop = (Property)userprops.get(i);
                String key = userprop.getKey();
                switch (userprop.validated_type) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        message.setStringProperty(key, userprop.getProperty_valueASString());
                        break;
                    }
                    case 3: {
                        message.setBooleanProperty(key, userprop.getProperty_valueASBoolean());
                        break;
                    }
                    case 2: {
                        message.setIntProperty(key, userprop.getProperty_valueASInt());
                        break;
                    }
                    case 4: {
                        message.setByteProperty(key, userprop.getProperty_valueASByte());
                        break;
                    }
                    case 5: {
                        message.setDoubleProperty(key, userprop.getProperty_valueASDouble());
                        break;
                    }
                    case 6: {
                        message.setFloatProperty(key, userprop.getProperty_valueASFloat());
                        break;
                    }
                    case 7: {
                        message.setLongProperty(key, userprop.getProperty_valueASLong());
                        break;
                    }
                    case 8: {
                        message.setShortProperty(key, userprop.getProperty_valueASShort());
                    }
                }
                continue;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public static String toHexDump(byte[] buf, int length) {
        if (buf.length % 2 != 0) {
            byte[] newarray = new byte[buf.length + 1];
            System.arraycopy(buf, 0, newarray, 0, buf.length);
            buf = newarray;
        }
        StringBuffer sb = new StringBuffer(buf.length << 1);
        int n = 0;
        while (n < buf.length && n < length) {
            int value = buf[n + 1] & 0xFF;
            String s = Integer.toHexString(value |= buf[n] << 8 & 0xFF00);
            sb.append(pad[4 - s.length()]);
            sb.append(s);
            if ((n += 2) % 16 == 0) {
                sb.append("\n");
                continue;
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    public static void popupErrorMessageDialog(Throwable e, JComponent parent) {
        if (errDialog != null && errDialog.isShowing()) {
            errDialog.dispose();
        }
        errDialog = new JDialog();
        errDialog.setLocation(120, 120);
        TextArea ta = new TextArea("", 10, 50, 3);
        ta.setEditable(true);
        ta.append(e.getMessage());
        ta.append("\n");
        ta.append(e.toString());
        Serializable mainmsg = new JPanel();
        ((Container)mainmsg).add(ta);
        errDialog.getContentPane().setLayout(new BorderLayout());
        JButton confirmbutton = new JButton("OK");
        confirmbutton.addActionListener(new ErrorConfirmedListener());
        JPanel buttonpanel = new JPanel();
        buttonpanel.setLayout(new BorderLayout());
        buttonpanel.add("East", confirmbutton);
        errDialog.getContentPane().add("South", buttonpanel);
        errDialog.getContentPane().add("North", (Component)mainmsg);
        errDialog.pack();
        errDialog.setLocationRelativeTo(parent);
        errDialog.setVisible(true);
    }

    public static String eliminateEndFileSeparator(String orig) {
        if (orig == null) {
            return null;
        }
        if (orig.endsWith(File.separator)) {
            return orig.substring(0, orig.length() - 1);
        }
        return orig;
    }

    public static String eliminateDameMoji(String orig) {
        if (orig == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Object chars = orig.toCharArray();
        for (int i = 0; i < ((Object)chars).length; ++i) {
            if (chars[i] == 92 || chars[i] == 47 || chars[i] == 58 || chars[i] == 42 || chars[i] == 63 || chars[i] == 34 || chars[i] == 60 || chars[i] == 62 || chars[i] == 124) continue;
            sb.append((char)chars[i]);
        }
        return sb.toString();
    }

    public static long messageBodySizeOfLong(Message m) throws Exception {
        Message message;
        Message temp2;
        if (m instanceof TextMessage) {
            long result = 0L;
            try {
                temp2 = (TextMessage)m;
                result = temp2.getText().length();
                if (result == 0L && temp2.getText().length() != 0) {
                    result = 1L;
                }
            }
            catch (Exception temp2) {
                // empty catch block
            }
            return result;
        }
        if (temp2 instanceof BytesMessage) {
            long result = 0L;
            try {
                temp2 = (BytesMessage)temp2;
                result = temp2.getBodyLength();
                if (result == 0L && temp2.getBodyLength() != 0L) {
                    result = 1L;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }
        if (message instanceof MapMessage) {
            return -1L;
        }
        if (message instanceof ObjectMessage) {
            return -1L;
        }
        if (message instanceof StreamMessage) {
            return -1L;
        }
        if (message instanceof Message) {
            return -1L;
        }
        return -1L;
    }

    public static String messageBodyLengthAsString(long lengthr) {
        String result = "N/A";
        boolean kbflag = false;
        try {
            if (lengthr > 1023L) {
                lengthr /= 1024L;
                kbflag = true;
            }
            if (lengthr != -1L) {
                result = QBrowserUtil.displayFloatValueKirisute(lengthr, 2);
            }
            if (result.endsWith(".0")) {
                result = result.substring(0, result.length() - 2);
            }
            result = kbflag ? result + " KB" : result + " byte";
        }
        catch (Exception exception) {}
        return result;
    }

    public static boolean isTopic(String title) {
        if (title == null || title.length() == 0) {
            return false;
        }
        return title.toLowerCase().indexOf(": topic") != -1 || title.trim().toLowerCase().startsWith("topic://");
    }

    public static boolean isLocalStore(String title) {
        if (title == null || title.length() == 0) {
            return false;
        }
        return title.toLowerCase().indexOf(": local_store") != -1;
    }

    static final class ErrorConfirmedListener
    implements ActionListener {
        ErrorConfirmedListener() {
        }

        public final void actionPerformed(ActionEvent e) {
            errDialog.setVisible(false);
        }
    }
}

