/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.WindowsDesktopProperty;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.FastGradientPainter;
import com.jidesoft.swing.NullPanel;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public final class JideSwingUtilities
implements SwingConstants {
    private static final boolean AA_TEXT;
    private static final boolean AA_TEXT_DEFINED;
    private static Object AA_TEXT_PROPERTY_KEY;
    static RenderingHints renderingHints;

    public static JPanel createCenterPanel(Component component) {
        NullPanel nullPanel = new NullPanel(new GridBagLayout());
        nullPanel.setOpaque(false);
        nullPanel.add(component, new GridBagConstraints());
        return nullPanel;
    }

    public static void globalCenterWindow(Window window) {
        window.setLocationRelativeTo(null);
    }

    public static void paintArrow(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        n3 = (n3 / 2 << 1) + 1;
        if (n4 == 0) {
            for (int i = 0; i < (n3 + 1) / 2; ++i) {
                graphics.drawLine(n + i, n2 + i, n + n3 - i - 1, n2 + i);
            }
        } else {
            for (int i = 0; i < (n3 + 1) / 2; ++i) {
                graphics.drawLine(n + i, n2 + i, n + i, n2 + n3 - i - 1);
            }
        }
        graphics.setColor(color2);
    }

    public static void synchronizeView(JViewport jViewport, JViewport object, int n) {
        object = new ChangeListener(jViewport, (JViewport)object, n){
            private /* synthetic */ JViewport val$masterViewport;
            private /* synthetic */ JViewport val$slaveViewport;
            private /* synthetic */ int val$orientation;
            {
                this.val$masterViewport = jViewport;
                this.val$slaveViewport = jViewport2;
                this.val$orientation = n;
            }

            public final void stateChanged(ChangeEvent object) {
                block8: {
                    object = this.val$masterViewport.getSize();
                    if (((Dimension)object).width == 0 || ((Dimension)object).height == 0) {
                        return;
                    }
                    object = this.val$slaveViewport.getClientProperty("synchronizeViewChangeListener");
                    try {
                        if (object instanceof ChangeListener) {
                            this.val$slaveViewport.removeChangeListener((ChangeListener)object);
                        }
                        if (this.val$orientation == 0) {
                            Point point = this.val$masterViewport.getViewPosition();
                            Point point2 = this.val$slaveViewport.getViewPosition();
                            if (point.x != point2.x) {
                                this.val$slaveViewport.setViewPosition(new Point(point.x, point2.y));
                            }
                            break block8;
                        }
                        if (this.val$orientation != 1) break block8;
                        Point point = this.val$masterViewport.getViewPosition();
                        Point point3 = this.val$slaveViewport.getViewPosition();
                        if (point.y == point3.y) break block8;
                        this.val$slaveViewport.setViewPosition(new Point(point3.x, point.y));
                    }
                    catch (Throwable throwable) {
                        if (object instanceof ChangeListener) {
                            this.val$slaveViewport.addChangeListener((ChangeListener)object);
                        }
                        throw throwable;
                    }
                }
                if (object instanceof ChangeListener) {
                    this.val$slaveViewport.addChangeListener((ChangeListener)object);
                    return;
                }
            }
        };
        jViewport.addChangeListener((ChangeListener)object);
        jViewport.putClientProperty("synchronizeViewChangeListener", object);
    }

    public static int getButtonState(AbstractButton abstractButton) {
        ButtonModel buttonModel = abstractButton.getModel();
        if (!buttonModel.isEnabled()) {
            if (buttonModel.isSelected()) {
                return 5;
            }
            return 4;
        }
        if (buttonModel.isPressed() && buttonModel.isArmed()) {
            if (buttonModel.isRollover()) {
                return 1;
            }
            if (buttonModel.isSelected()) {
                return 3;
            }
        } else {
            if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                if (buttonModel.isSelected()) {
                    return 1;
                }
                return 2;
            }
            if (buttonModel.isSelected()) {
                return 3;
            }
            if (abstractButton.hasFocus() && abstractButton.isFocusPainted()) {
                if (buttonModel.isSelected()) {
                    return 1;
                }
                return 2;
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean equals(Object object, Object object2) {
        boolean bl = false;
        Object object3 = object;
        if (object3 == object2) {
            return true;
        }
        if (object3 != null && object2 == null) {
            return false;
        }
        if (object3 == null) {
            return false;
        }
        if (object3 instanceof Comparable && object2 instanceof Comparable && object3.getClass().isAssignableFrom(object2.getClass())) {
            if (((Comparable)object3).compareTo(object2) != 0) return false;
            return true;
        }
        if (object3 instanceof Comparable && object2 instanceof Comparable && object2.getClass().isAssignableFrom(object3.getClass())) {
            if (((Comparable)object2).compareTo(object3) != 0) return false;
            return true;
        }
        boolean bl2 = object3.equals(object2);
        return bl2;
    }

    public static boolean shouldUseSystemFont() {
        boolean bl;
        String string = SecurityUtils.getProperty("jide.useSystemfont", "");
        if ("false".equals(string)) {
            return false;
        }
        if ("true".equals(string)) {
            return true;
        }
        if (SystemInfo.isJdk15Above() || SystemInfo.isCJKLocale()) {
            return true;
        }
        string = null;
        try {
            string = (String)AccessController.doPrivileged(new GetPropertyAction("swing.useSystemFontSettings"));
        }
        catch (AccessControlException accessControlException) {}
        if (bl = string != null && Boolean.valueOf(string) != false) {
            Object object = UIDefaultsLookup.get("Application.useSystemFontSettings");
            boolean bl2 = bl = object != null || Boolean.TRUE.equals(object);
        }
        return "true".equals(SecurityUtils.getProperty("defaultFont", "false")) || bl;
    }

    public static void setRecursively(Component component, Handler handler) {
        JideSwingUtilities.setRecursively0(component, handler);
    }

    private static void setRecursively0(Component componentArray, Handler handler) {
        int n;
        if (handler.condition((Component)componentArray)) {
            handler.action((Component)componentArray);
        }
        if (handler instanceof ConditionHandler && ((ConditionHandler)handler).stopCondition$1a09a617()) {
            return;
        }
        Component[] componentArray2 = null;
        if (componentArray instanceof JMenu) {
            componentArray2 = ((JMenu)componentArray).getMenuComponents();
        } else if (componentArray instanceof JTabbedPane) {
            componentArray = (JTabbedPane)componentArray;
            componentArray2 = new Component[componentArray.getTabCount()];
            for (n = 0; n < componentArray2.length; ++n) {
                componentArray2[n] = componentArray.getComponentAt(n);
            }
        } else if (componentArray instanceof Container) {
            componentArray2 = ((Container)componentArray).getComponents();
        }
        if (componentArray2 != null) {
            componentArray = componentArray2;
            n = componentArray2.length;
            for (int i = 0; i < n; ++i) {
                Component component = componentArray[i];
                JideSwingUtilities.setRecursively0(component, handler);
            }
        }
    }

    private static Component getRecursively0(Component componentArray, GetHandler getHandler) {
        if (getHandler.condition((Component)componentArray)) {
            return getHandler.action((Component)componentArray);
        }
        Component[] componentArray2 = null;
        if (componentArray instanceof JMenu) {
            componentArray2 = ((JMenu)componentArray).getMenuComponents();
        } else if (componentArray instanceof Container) {
            componentArray2 = ((Container)componentArray).getComponents();
        }
        if (componentArray2 != null) {
            componentArray = componentArray2;
            int n = componentArray2.length;
            for (int i = 0; i < n; ++i) {
                Component component = componentArray[i];
                if ((component = JideSwingUtilities.getRecursively0(component, getHandler)) == null) continue;
                return component;
            }
        }
        return null;
    }

    public static Dimension getPreferredButtonSize(AbstractButton serializable, int n, boolean bl) {
        if (serializable.getComponentCount() > 0) {
            return null;
        }
        Icon icon = serializable.getIcon();
        String string = serializable.getText();
        Serializable serializable2 = serializable.getFont();
        serializable2 = serializable.getFontMetrics((Font)serializable2);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        JideSwingUtilities.layoutCompoundLabel(serializable, (FontMetrics)serializable2, string, icon, true, serializable.getVerticalAlignment(), serializable.getHorizontalAlignment(), serializable.getVerticalTextPosition(), serializable.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, string == null ? 0 : n);
        Rectangle rectangle4 = rectangle.union(rectangle2);
        serializable = serializable.getInsets();
        rectangle4.width += ((Insets)serializable).left + ((Insets)serializable).right;
        rectangle4.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        return rectangle4.getSize();
    }

    /*
     * WARNING - void declaration
     */
    public static String layoutCompoundLabel(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, boolean bl, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        void string2;
        int n6;
        void var10_17;
        void var9_16;
        int n7;
        int n8;
        int n9;
        int n10;
        boolean n15 = true;
        int n11 = n10;
        int n12 = n9;
        if (jComponent != null && !jComponent.getComponentOrientation().isLeftToRight()) {
            n15 = false;
        }
        switch (n10) {
            case 10: {
                n11 = n15 ? 2 : 4;
                break;
            }
            case 11: {
                n11 = n15 ? 4 : 2;
            }
        }
        switch (n9) {
            case 10: {
                n12 = n15 ? 2 : 4;
                break;
            }
            case 11: {
                n12 = n15 ? 4 : 2;
            }
        }
        n9 = n12;
        n10 = n11;
        boolean bl2 = bl;
        if (bl2) {
            int n82;
            int n92;
            void v0 = n8;
            int n13 = n10;
            void v2 = n7;
            void v3 = var9_16;
            void v4 = var10_17;
            void n17 = n6;
            var10_17 = string2;
            var9_16 = v4;
            void var8_15 = v3;
            n7 = n9;
            n10 = v2;
            n8 = n13;
            void var4_10 = v0;
            if (icon != null) {
                var9_16.width = icon.getIconWidth();
                var9_16.height = icon.getIconHeight();
            } else {
                var9_16.height = 0;
                var9_16.width = 0;
            }
            n6 = string == null || string.equals("") ? 1 : 0;
            View n18 = null;
            if (n6 != 0) {
                var10_17.height = 0;
                var10_17.width = 0;
                string = "";
            } else {
                n18 = jComponent != null ? (View)jComponent.getClientProperty("html") : null;
                if (n18 != null) {
                    var10_17.width = (int)n18.getPreferredSpan(0);
                    var10_17.height = (int)n18.getPreferredSpan(1);
                } else {
                    var10_17.width = SwingUtilities.computeStringWidth(fontMetrics, string);
                    var10_17.height = fontMetrics.getHeight();
                }
            }
            int n14 = n92 = n6 != 0 || icon == null ? 0 : n17;
            if (n6 == 0 && var10_17.width > (n82 = n7 == 0 ? var8_15.width : var8_15.width - (var9_16.width + n92))) {
                if (n18 != null) {
                    var10_17.width = n82;
                } else {
                    int n16;
                    String string3 = "...";
                    n6 = SwingUtilities.computeStringWidth(fontMetrics, string3);
                    for (n16 = 0; n16 < string.length() && (n6 += fontMetrics.charWidth(string.charAt(n16))) <= n82; ++n16) {
                    }
                    string = string.substring(0, n16) + string3;
                    var10_17.width = SwingUtilities.computeStringWidth(fontMetrics, string);
                }
            }
            var10_17.y = n10 == 1 ? (n7 != 0 ? 0 : -(var10_17.height + n92)) : (n10 == 0 ? (var9_16.height >> 1) - (var10_17.height >> 1) : (n7 != 0 ? var9_16.height - var10_17.height : var9_16.height + n92));
            var10_17.x = n7 == 2 ? -(var10_17.width + n92) : (n7 == 0 ? (var9_16.width >> 1) - (var10_17.width >> 1) : var9_16.width + n92);
            int n16 = Math.min(var9_16.x, var10_17.x);
            int n19 = Math.max(var9_16.x + var9_16.width, var10_17.x + var10_17.width) - n16;
            n6 = Math.min(var9_16.y, var10_17.y);
            int n20 = Math.max(var9_16.y + var9_16.height, var10_17.y + var10_17.height) - n6;
            int n192 = var4_10 == true ? var8_15.y - n6 : (var4_10 == false ? var8_15.y + (var8_15.height >> 1) - (n6 + (n20 >> 1)) : var8_15.y + var8_15.height - (n6 + n20));
            n92 = n8 == 2 ? var8_15.x - n16 : (n8 == 4 ? var8_15.x + var8_15.width - (n16 + n19) : var8_15.x + (var8_15.width >> 1) - (n16 + (n19 >> 1)));
            var10_17.x += n92;
            var10_17.y += n192;
            var9_16.x += n92;
            var9_16.y += n192;
            return string;
        }
        return JideSwingUtilities.layoutCompoundLabelImplVertical(jComponent, fontMetrics, string, icon, n8, n10, n7, n9, (Rectangle)var9_16, (Rectangle)var10_17, (Rectangle)string2, n6);
    }

    private static String layoutCompoundLabelImplVertical(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        int n6;
        int n7;
        int n8;
        if (icon != null) {
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
        } else {
            rectangle2.height = 0;
            rectangle2.width = 0;
        }
        int n9 = string == null || string.equals("") ? 1 : 0;
        View view = null;
        if (n9 != 0) {
            rectangle3.height = 0;
            rectangle3.width = 0;
            string = "";
        } else {
            view = jComponent != null ? (View)jComponent.getClientProperty("html") : null;
            if (view != null) {
                rectangle3.height = (int)view.getPreferredSpan(0);
                rectangle3.width = (int)view.getPreferredSpan(1);
            } else {
                rectangle3.height = SwingUtilities.computeStringWidth(fontMetrics, string);
                rectangle3.width = fontMetrics.getHeight();
            }
        }
        int n10 = n8 = n9 != 0 || icon == null ? 0 : n5;
        if (n9 == 0 && rectangle3.height > (n7 = n4 == 0 ? rectangle.height : rectangle.height - (rectangle2.height + n8))) {
            if (view != null) {
                rectangle3.height = n7;
            } else {
                int n11;
                String string2 = "...";
                n9 = SwingUtilities.computeStringWidth(fontMetrics, string2);
                for (n11 = 0; n11 < string.length() && (n9 += fontMetrics.charWidth(string.charAt(n11))) <= n7; ++n11) {
                }
                string = string.substring(0, n11) + string2;
                rectangle3.height = SwingUtilities.computeStringWidth(fontMetrics, string);
            }
        }
        if (n3 == 1) {
            rectangle3.x = n4 != 0 ? 0 : -(rectangle3.width + n8);
        } else if (n3 == 0) {
            rectangle3.y = (rectangle2.width >> 1) - (rectangle3.width >> 1);
        } else {
            rectangle3.x = n4 != 0 ? rectangle2.width - rectangle3.width : rectangle2.width + n8;
        }
        rectangle3.y = n4 == 2 ? -(rectangle3.height + n8) : (n4 == 0 ? (rectangle2.height >> 1) - (rectangle3.height >> 1) : rectangle2.height + n8);
        int n12 = Math.min(rectangle2.y, rectangle3.y);
        n5 = Math.max(rectangle2.y + rectangle2.height, rectangle3.y + rectangle3.height) - n12;
        n9 = Math.min(rectangle2.x, rectangle3.x);
        int n13 = Math.max(rectangle2.x + rectangle2.width, rectangle3.x + rectangle3.width) - n9;
        if (n == 1) {
            n6 = rectangle.x - n9;
            n = rectangle.x + rectangle.width - (n9 + n13);
        } else if (n == 0) {
            n = n6 = rectangle.x + (rectangle.width >> 1) - (n9 + (n13 >> 1));
        } else {
            n6 = rectangle.x + rectangle.width - (n9 + n13);
            n = rectangle.x - n9;
        }
        n8 = n2 == 2 ? rectangle.y - n12 : (n2 == 4 ? rectangle.y + rectangle.height - (n12 + n5) : rectangle.y + (rectangle.height >> 1) - (n12 + (n5 >> 1)));
        rectangle3.y += n8;
        rectangle3.x += n6;
        rectangle2.y += n8;
        rectangle2.x += n;
        return string;
    }

    public static int getOrientationOf(Component serializable) {
        if (serializable instanceof Alignable) {
            return ((Alignable)((Object)serializable)).getOrientation();
        }
        if (serializable instanceof JComponent && (serializable = (Integer)((JComponent)serializable).getClientProperty("orientation")) != null) {
            return (Integer)serializable;
        }
        return 0;
    }

    public static void paintBackground(Graphics graphics, Rectangle rectangle, Color color, Color color2) {
        Color color3 = graphics.getColor();
        graphics.setColor(color2);
        graphics.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
        graphics.setColor(color);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        graphics.setColor(color3);
    }

    public static void drawStringUnderlineCharAt(JComponent serializable, Graphics graphics, String string, int n, int n2, int n3) {
        JideSwingUtilities.drawString((JComponent)serializable, graphics, string, n2, n3);
        if (n >= 0 && n < string.length()) {
            serializable = graphics.getFontMetrics();
            int n4 = ((FontMetrics)serializable).charWidth(string.charAt(n));
            graphics.fillRect(n2 += ((FontMetrics)serializable).stringWidth(string.substring(0, n)), n3 + ((FontMetrics)serializable).getDescent() - 1, n4, 1);
        }
    }

    public static void drawString(JComponent object, Graphics object2, String string, int n, int n2) {
        Boolean bl;
        if (SystemInfo.isJdk6Above()) {
            object = (Graphics2D)object2;
            object2 = null;
            if (renderingHints != null) {
                Object object3;
                object2 = null;
                Iterator<Object> iterator = renderingHints;
                Object object4 = object;
                object2 = new RenderingHints(null);
                if (iterator == null || ((RenderingHints)((Object)iterator)).size() == 0) {
                    object3 = object2;
                } else {
                    iterator = ((RenderingHints)((Object)iterator)).keySet();
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        Object object5 = iterator.next();
                        object5 = (RenderingHints.Key)object5;
                        Object object6 = ((Graphics2D)object4).getRenderingHint((RenderingHints.Key)object5);
                        ((RenderingHints)object2).put(object5, object6);
                    }
                    object3 = object2;
                }
                object2 = object3;
                ((Graphics2D)object).addRenderingHints(renderingHints);
            }
            ((Graphics2D)object).drawString(string, n, n2);
            if (object2 != null) {
                ((Graphics2D)object).addRenderingHints((Map<?, ?>)object2);
            }
            return;
        }
        JComponent jComponent = object;
        boolean bl2 = !AA_TEXT_DEFINED ? (jComponent != null ? (jComponent instanceof JComponent ? ((bl = (Boolean)jComponent.getClientProperty(AA_TEXT_PROPERTY_KEY)) != null ? bl : false) : false) : false) : AA_TEXT;
        if (bl2 && object2 instanceof Graphics2D) {
            object = (Graphics2D)object2;
            object2 = ((Graphics2D)object).getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)object).drawString(string, n, n2);
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object2);
            return;
        }
        ((Graphics)object2).drawString(string, n, n2);
    }

    public static Object setupShapeAntialiasing(Graphics graphics) {
        graphics = (Graphics2D)graphics;
        Object object = ((Graphics2D)graphics).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return object;
    }

    public static void restoreShapeAntialiasing(Graphics graphics, Object object) {
        graphics = (Graphics2D)graphics;
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    public static void fillGradient(Graphics graphics, Rectangle rectangle, int n) {
        graphics = (Graphics2D)graphics;
        Color color = new Color(255, 255, 255, 0);
        Color color2 = new Color(255, 255, 255, 48);
        Color color3 = new Color(0, 0, 0, 0);
        Color color4 = new Color(0, 0, 0, 32);
        if (n == 0) {
            JideSwingUtilities.fillGradient((Graphics2D)graphics, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height >> 1), color2, color, true);
            JideSwingUtilities.fillGradient((Graphics2D)graphics, new Rectangle(rectangle.x, rectangle.y + (rectangle.height >> 1), rectangle.width, rectangle.height >> 1), color3, color4, true);
            return;
        }
        JideSwingUtilities.fillGradient((Graphics2D)graphics, new Rectangle(rectangle.x, rectangle.y, rectangle.width >> 1, rectangle.height), color2, color, false);
        JideSwingUtilities.fillGradient((Graphics2D)graphics, new Rectangle(rectangle.x + (rectangle.width >> 1), rectangle.y, rectangle.width >> 1, rectangle.height), color3, color4, false);
    }

    public static void fillSingleGradient(Graphics graphics, Rectangle rectangle, int n, int n2) {
        graphics = (Graphics2D)graphics;
        Color color = new Color(255, 255, 255, 0);
        Color color2 = new Color(255, 255, 255, 255);
        if (n == 5) {
            JideSwingUtilities.fillGradient((Graphics2D)graphics, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), color2, color, true);
            return;
        }
        if (n == 1) {
            JideSwingUtilities.fillGradient((Graphics2D)graphics, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), color, color2, true);
            return;
        }
        if (n == 3) {
            JideSwingUtilities.fillGradient((Graphics2D)graphics, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), color2, color, false);
            return;
        }
        if (n == 7) {
            JideSwingUtilities.fillGradient((Graphics2D)graphics, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), color, color2, false);
        }
    }

    public static void installBorder(JComponent jComponent, Border border) {
        Border border2 = jComponent.getBorder();
        if (border2 == null || border2 instanceof UIResource) {
            jComponent.setBorder(border);
        }
    }

    public static void fillNormalGradient(Graphics2D graphics2D, Shape shape, Color paint, Color paint2, boolean bl) {
        Rectangle rectangle = shape.getBounds();
        paint = bl ? new GradientPaint(rectangle.x, rectangle.y, (Color)paint, rectangle.x, rectangle.height + rectangle.y, (Color)paint2, true) : new GradientPaint(rectangle.x, rectangle.y, (Color)paint, rectangle.width + rectangle.x, rectangle.y, (Color)paint2, true);
        paint2 = graphics2D.getPaint();
        graphics2D.setPaint(paint);
        graphics2D.fill(shape);
        graphics2D.setPaint(paint2);
    }

    public static void fillGradient(Graphics2D graphics2D, Shape shape, Color color, Color color2, boolean bl) {
        if ("true".equals(SecurityUtils.getProperty("normalGradientPaint", "false"))) {
            JideSwingUtilities.fillNormalGradient(graphics2D, shape, color, color2, bl);
            return;
        }
        FastGradientPainter.drawGradient(graphics2D, shape, color, color2, bl);
    }

    public static boolean passesFocusabilityTest(Component component) {
        return component != null && component.isEnabled() && component.isDisplayable() && component.isVisible() && component.isFocusable() && component.isShowing();
    }

    public static void throwInvocationTargetException(InvocationTargetException invocationTargetException) {
        if (invocationTargetException.getTargetException() instanceof RuntimeException) {
            throw (RuntimeException)invocationTargetException.getTargetException();
        }
        if (invocationTargetException.getTargetException() instanceof Error) {
            throw (Error)invocationTargetException.getTargetException();
        }
        throw new RuntimeException(invocationTargetException.getTargetException());
    }

    private static float getDefaultFontSize() {
        String string = SecurityUtils.getProperty("jide.fontSize", null);
        float f = -1.0f;
        try {
            if (string != null) {
                f = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return f;
    }

    public static Object getMenuFont(Toolkit toolkit, UIDefaults uIDefaults) {
        Font font;
        float f = JideSwingUtilities.getDefaultFontSize();
        Object object = JideSwingUtilities.shouldUseSystemFont() ? (f == -1.0f ? uIDefaults.getFont("ToolBar.font") : new WindowsDesktopProperty("win.menu.font", uIDefaults.getFont("ToolBar.font"), toolkit, f)) : ((font = uIDefaults.getFont("ToolBar.font")) == null ? SecurityUtils.createFontUIResource("Tahoma", 0, f != -1.0f ? (int)f : 11) : SecurityUtils.createFontUIResource(font.getFontName(), 0, f != -1.0f ? (int)f : 11));
        if (object == null) {
            return JideSwingUtilities.getControlFont(toolkit, uIDefaults);
        }
        return object;
    }

    public static Object getControlFont(Toolkit object, UIDefaults serializable) {
        float f = JideSwingUtilities.getDefaultFontSize();
        if (JideSwingUtilities.shouldUseSystemFont()) {
            if ((serializable = serializable.getFont("Label.font")) == null) {
                serializable = new Font("Tahoma", 0, 12);
            }
            object = f == -1.0f ? serializable : new WindowsDesktopProperty("win.defaultGUI.font", serializable, (Toolkit)object, f);
        } else {
            object = (serializable = serializable.getFont("Label.font")) == null ? SecurityUtils.createFontUIResource("Tahoma", 0, f != -1.0f ? (int)f : 11) : serializable;
        }
        return object;
    }

    public static Object getBoldFont(Toolkit object, UIDefaults serializable) {
        if (SystemInfo.isCJKLocale()) {
            return JideSwingUtilities.getControlFont((Toolkit)object, (UIDefaults)serializable);
        }
        float f = JideSwingUtilities.getDefaultFontSize();
        if (JideSwingUtilities.shouldUseSystemFont()) {
            if ((serializable = ((UIDefaults)serializable).getFont("Label.font")) == null) {
                serializable = new Font("Tahoma", 0, 12);
            }
            object = f == -1.0f ? new FontUIResource(((Font)serializable).deriveFont(1)) : new WindowsDesktopProperty("win.defaultGUI.font", serializable, (Toolkit)object, f, 1);
        } else {
            object = (serializable = ((UIDefaults)serializable).getFont("Label.font")) == null ? SecurityUtils.createFontUIResource("Tahoma", 1, f != -1.0f ? (int)f : 11) : SecurityUtils.createFontUIResource(((Font)serializable).getFontName(), 1, f != -1.0f ? (int)f : 11);
        }
        return object;
    }

    public static void drawImageBorder(Graphics graphics, ImageIcon imageIcon, Rectangle rectangle, Insets insets, boolean bl) {
        int n = insets.left;
        int n2 = insets.right;
        int n3 = insets.top;
        int n32 = insets.bottom;
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        graphics.drawImage(imageIcon.getImage(), n4, n5, n4 + n, n5 + n3, 0, 0, n, n3, null);
        graphics.drawImage(imageIcon.getImage(), n4 + n, n5, n4 + n6 - n2, n5 + n3, n, 0, imageIcon.getIconWidth() - n2, n3, null);
        graphics.drawImage(imageIcon.getImage(), n4 + n6 - n2, n5, n4 + n6, n5 + n3, imageIcon.getIconWidth() - n2, 0, imageIcon.getIconWidth(), n3, null);
        graphics.drawImage(imageIcon.getImage(), n4, n5 + n3, n4 + n, n5 + n7 - n32, 0, n3, n, imageIcon.getIconHeight() - n32, null);
        graphics.drawImage(imageIcon.getImage(), n4 + n, n5 + n3, n4 + n6 - n2, n5 + n7 - n32, n, n3, imageIcon.getIconWidth() - n2, imageIcon.getIconHeight() - n32, null);
        graphics.drawImage(imageIcon.getImage(), n4 + n6 - n2, n5 + n3, n4 + n6, n5 + n7 - n32, imageIcon.getIconWidth() - n2, n3, imageIcon.getIconWidth(), imageIcon.getIconHeight() - n32, null);
        graphics.drawImage(imageIcon.getImage(), n4, n5 + n7 - n32, n4 + n, n5 + n7, 0, imageIcon.getIconHeight() - n32, n, imageIcon.getIconHeight(), null);
        graphics.drawImage(imageIcon.getImage(), n4 + n, n5 + n7 - n32, n4 + n6 - n2, n5 + n7, n, imageIcon.getIconHeight() - n32, imageIcon.getIconWidth() - n2, imageIcon.getIconHeight(), null);
        graphics.drawImage(imageIcon.getImage(), n4 + n6 - n2, n5 + n7 - n32, n4 + n6, n5 + n7, imageIcon.getIconWidth() - n2, imageIcon.getIconHeight() - n32, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
    }

    public static boolean compositeRequestFocus(Component component) {
        if (component instanceof Container) {
            Object object;
            Object object2;
            Container container = (Container)component;
            if (container.isFocusCycleRoot() && (object2 = ((FocusTraversalPolicy)(object = container.getFocusTraversalPolicy())).getDefaultComponent(container)) != null && ((Component)object2).isShowing() && container.getComponentCount() > 0 && object2 != null) {
                ((Component)object2).requestFocus();
                return true;
            }
            object = container.getFocusCycleRootAncestor();
            if (object != null) {
                object2 = ((Container)object).getFocusTraversalPolicy();
                Component component2 = null;
                try {
                    component2 = ((FocusTraversalPolicy)object2).getComponentAfter((Container)object, container);
                }
                catch (Exception exception) {}
                if (component2 != null && SwingUtilities.isDescendingFrom(component2, container)) {
                    component2.requestFocus();
                    return true;
                }
            }
        }
        if (!JideSwingUtilities.passesFocusabilityTest(component)) {
            return false;
        }
        component.requestFocus();
        return true;
    }

    public static boolean isAncestorOfFocusOwner(Component component) {
        boolean bl = false;
        Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component == component2 || component instanceof Container && ((Container)component).isAncestorOf(component2)) {
            bl = true;
        }
        return bl;
    }

    public static void insertKeyListener(Component component, KeyListener keyListener, int n) {
        KeyListener[] keyListenerArray;
        KeyListener[] keyListenerArray2 = keyListenerArray = component.getKeyListeners();
        int n2 = keyListenerArray.length;
        for (int i = 0; i < n2; ++i) {
            KeyListener keyListener2 = keyListenerArray2[i];
            component.removeKeyListener(keyListener2);
        }
        for (int i = 0; i < keyListenerArray.length; ++i) {
            KeyListener keyListener3 = keyListenerArray[i];
            if (i == 0) {
                component.addKeyListener(keyListener);
            }
            component.addKeyListener(keyListener3);
        }
        if (0 > keyListenerArray.length - 1) {
            component.addKeyListener(keyListener);
        }
    }

    public static Component getScrollPane(Component component) {
        Component component2 = component;
        if (component instanceof JScrollPane) {
            return component;
        }
        if (component2.getParent() != null && component2.getParent().getParent() != null && component2.getParent().getParent() instanceof JScrollPane) {
            component2 = component2.getParent().getParent();
            return component2;
        }
        return null;
    }

    public static void ensureRowVisible(JTable jTable, int n) {
        Rectangle rectangle;
        Rectangle rectangle2 = jTable.getVisibleRect();
        Rectangle rectangle3 = jTable.getCellRect(n, 0, true);
        Rectangle rectangle4 = null;
        Rectangle rectangle5 = null;
        if (n < jTable.getModel().getRowCount() - 1) {
            rectangle5 = jTable.getCellRect(n + 1, 0, true);
        }
        if (n > 0) {
            rectangle4 = jTable.getCellRect(n - 1, 0, true);
        }
        n = (int)rectangle3.getMinY();
        int n2 = (int)rectangle3.getMaxY();
        int n3 = rectangle2.x;
        int n4 = rectangle2.x + rectangle2.width;
        if (rectangle4 != null) {
            n = (int)rectangle4.getMinY();
        }
        if (rectangle5 != null) {
            n2 = (int)rectangle5.getMaxY();
        }
        if (!rectangle2.contains(rectangle = new Rectangle(n3, n, n4 - n3, n2 - n)) && rectangle.height != 0) {
            jTable.scrollRectToVisible(rectangle);
        }
    }

    public static JRootPane getOutermostRootPane(Component component) {
        if (component instanceof RootPaneContainer && component.getParent() == null) {
            return ((RootPaneContainer)((Object)component)).getRootPane();
        }
        while (component != null) {
            if (component instanceof JRootPane) {
                JRootPane jRootPane = (JRootPane)component;
                if (component.getParent().getParent() == null) {
                    return jRootPane;
                }
                if (component.getParent() instanceof JDialog || component.getParent() instanceof JWindow || component.getParent() instanceof JFrame || component.getParent() instanceof JApplet) {
                    return jRootPane;
                }
                component = component.getParent().getParent();
            }
            component = SwingUtilities.getRootPane(component);
        }
        return null;
    }

    public static JComponent getFirstJComponent(RootPaneContainer object) {
        GetHandler getHandler = new GetHandler();
        object = object.getContentPane();
        return (JComponent)JideSwingUtilities.getRecursively0((Component)object, getHandler);
    }

    public static void removeFromParentWithFocusTransfer(Component component) {
        boolean bl = component.isVisible();
        component.setVisible(false);
        if (component.getParent() != null) {
            component.getParent().remove(component);
        }
        component.setVisible(bl);
    }

    public static int getLineHeight(Component serializable, int n) {
        Font font = serializable == null ? null : ((Component)serializable).getFont();
        if (font == null) {
            return 17;
        }
        serializable = ((Component)serializable).getFontMetrics(font);
        float f = ((FontMetrics)serializable).getHeight();
        return (int)(f += (float)((FontMetrics)serializable).getDescent());
    }

    public static void setTextComponentTransparent(JTextComponent jTextComponent) {
        jTextComponent.setOpaque(false);
        jTextComponent.putClientProperty("Synthetica.opaque", false);
        jTextComponent.putClientProperty("Nimbus.Overrides.InheritDefaults", false);
        jTextComponent.putClientProperty("Nimbus.Overrides", new UIDefaults());
    }

    static {
        AA_TEXT_PROPERTY_KEY = new StringBuffer("AATextPropertyKey");
        Object object = SecurityUtils.getProperty("swing.aatext", "false");
        AA_TEXT_DEFINED = object != null;
        AA_TEXT = "true".equals(object);
        renderingHints = null;
        if (SystemInfo.isJdk6Above()) {
            object = Toolkit.getDefaultToolkit();
            renderingHints = (RenderingHints)((Toolkit)object).getDesktopProperty("awt.font.desktophints");
            ((Toolkit)object).addPropertyChangeListener("awt.font.desktophints", new PropertyChangeListener(){

                public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue() instanceof RenderingHints) {
                        renderingHints = (RenderingHints)propertyChangeEvent.getNewValue();
                    }
                }
            });
        }
        Font.getFont("defaultFont");
        Font.getFont("emphasizedFont");
    }

    public static abstract class GetHandler {
        public boolean condition(Component component) {
            return component instanceof JComponent;
        }

        public Component action(Component component) {
            return component;
        }

        GetHandler() {
        }
    }

    public static interface ConditionHandler
    extends Handler {
        public boolean stopCondition$1a09a617();
    }

    public static interface Handler {
        public boolean condition(Component var1);

        public void action(Component var1);
    }

    static final class GetPropertyAction
    implements PrivilegedAction {
        private String theProp;

        public GetPropertyAction(String string) {
            this.theProp = string;
        }

        public final Object run() {
            String string = System.getProperty(this.theProp);
            if (string == null) {
                return null;
            }
            return string;
        }
    }
}

