/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.Painter;
import com.jidesoft.swing.JideCursors;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.utils.PortingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ColorUIResource;

public final class JideSplitPaneDivider
extends JPanel
implements PropertyChangeListener {
    protected DragController _dragger;
    private int _dividerSize = UIDefaultsLookup.getInt("JideSplitPane.dividerSize");
    protected JideSplitPane _jideSplitPane;
    private MouseHandler _mouseHandler;
    protected int _orientation;
    static final Cursor HORIZONTAL_CURSOR = JideCursors.getPredefinedCursor(20);
    static final Cursor VERTICAL_CURSOR = JideCursors.getPredefinedCursor(21);
    private Painter _gripperPainter;
    private int _currentState = 1;
    private JButton _leftButton = null;
    private JButton _rightButton = null;
    private int _triangleSize = 5;
    private int _buttonWidth = 5;
    private int _buttonHeight = 10;
    private int _lastPosition;

    public JideSplitPaneDivider(JideSplitPane jPanel) {
        JideSplitPaneDivider jideSplitPaneDivider;
        JideSplitPane jideSplitPane = jPanel;
        JideSplitPaneDivider jideSplitPaneDivider2 = jideSplitPaneDivider = this;
        if (jideSplitPaneDivider._jideSplitPane != null) {
            jideSplitPaneDivider2._jideSplitPane.removePropertyChangeListener(jideSplitPaneDivider2);
            if (jideSplitPaneDivider2._mouseHandler != null) {
                jideSplitPaneDivider2._jideSplitPane.removeMouseListener(jideSplitPaneDivider2._mouseHandler);
                jideSplitPaneDivider2._jideSplitPane.removeMouseMotionListener(jideSplitPaneDivider2._mouseHandler);
                jideSplitPaneDivider2.removeMouseListener(jideSplitPaneDivider2._mouseHandler);
                jideSplitPaneDivider2.removeMouseMotionListener(jideSplitPaneDivider2._mouseHandler);
                jideSplitPaneDivider2._mouseHandler = null;
            }
        }
        jideSplitPaneDivider._jideSplitPane = jideSplitPane;
        jideSplitPaneDivider2 = jideSplitPaneDivider;
        if (jideSplitPaneDivider2._jideSplitPane != null) {
            if (jideSplitPaneDivider2._mouseHandler == null) {
                jideSplitPaneDivider = jideSplitPaneDivider2;
                jideSplitPaneDivider2._mouseHandler = new MouseHandler(jideSplitPaneDivider);
            }
            jideSplitPaneDivider2._jideSplitPane.addMouseListener(jideSplitPaneDivider2._mouseHandler);
            jideSplitPaneDivider2._jideSplitPane.addMouseMotionListener(jideSplitPaneDivider2._mouseHandler);
            jideSplitPaneDivider2.addMouseListener(jideSplitPaneDivider2._mouseHandler);
            jideSplitPaneDivider2.addMouseMotionListener(jideSplitPaneDivider2._mouseHandler);
            jideSplitPaneDivider2._jideSplitPane.addPropertyChangeListener(jideSplitPaneDivider2);
        }
        this._orientation = this._jideSplitPane.getOrientation();
        int n = jPanel.getDividerSize();
        jPanel = this;
        this._dividerSize = n;
        JideSplitPaneDivider jideSplitPaneDivider3 = this;
        jideSplitPaneDivider3.setCursor(jideSplitPaneDivider3._orientation == 1 ? HORIZONTAL_CURSOR : VERTICAL_CURSOR);
        this.setBackground(UIDefaultsLookup.getColor("JideSplitPaneDivider.background"));
        this.setBorder(UIDefaultsLookup.getBorder("JideSplitPaneDivider.border"));
        this.oneTouchExpandableChanged();
        this._gripperPainter = (Painter)UIDefaultsLookup.get("JideSplitPaneDivider.gripperPainter");
        this.setOpaque(false);
        this.setLayout(null);
    }

    public final Dimension getPreferredSize() {
        JideSplitPaneDivider jideSplitPaneDivider = this;
        JideSplitPaneDivider jideSplitPaneDivider2 = jideSplitPaneDivider;
        jideSplitPaneDivider2 = this;
        return new Dimension(jideSplitPaneDivider._dividerSize, jideSplitPaneDivider2._dividerSize);
    }

    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public final void propertyChange(PropertyChangeEvent serializable) {
        if (serializable.getSource() == this._jideSplitPane) {
            if ("orientation".equals(serializable.getPropertyName())) {
                this._orientation = this._jideSplitPane.getOrientation();
                this.setCursor(this._orientation == 1 ? HORIZONTAL_CURSOR : VERTICAL_CURSOR);
                this.invalidate();
                this.validate();
                return;
            }
            if ("oneTouchExpandable".equals(serializable.getPropertyName())) {
                int n = this._jideSplitPane.getDividerSize();
                serializable = this;
                this._dividerSize = n;
                this.oneTouchExpandableChanged();
                return;
            }
            if ("gripper".equals(serializable.getPropertyName())) {
                this.repaint();
            }
        }
    }

    public final void updateUI() {
        super.updateUI();
        this.setBackground(UIDefaultsLookup.getColor("JideSplitPaneDivider.background"));
        this.setBorder(UIDefaultsLookup.getBorder("JideSplitPaneDivider.border"));
        this._gripperPainter = (Painter)UIDefaultsLookup.get("JideSplitPaneDivider.gripperPainter");
    }

    public final void paintComponent(Graphics object) {
        super.paintComponent((Graphics)object);
        Border border = this.getBorder();
        Dimension dimension = this.getSize();
        if (this.isOpaque()) {
            ((Graphics)object).setColor(this.getBackground());
            ((Graphics)object).fillRect(0, 0, dimension.width, dimension.height);
        }
        if (border != null) {
            border.paintBorder(this, (Graphics)object, 0, 0, dimension.width, dimension.height);
        }
        object = this._jideSplitPane;
    }

    protected final void prepareForDragging() {
        this._jideSplitPane.startDragging$51c316b3();
    }

    protected final void dragDividerTo(int n) {
        this._jideSplitPane.dragDividerTo(this, n);
        this._currentState = 1;
        n = this._jideSplitPane.indexOfDivider(this);
        this._lastPosition = this._jideSplitPane.getDividerLocation(n);
    }

    protected final void finishDraggingTo(int n) {
        this._jideSplitPane.finishDraggingTo(this, n);
    }

    protected final int getPreviousDividerLocation(boolean bl, boolean bl2) {
        return this._jideSplitPane.getPreviousDividerLocation(this, bl, bl2);
    }

    protected final int getNextDividerLocation(boolean bl, boolean bl2) {
        return this._jideSplitPane.getNextDividerLocation(this, bl, bl2);
    }

    public final Component getFirstComponent(boolean bl) {
        int n = this._jideSplitPane.indexOf(this);
        if (n - 1 >= 0) {
            for (int i = n - 1; i >= 0; --i) {
                if (!bl && !this._jideSplitPane.getComponent(i).isVisible()) continue;
                return this._jideSplitPane.getComponent(i);
            }
            return this._jideSplitPane.getComponent(n - 1);
        }
        throw new IndexOutOfBoundsException("There is no component before divider " + n);
    }

    public final Component getSecondComponent(boolean bl) {
        int n = this._jideSplitPane.indexOf(this);
        if (n + 1 < this._jideSplitPane.getComponentCount()) {
            for (int i = n + 1; i >= 0; ++i) {
                if (!bl && !this._jideSplitPane.getComponent(i).isVisible()) continue;
                return this._jideSplitPane.getComponent(i);
            }
            return this._jideSplitPane.getComponent(n + 1);
        }
        throw new IndexOutOfBoundsException("There is no component before divider " + n);
    }

    private void oneTouchExpandableChanged() {
        JideSplitPane jideSplitPane = this._jideSplitPane;
        jideSplitPane = this._jideSplitPane;
        jideSplitPane = this._jideSplitPane;
        if (this._leftButton != null) {
            this.remove(this._leftButton);
            this._leftButton = null;
        }
        jideSplitPane = this._jideSplitPane;
        if (this._rightButton != null) {
            this.remove(this._rightButton);
            this._rightButton = null;
        }
        int n = this._jideSplitPane.getPaneCount();
        jideSplitPane = this._jideSplitPane;
        for (int i = 0; i < n; ++i) {
            Component component = this._jideSplitPane.getPaneAt(i);
            PortingUtils.setMinimumSize(component, null);
        }
    }

    static {
        Cursor.getDefaultCursor();
    }

    public final class VerticalDragController
    extends DragController {
        private /* synthetic */ JideSplitPaneDivider this$0;

        protected VerticalDragController(JideSplitPaneDivider jideSplitPaneDivider, MouseEvent mouseEvent) {
            this.this$0 = jideSplitPaneDivider;
            super(jideSplitPaneDivider, mouseEvent);
            Component component = jideSplitPaneDivider.getFirstComponent(false);
            Component component2 = jideSplitPaneDivider.getSecondComponent(false);
            this.initialLocation = jideSplitPaneDivider.getLocation().y;
            this.offset = mouseEvent.getSource() == jideSplitPaneDivider ? mouseEvent.getY() : mouseEvent.getY() - this.initialLocation;
            if (component == null || component2 == null || this.offset < -1 || this.offset >= jideSplitPaneDivider._jideSplitPane.getSize().height) {
                this.maxLocation = -1;
                return;
            }
            this.minLocation = component.isVisible() ? jideSplitPaneDivider.getPreviousDividerLocation(false, false) + component.getMinimumSize().height : 0;
            this.maxLocation = component2.isVisible() ? Math.max(0, jideSplitPaneDivider.getNextDividerLocation(false, false) - jideSplitPaneDivider.getSize().height - component2.getMinimumSize().height) : Math.max(0, jideSplitPaneDivider.getNextDividerLocation(true, false) - jideSplitPaneDivider.getSize().height);
            if (this.maxLocation < this.minLocation) {
                this.maxLocation = 0;
                this.minLocation = 0;
            }
        }

        protected final int getNeededLocation(int n, int n2) {
            n = Math.min(this.maxLocation, Math.max(this.minLocation, n2 - this.offset));
            return n;
        }

        protected final int positionForMouseEvent(MouseEvent mouseEvent) {
            int n = mouseEvent.getSource() == this.this$0 ? mouseEvent.getY() + this.this$0.getLocation().y : mouseEvent.getY();
            n = Math.min(this.maxLocation, Math.max(this.minLocation, n - this.offset));
            return n;
        }
    }

    public class DragController {
        int initialLocation;
        int maxLocation;
        int minLocation;
        int offset;
        private /* synthetic */ JideSplitPaneDivider this$0;

        protected DragController(JideSplitPaneDivider jideSplitPaneDivider, MouseEvent mouseEvent) {
            this.this$0 = jideSplitPaneDivider;
            ComponentOrientation componentOrientation = jideSplitPaneDivider.getComponentOrientation();
            boolean bl = componentOrientation.isLeftToRight();
            bl = !bl && jideSplitPaneDivider._jideSplitPane.getOrientation() == 1;
            Component component = bl ? jideSplitPaneDivider.getSecondComponent(false) : jideSplitPaneDivider.getFirstComponent(false);
            Component component2 = bl ? jideSplitPaneDivider.getFirstComponent(false) : jideSplitPaneDivider.getSecondComponent(false);
            this.initialLocation = jideSplitPaneDivider.getLocation().x;
            this.offset = mouseEvent.getSource() == jideSplitPaneDivider ? mouseEvent.getX() : mouseEvent.getX() - this.initialLocation;
            if (component == null || component2 == null || this.offset < -1 || this.offset >= jideSplitPaneDivider._jideSplitPane.getSize().width) {
                this.maxLocation = -1;
                return;
            }
            this.minLocation = component.isVisible() ? jideSplitPaneDivider.getPreviousDividerLocation(false, bl) + component.getMinimumSize().width : jideSplitPaneDivider.getPreviousDividerLocation(true, bl);
            this.maxLocation = component2.isVisible() ? Math.max(0, jideSplitPaneDivider.getNextDividerLocation(false, bl) - jideSplitPaneDivider.getSize().width - component2.getMinimumSize().width) : Math.max(0, jideSplitPaneDivider.getNextDividerLocation(true, bl) - jideSplitPaneDivider.getSize().width);
            if (this.maxLocation < this.minLocation) {
                this.maxLocation = 0;
                this.minLocation = 0;
            }
        }

        protected int positionForMouseEvent(MouseEvent mouseEvent) {
            int n = mouseEvent.getSource() == this.this$0 ? mouseEvent.getX() + this.this$0.getLocation().x : mouseEvent.getX();
            n = Math.min(this.maxLocation, Math.max(this.minLocation, n - this.offset));
            return n;
        }

        protected int getNeededLocation(int n, int n2) {
            n = Math.min(this.maxLocation, Math.max(this.minLocation, n - this.offset));
            return n;
        }

        protected final void continueDrag(int n, int n2) {
            this.this$0.dragDividerTo(this.getNeededLocation(n, n2));
        }

        protected final void continueDrag(MouseEvent mouseEvent) {
            this.this$0.dragDividerTo(this.positionForMouseEvent(mouseEvent));
        }

        protected final void completeDrag(int n, int n2) {
            this.this$0.finishDraggingTo(this.getNeededLocation(n, n2));
        }

        public DragController() {
        }

        public static Color getDerivedColor(Color color, float f) {
            if (color != null) {
                float f2;
                float f3;
                float f4;
                float f5 = (float)color.getRed() / 256.0f;
                float f6 = (float)color.getGreen() / 256.0f;
                float f7 = (float)color.getBlue() / 256.0f;
                float f8 = Math.max(f5, Math.max(f6, f7));
                float f9 = Math.min(f5, Math.min(f6, f7));
                if (f5 == f6 && f6 == f7) {
                    f6 = 0.0f;
                    f4 = 0.0f;
                    f3 = f5;
                } else {
                    float f10;
                    float f11;
                    f3 = (f9 + f8) / 2.0f;
                    f4 = (double)f11 < 0.5 ? (f8 - f9) / (f8 + f9) : (f8 - f9) / (2.0f - f8 - f9);
                    f6 = f5 == f8 ? (f6 - f7) / (f8 - f9) : (f6 == f8 ? 2.0f + (f7 - f5) / (f8 - f9) : 4.0f + (f5 - f6) / (f8 - f9));
                    f6 /= 6.0f;
                    if (f10 < 0.0f) {
                        f6 += 1.0f;
                    }
                }
                float[] fArray = new float[3];
                float[] fArray2 = fArray;
                fArray[0] = f6;
                fArray2[1] = f4;
                fArray2[2] = f3;
                if ((double)fArray2[2] < 0.4) {
                    fArray2[2] = 0.4f;
                }
                fArray2[2] = (double)f > 0.5 ? (float)((double)fArray2[2] + (double)((1.0f - fArray2[2]) * 2.0f) * ((double)f - 0.5)) : (float)((double)fArray2[2] - (double)(fArray2[2] * 2.0f) * (0.5 - (double)f));
                f6 = fArray2[0];
                f4 = fArray2[1];
                f3 = fArray2[2];
                if (f4 == 0.0f) {
                    f6 = f2 = f3;
                    f5 = f2;
                } else {
                    float f12;
                    float f13;
                    f9 = (double)f3 < 0.5 ? f3 * (f4 + 1.0f) : f3 + f4 - f3 * f4;
                    f8 = f3 * 2.0f - f9;
                    f2 = f6 + 0.33333334f;
                    if (f13 > 1.0f) {
                        f2 -= 1.0f;
                    }
                    f = f6 - 0.33333334f;
                    if (f12 < 0.0f) {
                        f += 1.0f;
                    }
                    f5 = (double)f2 < 0.16666666666666666 ? f8 + (f9 - f8) * 6.0f * f2 : ((double)f2 < 0.5 ? f9 : ((double)f2 < 0.6666666666666666 ? f8 + (f9 - f8) * (0.6666667f - f2) * 6.0f : f8));
                    f6 = (double)f6 < 0.16666666666666666 ? f8 + (f9 - f8) * 6.0f * f6 : ((double)f6 < 0.5 ? f9 : ((double)f6 < 0.6666666666666666 ? f8 + (f9 - f8) * (0.6666667f - f6) * 6.0f : f8));
                    f2 = (double)f < 0.16666666666666666 ? f8 + (f9 - f8) * 6.0f * f : ((double)f < 0.5 ? f9 : ((double)f < 0.6666666666666666 ? f8 + (f9 - f8) * (0.6666667f - f) * 6.0f : f8));
                }
                int n = 0 + (((int)(f5 * 255.0f) & 0xFF) << 16);
                n += ((int)(f6 * 255.0f) & 0xFF) << 8;
                int n2 = n += (int)(f2 * 255.0f) & 0xFF;
                return new ColorUIResource(n2);
            }
            return null;
        }
    }

    public final class MouseHandler
    extends MouseInputAdapter {
        private /* synthetic */ JideSplitPaneDivider this$0;

        protected MouseHandler(JideSplitPaneDivider jideSplitPaneDivider) {
            this.this$0 = jideSplitPaneDivider;
        }

        public final void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == this.this$0 && this.this$0._dragger == null && this.this$0._jideSplitPane.isEnabled()) {
                if (this.this$0.getFirstComponent(true) != null && this.this$0.getSecondComponent(true) != null) {
                    this.this$0._dragger = this.this$0._orientation == 1 ? new DragController(this.this$0, mouseEvent) : new VerticalDragController(this.this$0, mouseEvent);
                    DragController dragController = this.this$0._dragger;
                    if (!(dragController.maxLocation > 0)) {
                        this.this$0._dragger = null;
                    } else {
                        this.this$0.prepareForDragging();
                        this.this$0._dragger.continueDrag(mouseEvent);
                    }
                }
                mouseEvent.consume();
            }
        }

        public final void mouseReleased(MouseEvent mouseEvent) {
            if (this.this$0._dragger != null) {
                if (mouseEvent.getSource() == this.this$0._jideSplitPane) {
                    this.this$0._dragger.completeDrag(mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getSource() == this.this$0) {
                    Point point = this.this$0.getLocation();
                    this.this$0._dragger.completeDrag(mouseEvent.getX() + point.x, mouseEvent.getY() + point.y);
                }
                this.this$0._dragger = null;
                mouseEvent.consume();
            }
        }

        public final void mouseDragged(MouseEvent mouseEvent) {
            if (this.this$0._dragger != null) {
                if (mouseEvent.getSource() == this.this$0._jideSplitPane) {
                    this.this$0._dragger.continueDrag(mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getSource() == this.this$0) {
                    Point point = this.this$0.getLocation();
                    this.this$0._dragger.continueDrag(mouseEvent.getX() + point.x, mouseEvent.getY() + point.y);
                }
                mouseEvent.consume();
            }
        }
    }
}

