/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideScrollPaneConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;

public class JideScrollPaneLayout
extends ScrollPaneLayout
implements JideScrollPaneConstants {
    private JViewport _rowFoot;
    private JViewport _colFoot;
    private Component _hLeft;
    private Component _hRight;
    private Component _vTop;
    private Component _vBottom;

    public void syncWithScrollPane(JScrollPane jScrollPane) {
        super.syncWithScrollPane(jScrollPane);
        if (jScrollPane instanceof JideScrollPane) {
            JideScrollPane jideScrollPane = (JideScrollPane)jScrollPane;
            this._rowFoot = null;
            jideScrollPane = (JideScrollPane)jScrollPane;
            this._colFoot = null;
            this._hLeft = ((JideScrollPane)jScrollPane).getScrollBarCorner("HORIZONTAL_LEFT");
            this._hRight = ((JideScrollPane)jScrollPane).getScrollBarCorner("HORIZONTAL_RIGHT");
            this._vTop = ((JideScrollPane)jScrollPane).getScrollBarCorner("VERTICAL_TOP");
            this._vBottom = ((JideScrollPane)jScrollPane).getScrollBarCorner("VERTICAL_BOTTOM");
        }
    }

    private static boolean isHsbCoversWholeWidth(JScrollPane jScrollPane) {
        if (jScrollPane instanceof JideScrollPane) {
            jScrollPane = (JideScrollPane)jScrollPane;
            return false;
        }
        return false;
    }

    private static boolean isVsbCoversWholeHeight(JScrollPane jScrollPane) {
        if (jScrollPane instanceof JideScrollPane) {
            jScrollPane = (JideScrollPane)jScrollPane;
            return false;
        }
        return false;
    }

    private static boolean isColumnHeadersHeightUnified(JScrollPane jScrollPane) {
        if (jScrollPane instanceof JideScrollPane) {
            jScrollPane = (JideScrollPane)jScrollPane;
            return false;
        }
        return false;
    }

    private static boolean isColumnFootersHeightUnified(JScrollPane jScrollPane) {
        if (jScrollPane instanceof JideScrollPane) {
            jScrollPane = (JideScrollPane)jScrollPane;
            return false;
        }
        return false;
    }

    public void addLayoutComponent(String string, Component component) {
        if (string.equals("ROW_FOOTER")) {
            this._rowFoot = (JViewport)this.addSingletonComponent(this._rowFoot, component);
            return;
        }
        if (string.equals("COLUMN_FOOTER")) {
            this._colFoot = (JViewport)this.addSingletonComponent(this._colFoot, component);
            return;
        }
        if (string.equals("HORIZONTAL_LEFT")) {
            this._hLeft = this.addSingletonComponent(this._hLeft, component);
            return;
        }
        if (string.equals("HORIZONTAL_RIGHT")) {
            this._hRight = this.addSingletonComponent(this._hRight, component);
            return;
        }
        if (string.equals("VERTICAL_TOP")) {
            this._vTop = this.addSingletonComponent(this._vTop, component);
            return;
        }
        if (string.equals("VERTICAL_BOTTOM")) {
            this._vBottom = this.addSingletonComponent(this._vBottom, component);
            return;
        }
        super.addLayoutComponent(string, component);
    }

    public void removeLayoutComponent(Component component) {
        if (component == this._rowFoot) {
            this._rowFoot = null;
            return;
        }
        if (component == this._colFoot) {
            this._colFoot = null;
            return;
        }
        if (component == this._hLeft) {
            this._hLeft = null;
            return;
        }
        if (component == this._hRight) {
            this._hRight = null;
            return;
        }
        if (component == this._vTop) {
            this._vTop = null;
            return;
        }
        if (component == this._vBottom) {
            this._vBottom = null;
            return;
        }
        super.removeLayoutComponent(component);
    }

    public Dimension preferredLayoutSize(Container serializable) {
        Object object = (JScrollPane)serializable;
        this.vsbPolicy = ((JScrollPane)object).getVerticalScrollBarPolicy();
        this.hsbPolicy = ((JScrollPane)object).getHorizontalScrollBarPolicy();
        Insets insets = serializable.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        Dimension dimension = null;
        Dimension dimension2 = null;
        Component component = null;
        if (this.viewport != null) {
            dimension = this.viewport.getPreferredSize();
            dimension2 = this.viewport.getViewSize();
            component = this.viewport.getView();
        }
        if (dimension != null) {
            n += dimension.width;
            n2 += dimension.height;
        }
        if ((object = ((JScrollPane)object).getViewportBorder()) != null) {
            serializable = object.getBorderInsets((Component)serializable);
            n += ((Insets)serializable).left + ((Insets)serializable).right;
            n2 += ((Insets)serializable).top + ((Insets)serializable).bottom;
        }
        int n3 = 0;
        if (this.rowHead != null && this.rowHead.isVisible()) {
            n3 = this.rowHead.getPreferredSize().width;
        }
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            n3 = Math.max(n3, this.upperLeft.getPreferredSize().width);
        }
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            n3 = Math.max(n3, this.lowerLeft.getPreferredSize().width);
        }
        n += n3;
        n3 = this.getUpperHeight();
        n2 += n3;
        if (this._rowFoot != null && this._rowFoot.isVisible()) {
            n += this._rowFoot.getPreferredSize().width;
        }
        n3 = this.getLowerHeight();
        n2 += n3;
        if (this.vsb != null && this.vsbPolicy != 21) {
            if (this.vsbPolicy == 22) {
                n += this.vsb.getPreferredSize().width;
            } else if (dimension2 != null && dimension != null) {
                n3 = 1;
                if (component instanceof Scrollable) {
                    int n4 = n3 = !((Scrollable)((Object)component)).getScrollableTracksViewportHeight() ? 1 : 0;
                }
                if (n3 != 0 && dimension2.height > dimension.height) {
                    n += this.vsb.getPreferredSize().width;
                }
            }
        }
        if (this.hsb != null && this.hsbPolicy != 31) {
            if (this.hsbPolicy == 32) {
                n2 += this.hsb.getPreferredSize().height;
            } else if (dimension2 != null && dimension != null) {
                n3 = 1;
                if (component instanceof Scrollable) {
                    int n5 = n3 = !((Scrollable)((Object)component)).getScrollableTracksViewportWidth() ? 1 : 0;
                }
                if (n3 != 0 && dimension2.width > dimension.width) {
                    n2 += this.hsb.getPreferredSize().height;
                }
            }
        }
        return new Dimension(n, n2);
    }

    private int getUpperHeight() {
        int n = 0;
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            n = this.upperLeft.getPreferredSize().height;
        }
        if (this.upperRight != null && this.upperRight.isVisible()) {
            n = Math.max(this.upperRight.getPreferredSize().height, n);
        }
        if (this.colHead != null && this.colHead.isVisible()) {
            n = Math.max(this.colHead.getPreferredSize().height, n);
        }
        return n;
    }

    private int getLowerHeight() {
        int n = 0;
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            n = this.lowerLeft.getPreferredSize().height;
        }
        if (this.lowerRight != null && this.lowerRight.isVisible()) {
            n = Math.max(this.lowerRight.getPreferredSize().height, n);
        }
        if (this._colFoot != null && this._colFoot.isVisible()) {
            n = Math.max(this._colFoot.getPreferredSize().height, n);
        }
        return n;
    }

    public Dimension minimumLayoutSize(Container serializable) {
        Object object;
        Serializable serializable2 = (JScrollPane)serializable;
        this.vsbPolicy = serializable2.getVerticalScrollBarPolicy();
        this.hsbPolicy = serializable2.getHorizontalScrollBarPolicy();
        Insets insets = serializable.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        if (this.viewport != null) {
            object = this.viewport.getMinimumSize();
            n += ((Dimension)object).width;
            n2 += ((Dimension)object).height;
        }
        if ((object = serializable2.getViewportBorder()) != null) {
            serializable = object.getBorderInsets((Component)serializable);
            n += ((Insets)serializable).left + ((Insets)serializable).right;
            n2 += ((Insets)serializable).top + ((Insets)serializable).bottom;
        }
        int n3 = 0;
        if (this.rowHead != null && this.rowHead.isVisible()) {
            serializable2 = this.rowHead.getMinimumSize();
            n3 = ((Dimension)serializable2).width;
            n2 = Math.max(n2, ((Dimension)serializable2).height);
        }
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            n3 = Math.max(n3, this.upperLeft.getMinimumSize().width);
        }
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            n3 = Math.max(n3, this.lowerLeft.getMinimumSize().width);
        }
        n += n3;
        int n4 = 0;
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            n4 = this.upperLeft.getMinimumSize().height;
        }
        if (this.upperRight != null && this.upperRight.isVisible()) {
            n4 = Math.max(this.upperRight.getMinimumSize().height, n4);
        }
        if (this.colHead != null && this.colHead.isVisible()) {
            Dimension dimension = this.colHead.getMinimumSize();
            n = Math.max(n, dimension.width);
            n4 = Math.max(dimension.height, n4);
        }
        n2 += n4;
        int n5 = 0;
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            n5 = this.lowerLeft.getMinimumSize().height;
        }
        if (this.lowerRight != null && this.lowerRight.isVisible()) {
            n5 = Math.max(this.lowerRight.getMinimumSize().height, n5);
        }
        if (this._colFoot != null && this._colFoot.isVisible()) {
            Dimension dimension = this._colFoot.getMinimumSize();
            n = Math.max(n, dimension.width);
            n5 = Math.max(dimension.height, n5);
        }
        n2 += n5;
        if (this._rowFoot != null && this._rowFoot.isVisible()) {
            Dimension dimension = this._rowFoot.getMinimumSize();
            n = Math.max(n, dimension.width);
            n2 += dimension.height;
        }
        if (this.vsb != null && this.vsbPolicy != 21) {
            Dimension dimension = this.vsb.getMinimumSize();
            n += dimension.width;
            n2 = Math.max(n2, dimension.height);
        }
        if (this.hsb != null && this.hsbPolicy != 31) {
            Dimension dimension = this.hsb.getMinimumSize();
            n = Math.max(n, dimension.width);
            n2 += dimension.height;
        }
        return new Dimension(n, n2);
    }

    public void layoutContainer(Container container) {
        int n;
        int n2;
        int n3;
        Object object;
        JScrollPane jScrollPane = (JScrollPane)container;
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
        Cloneable cloneable = jScrollPane.getBounds();
        cloneable.y = 0;
        jScrollPane.getBounds().x = 0;
        Insets insets = container.getInsets();
        cloneable.x = insets.left;
        cloneable.y = insets.top;
        cloneable.width -= insets.left + insets.right;
        cloneable.height -= insets.top + insets.bottom;
        Rectangle rectangle = new Rectangle(0, cloneable.y, 0, 0);
        int n4 = this.getUpperHeight();
        if (this.colHead != null && this.colHead.isVisible()) {
            rectangle.height = n4 = Math.min(cloneable.height, n4);
            cloneable.y += n4;
            cloneable.height -= n4;
        }
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        if (this.rowHead != null && this.rowHead.isVisible()) {
            int n5 = this.rowHead.getPreferredSize().width;
            if (this.upperLeft != null && this.upperLeft.isVisible()) {
                n5 = Math.max(n5, this.upperLeft.getPreferredSize().width);
            }
            if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
                n5 = Math.max(n5, this.lowerLeft.getPreferredSize().width);
            }
            rectangle2.width = n5;
            cloneable.width -= n5;
            rectangle2.x = cloneable.x;
            cloneable.x += n5;
        }
        if ((object = jScrollPane.getViewportBorder()) != null) {
            object = object.getBorderInsets(container);
            cloneable.x += ((Insets)object).left;
            cloneable.y += ((Insets)object).top;
            cloneable.width -= ((Insets)object).left + ((Insets)object).right;
            cloneable.height -= ((Insets)object).top + ((Insets)object).bottom;
        } else {
            object = new Insets(0, 0, 0, 0);
        }
        Rectangle rectangle3 = new Rectangle(0, 0, 0, 0);
        if (this._rowFoot != null && this._rowFoot.isVisible()) {
            int n6 = this._rowFoot.getPreferredSize().width;
            if (this.upperRight != null && this.upperRight.isVisible()) {
                n6 = Math.max(n6, this.upperRight.getPreferredSize().width);
            }
            if (this.lowerRight != null && this.lowerRight.isVisible()) {
                n6 = Math.max(n6, this.lowerRight.getPreferredSize().width);
            }
            rectangle3.width = n6;
            cloneable.width -= n6;
            rectangle3.x = cloneable.x + cloneable.width;
        }
        Rectangle rectangle4 = new Rectangle(0, cloneable.y, 0, 0);
        int n7 = this.getLowerHeight();
        if (this._colFoot != null && this._colFoot.isVisible()) {
            rectangle4.height = n7 = Math.min(cloneable.height, n7);
            cloneable.height -= n7;
            rectangle4.y = cloneable.y + cloneable.height;
        }
        Object object2 = this.viewport != null ? this.viewport.getView() : null;
        Dimension dimension = object2 != null ? ((Component)object2).getPreferredSize() : new Dimension(0, 0);
        Dimension dimension2 = this.viewport != null ? this.viewport.toViewCoordinates(cloneable.getSize()) : new Dimension(0, 0);
        boolean bl = false;
        boolean bl2 = false;
        int n8 = cloneable.width < 0 || cloneable.height < 0 ? 1 : 0;
        if (n8 == 0 && object2 instanceof Scrollable) {
            object2 = (Scrollable)object2;
            bl = object2.getScrollableTracksViewportWidth();
            bl2 = object2.getScrollableTracksViewportHeight();
        } else {
            object2 = null;
        }
        Rectangle rectangle5 = new Rectangle(0, JideScrollPaneLayout.isVsbCoversWholeHeight(jScrollPane) ? insets.top : cloneable.y - ((Insets)object).top, 0, 0);
        int n9 = this.vsbPolicy == 22 ? 1 : (n3 = this.vsbPolicy != 21 && n8 == 0 && !bl2 && (dimension.height > dimension2.height || this.rowHead != null && this.rowHead.getView() != null && this.rowHead.getView().getPreferredSize().height > dimension2.height) ? 1 : 0);
        if (this.vsb != null && n3 != 0) {
            this.adjustForVSB(true, (Rectangle)cloneable, rectangle5, (Insets)object, true);
            dimension2 = this.viewport.toViewCoordinates(cloneable.getSize());
        }
        Rectangle rectangle6 = new Rectangle(JideScrollPaneLayout.isHsbCoversWholeWidth(jScrollPane) ? insets.left : cloneable.x - ((Insets)object).left, 0, 0, 0);
        int n10 = this.hsbPolicy == 32 ? 1 : (n8 = this.hsbPolicy != 31 && n8 == 0 && !bl && (dimension.width > dimension2.width || this.colHead != null && this.colHead.getView() != null && this.colHead.getView().getPreferredSize().width > dimension2.width) ? 1 : 0);
        if (this.hsb != null && n8 != 0) {
            this.adjustForHSB(true, (Rectangle)cloneable, rectangle6, (Insets)object);
            if (this.vsb != null && n3 == 0 && this.vsbPolicy != 21) {
                dimension2 = this.viewport.toViewCoordinates(cloneable.getSize());
                n3 = dimension.height > dimension2.height ? 1 : 0;
                if (n3 != 0) {
                    this.adjustForVSB(true, (Rectangle)cloneable, rectangle5, (Insets)object, true);
                }
            }
        }
        boolean bl3 = jScrollPane.getComponentOrientation().isLeftToRight();
        if (this.viewport != null) {
            this.viewport.setBounds(JideScrollPaneLayout.adjustBounds(container, cloneable, bl3));
            if (object2 != null) {
                int n11;
                int n12;
                dimension2 = this.viewport.toViewCoordinates(cloneable.getSize());
                n2 = n8;
                n = n3;
                bl = object2.getScrollableTracksViewportWidth();
                bl2 = object2.getScrollableTracksViewportHeight();
                if (this.vsb != null && this.vsbPolicy == 20 && (n12 = !bl2 && (dimension.height > dimension2.height || this.rowHead != null && this.rowHead.getView() != null && this.rowHead.getView().getPreferredSize().height > dimension2.height) ? 1 : 0) != n3) {
                    n3 = n12;
                    this.adjustForVSB(n3 != 0, (Rectangle)cloneable, rectangle5, (Insets)object, true);
                    dimension2 = this.viewport.toViewCoordinates(cloneable.getSize());
                }
                if (this.hsb != null && this.hsbPolicy == 30 && (n11 = !bl && (dimension.width > dimension2.width || this.colHead != null && this.colHead.getView() != null && this.colHead.getView().getPreferredSize().width > dimension2.width) ? 1 : 0) != n8) {
                    n8 = n11;
                    this.adjustForHSB(n8 != 0, (Rectangle)cloneable, rectangle6, (Insets)object);
                    if (this.vsb != null && n3 == 0 && this.vsbPolicy != 21) {
                        dimension2 = this.viewport.toViewCoordinates(cloneable.getSize());
                        n3 = dimension.height > dimension2.height ? 1 : 0;
                        if (n3 != 0) {
                            this.adjustForVSB(true, (Rectangle)cloneable, rectangle5, (Insets)object, true);
                        }
                    }
                    if (this._rowFoot != null && this._rowFoot.isVisible()) {
                        rectangle5.x += rectangle3.width;
                    }
                }
                if (n2 != n8 || n != n3) {
                    this.viewport.setBounds(JideScrollPaneLayout.adjustBounds(container, cloneable, bl3));
                }
            }
        }
        rectangle5.height = JideScrollPaneLayout.isVsbCoversWholeHeight(jScrollPane) ? jScrollPane.getHeight() - insets.bottom - insets.top : cloneable.height + ((Insets)object).top + ((Insets)object).bottom;
        rectangle6.width = JideScrollPaneLayout.isHsbCoversWholeWidth(jScrollPane) ? jScrollPane.getWidth() - rectangle5.width - insets.left - insets.right : cloneable.width + ((Insets)object).left + ((Insets)object).right;
        rectangle2.height = cloneable.height + ((Insets)object).top + ((Insets)object).bottom;
        rectangle2.y = cloneable.y - ((Insets)object).top;
        rectangle.width = cloneable.width + ((Insets)object).left + ((Insets)object).right;
        rectangle.x = cloneable.x - ((Insets)object).left;
        rectangle4.x = cloneable.x;
        rectangle4.y = rectangle2.y + rectangle2.height;
        rectangle4.width = cloneable.width;
        rectangle3.x = cloneable.x + cloneable.width;
        rectangle3.y = cloneable.y;
        rectangle3.height = cloneable.height;
        rectangle5.x += rectangle3.width;
        rectangle6.y += rectangle4.height;
        if (this.rowHead != null) {
            this.rowHead.setBounds(JideScrollPaneLayout.adjustBounds(container, rectangle2, bl3));
        }
        if (this._rowFoot != null) {
            this._rowFoot.setBounds(JideScrollPaneLayout.adjustBounds(container, rectangle3, bl3));
        }
        int n13 = JideScrollPaneLayout.isColumnHeadersHeightUnified(jScrollPane) ? Math.max(rectangle.height, Math.max(this.upperLeft == null ? 0 : this.upperLeft.getPreferredSize().height, this.upperRight == null ? 0 : this.upperRight.getPreferredSize().height)) : (n2 = 0);
        int n14 = JideScrollPaneLayout.isColumnFootersHeightUnified(jScrollPane) ? Math.max(rectangle4.height, Math.max(this.lowerLeft == null ? 0 : this.lowerLeft.getPreferredSize().height, this.lowerRight == null ? 0 : this.lowerRight.getPreferredSize().height)) : (n = 0);
        if (this.colHead != null) {
            int n15 = JideScrollPaneLayout.isColumnHeadersHeightUnified(jScrollPane) ? n2 : Math.min(rectangle.height, this.colHead.getPreferredSize().height);
            this.colHead.setBounds(JideScrollPaneLayout.adjustBounds(container, new Rectangle(rectangle.x, rectangle.y + rectangle.height - n15, rectangle.width, n15), bl3));
        }
        if (this._colFoot != null) {
            int n16 = JideScrollPaneLayout.isColumnFootersHeightUnified(jScrollPane) ? n : Math.min(rectangle4.height, this._colFoot.getPreferredSize().height);
            this._colFoot.setBounds(JideScrollPaneLayout.adjustBounds(container, new Rectangle(rectangle4.x, rectangle4.y, rectangle4.width, n16), bl3));
        } else if (JideScrollPaneLayout.isColumnFootersHeightUnified(jScrollPane)) {
            n = rectangle6.height;
        }
        if (this.vsb != null) {
            if (n3 != 0) {
                this.vsb.setVisible(true);
                if (this._vTop == null && this._vBottom == null) {
                    this.vsb.setBounds(JideScrollPaneLayout.adjustBounds(container, rectangle5, bl3));
                } else {
                    Rectangle rectangle7 = new Rectangle(rectangle5);
                    if (this._vTop != null) {
                        cloneable = this._vTop.getPreferredSize();
                        rectangle7.y += ((Dimension)cloneable).height;
                        rectangle7.height -= ((Dimension)cloneable).height;
                        this._vTop.setVisible(true);
                        this._vTop.setBounds(JideScrollPaneLayout.adjustBounds(container, new Rectangle(rectangle5.x, rectangle5.y, rectangle5.width, ((Dimension)cloneable).height), bl3));
                    }
                    if (this._vBottom != null) {
                        cloneable = this._vBottom.getPreferredSize();
                        rectangle7.height -= ((Dimension)cloneable).height;
                        this._vBottom.setVisible(true);
                        this._vBottom.setBounds(JideScrollPaneLayout.adjustBounds(container, new Rectangle(rectangle5.x, rectangle5.y + rectangle5.height - ((Dimension)cloneable).height, rectangle5.width, ((Dimension)cloneable).height), bl3));
                    }
                    this.vsb.setBounds(JideScrollPaneLayout.adjustBounds(container, rectangle7, bl3));
                }
            } else {
                if (dimension.height > dimension2.height) {
                    this.vsb.setVisible(true);
                    this.vsb.setBounds(JideScrollPaneLayout.adjustBounds(container, new Rectangle(rectangle5.x, rectangle5.y, 0, rectangle5.height), bl3));
                } else {
                    this.vsb.setVisible(false);
                }
                if (this._vTop != null) {
                    this._vTop.setVisible(false);
                }
                if (this._vBottom != null) {
                    this._vBottom.setVisible(false);
                }
            }
        }
        if (this.hsb != null) {
            if (n8 != 0) {
                this.hsb.setVisible(true);
                if (this._hLeft == null && this._hRight == null) {
                    this.hsb.setBounds(JideScrollPaneLayout.adjustBounds(container, rectangle6, bl3));
                } else {
                    Rectangle rectangle8 = new Rectangle(rectangle6);
                    if (this._hLeft != null) {
                        cloneable = this._hLeft.getPreferredSize();
                        rectangle8.x += ((Dimension)cloneable).width;
                        rectangle8.width -= ((Dimension)cloneable).width;
                        this._hLeft.setVisible(true);
                        this._hLeft.setBounds(JideScrollPaneLayout.adjustBounds(container, new Rectangle(rectangle6.x, rectangle6.y, ((Dimension)cloneable).width, rectangle6.height), bl3));
                        this._hLeft.doLayout();
                    }
                    if (this._hRight != null) {
                        cloneable = this._hRight.getPreferredSize();
                        rectangle8.width -= ((Dimension)cloneable).width;
                        this._hRight.setVisible(true);
                        this._hRight.setBounds(JideScrollPaneLayout.adjustBounds(container, new Rectangle(rectangle6.x + rectangle6.width - ((Dimension)cloneable).width, rectangle6.y, ((Dimension)cloneable).width, rectangle6.height), bl3));
                    }
                    this.hsb.setBounds(JideScrollPaneLayout.adjustBounds(container, rectangle8, bl3));
                }
            } else {
                if (dimension.width > dimension2.width) {
                    this.hsb.setVisible(true);
                    this.hsb.setBounds(JideScrollPaneLayout.adjustBounds(container, new Rectangle(rectangle6.x, rectangle6.y, rectangle6.width, 0), bl3));
                } else {
                    this.hsb.setVisible(false);
                }
                if (this._hLeft != null) {
                    this._hLeft.setVisible(false);
                }
                if (this._hRight != null) {
                    this._hRight.setVisible(false);
                }
            }
        }
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            int n17 = JideScrollPaneLayout.isColumnFootersHeightUnified(jScrollPane) ? n : Math.min(this.lowerLeft.getPreferredSize().height, rectangle4.height);
            this.lowerLeft.setBounds(JideScrollPaneLayout.adjustBounds(container, new Rectangle(rectangle2.x, rectangle4.y != 0 ? rectangle4.y : rectangle6.y, rectangle2.width, n17), bl3));
        }
        if (this.lowerRight != null && this.lowerRight.isVisible()) {
            int n18 = JideScrollPaneLayout.isColumnFootersHeightUnified(jScrollPane) ? n : Math.min(this.lowerRight.getPreferredSize().height, rectangle4.height);
            this.lowerRight.setBounds(JideScrollPaneLayout.adjustBounds(container, new Rectangle(rectangle3.x, rectangle4.y != 0 ? rectangle4.y : rectangle6.y, rectangle3.width + (JideScrollPaneLayout.isVsbCoversWholeHeight(jScrollPane) ? 0 : rectangle5.width), n18), bl3));
        }
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            int n19 = JideScrollPaneLayout.isColumnHeadersHeightUnified(jScrollPane) ? n2 : Math.min(this.upperLeft.getPreferredSize().height, rectangle.height);
            this.upperLeft.setBounds(JideScrollPaneLayout.adjustBounds(container, new Rectangle(rectangle2.x, rectangle.y + rectangle.height - n19, rectangle2.width, n19), bl3));
        }
        if (this.upperRight != null && this.upperRight.isVisible()) {
            int n20 = JideScrollPaneLayout.isColumnHeadersHeightUnified(jScrollPane) ? n2 : Math.min(this.upperRight.getPreferredSize().height, rectangle.height);
            this.upperRight.setBounds(JideScrollPaneLayout.adjustBounds(container, new Rectangle(rectangle3.x, rectangle.y + rectangle.height - n20, rectangle3.width + (JideScrollPaneLayout.isVsbCoversWholeHeight(jScrollPane) ? 0 : rectangle5.width), n20), bl3));
        }
    }

    private static Rectangle adjustBounds(Container container, Rectangle rectangle, boolean bl) {
        if (bl) {
            return rectangle;
        }
        Rectangle rectangle2 = new Rectangle(rectangle);
        int n = container.getWidth();
        rectangle2.x = n - (rectangle.x + rectangle.width);
        return rectangle2;
    }

    /*
     * WARNING - void declaration
     */
    private void adjustForVSB(boolean bl, Rectangle rectangle, Rectangle rectangle2, Insets insets, boolean bl2) {
        void var3_4;
        int n = var3_4.width;
        if (bl) {
            void var4_5;
            void var2_3;
            int n2 = Math.max(0, this.vsb.getPreferredSize().width);
            var2_3.width -= n2;
            var3_4.width = n2;
            var3_4.x = var2_3.x + var2_3.width + var4_5.right;
            return;
        }
        var2_3.width += n;
    }

    /*
     * WARNING - void declaration
     */
    private void adjustForHSB(boolean bl, Rectangle rectangle, Rectangle rectangle2, Insets insets) {
        void var3_4;
        int n = var3_4.height;
        if (bl) {
            void var4_5;
            void var2_3;
            int n2 = Math.max(0, this.hsb.getPreferredSize().height);
            var2_3.height -= n2;
            var3_4.y = var2_3.y + var2_3.height + var4_5.bottom;
            var3_4.height = n2;
            return;
        }
        var2_3.height += n;
    }

    static final class UIResource
    extends JideScrollPaneLayout
    implements javax.swing.plaf.UIResource {
        UIResource() {
        }
    }
}

